/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.api.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class Job
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_JOB_TYPE = "job_type";
    @SerializedName(value="job_type")
    private JobTypeEnum jobType;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_MESSAGES = "messages";
    @SerializedName(value="messages")
    private List<String> messages = null;

    public Job jobType(JobTypeEnum jobType) {
        this.jobType = jobType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public JobTypeEnum getJobType() {
        return this.jobType;
    }

    public void setJobType(JobTypeEnum jobType) {
        this.jobType = jobType;
    }

    public Job status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Job messages(List<String> messages) {
        this.messages = messages;
        return this;
    }

    public Job addMessagesItem(String messagesItem) {
        if (this.messages == null) {
            this.messages = new ArrayList<String>();
        }
        this.messages.add(messagesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"started import of corpus GUM\",\"reading GraphML\",\"Error during import of GUM: corpus already exists\"]", value="")
    public List<String> getMessages() {
        return this.messages;
    }

    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        return Objects.equals((Object)this.jobType, (Object)job.jobType) && Objects.equals((Object)this.status, (Object)job.status) && Objects.equals(this.messages, job.messages);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobType, this.status, this.messages});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Job {\n");
        sb.append("    jobType: ").append(this.toIndentedString((Object)this.jobType)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    messages: ").append(this.toIndentedString(this.messages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        RUNNING("Running"),
        FAILED("Failed"),
        FINISHED("Finished");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum JobTypeEnum {
        IMPORT("Import"),
        EXPORT("Export");

        private String value;

        private JobTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static JobTypeEnum fromValue(String value) {
            for (JobTypeEnum b : JobTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<JobTypeEnum> {
            public void write(JsonWriter jsonWriter, JobTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public JobTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return JobTypeEnum.fromValue(value);
            }
        }
    }
}

