/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Description of an attribute of a query.")
public class QueryAttributeDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ALTERNATIVE = "alternative";
    @SerializedName(value="alternative")
    private Integer alternative;
    public static final String SERIALIZED_NAME_QUERY_FRAGMENT = "query_fragment";
    @SerializedName(value="query_fragment")
    private String queryFragment;
    public static final String SERIALIZED_NAME_VARIABLE = "variable";
    @SerializedName(value="variable")
    private String variable;
    public static final String SERIALIZED_NAME_ANNO_NAME = "anno_name";
    @SerializedName(value="anno_name")
    private String annoName;

    public QueryAttributeDescription alternative(Integer alternative) {
        this.alternative = alternative;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the alternative this attribute is part of.")
    public Integer getAlternative() {
        return this.alternative;
    }

    public void setAlternative(Integer alternative) {
        this.alternative = alternative;
    }

    public QueryAttributeDescription queryFragment(String queryFragment) {
        this.queryFragment = queryFragment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Textual representation of the query fragment for this attribute.")
    public String getQueryFragment() {
        return this.queryFragment;
    }

    public void setQueryFragment(String queryFragment) {
        this.queryFragment = queryFragment;
    }

    public QueryAttributeDescription variable(String variable) {
        this.variable = variable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Variable name of this attribute.")
    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public QueryAttributeDescription annoName(String annoName) {
        this.annoName = annoName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional annotation name represented by this attribute.")
    public String getAnnoName() {
        return this.annoName;
    }

    public void setAnnoName(String annoName) {
        this.annoName = annoName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryAttributeDescription queryAttributeDescription = (QueryAttributeDescription)o;
        return Objects.equals(this.alternative, queryAttributeDescription.alternative) && Objects.equals(this.queryFragment, queryAttributeDescription.queryFragment) && Objects.equals(this.variable, queryAttributeDescription.variable) && Objects.equals(this.annoName, queryAttributeDescription.annoName);
    }

    public int hashCode() {
        return Objects.hash(this.alternative, this.queryFragment, this.variable, this.annoName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryAttributeDescription {\n");
        sb.append("    alternative: ").append(this.toIndentedString(this.alternative)).append("\n");
        sb.append("    queryFragment: ").append(this.toIndentedString(this.queryFragment)).append("\n");
        sb.append("    variable: ").append(this.toIndentedString(this.variable)).append("\n");
        sb.append("    annoName: ").append(this.toIndentedString(this.annoName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

