/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.api.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A rule when to trigger a visualizer for a specific result.")
public class VisualizerRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ELEMENT = "element";
    @SerializedName(value="element")
    private ElementEnum element;
    public static final String SERIALIZED_NAME_LAYER = "layer";
    @SerializedName(value="layer")
    private String layer;
    public static final String SERIALIZED_NAME_VIS_TYPE = "vis_type";
    @SerializedName(value="vis_type")
    private String visType;
    public static final String SERIALIZED_NAME_DISPLAY_NAME = "display_name";
    @SerializedName(value="display_name")
    private String displayName;
    public static final String SERIALIZED_NAME_VISIBILITY = "visibility";
    @SerializedName(value="visibility")
    private VisibilityEnum visibility;
    public static final String SERIALIZED_NAME_MAPPINGS = "mappings";
    @SerializedName(value="mappings")
    private Map<String, String> mappings = null;

    public VisualizerRule element(ElementEnum element) {
        this.element = element;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="On which element type to trigger the visualizer on")
    public ElementEnum getElement() {
        return this.element;
    }

    public void setElement(ElementEnum element) {
        this.element = element;
    }

    public VisualizerRule layer(String layer) {
        this.layer = layer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="In which layer the element needs to be part of to trigger this visualizer.  Only relevant for edges, since only they are part of layers. If not given, elements of all layers trigger this visualization. ")
    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    public VisualizerRule visType(String visType) {
        this.visType = visType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The abstract type of visualization, e.g. \"tree\", \"discourse\", \"grid\", ...")
    public String getVisType() {
        return this.visType;
    }

    public void setVisType(String visType) {
        this.visType = visType;
    }

    public VisualizerRule displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A text displayed to the user describing this visualization")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public VisualizerRule visibility(VisibilityEnum visibility) {
        this.visibility = visibility;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default display state of the visualizer before any user interaction.")
    public VisibilityEnum getVisibility() {
        return this.visibility;
    }

    public void setVisibility(VisibilityEnum visibility) {
        this.visibility = visibility;
    }

    public VisualizerRule mappings(Map<String, String> mappings) {
        this.mappings = mappings;
        return this;
    }

    public VisualizerRule putMappingsItem(String key, String mappingsItem) {
        if (this.mappings == null) {
            this.mappings = new HashMap<String, String>();
        }
        this.mappings.put(key, mappingsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Additional configuration given as generic map of key values to the visualizer.")
    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VisualizerRule visualizerRule = (VisualizerRule)o;
        return Objects.equals((Object)this.element, (Object)visualizerRule.element) && Objects.equals(this.layer, visualizerRule.layer) && Objects.equals(this.visType, visualizerRule.visType) && Objects.equals(this.displayName, visualizerRule.displayName) && Objects.equals((Object)this.visibility, (Object)visualizerRule.visibility) && Objects.equals(this.mappings, visualizerRule.mappings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.element, this.layer, this.visType, this.displayName, this.visibility, this.mappings});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VisualizerRule {\n");
        sb.append("    element: ").append(this.toIndentedString((Object)this.element)).append("\n");
        sb.append("    layer: ").append(this.toIndentedString(this.layer)).append("\n");
        sb.append("    visType: ").append(this.toIndentedString(this.visType)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString((Object)this.visibility)).append("\n");
        sb.append("    mappings: ").append(this.toIndentedString(this.mappings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VisibilityEnum {
        HIDDEN("hidden"),
        VISIBLE("visible"),
        PERMANENT("permanent"),
        PRELOADED("preloaded");

        private String value;

        private VisibilityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VisibilityEnum fromValue(String value) {
            for (VisibilityEnum b : VisibilityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<VisibilityEnum> {
            public void write(JsonWriter jsonWriter, VisibilityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VisibilityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VisibilityEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ElementEnum {
        NODE("node"),
        EDGE("edge");

        private String value;

        private ElementEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ElementEnum fromValue(String value) {
            for (ElementEnum b : ElementEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ElementEnum> {
            public void write(JsonWriter jsonWriter, ElementEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ElementEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ElementEnum.fromValue(value);
            }
        }
    }
}

