/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.Version;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.corpus_tools.annis.gui.IDGenerator;
import org.corpus_tools.annis.gui.VersionInfo;
import org.corpus_tools.annis.gui.components.ExceptionDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class AboutWindow
extends Window {
    private static final long serialVersionUID = -7355736941508460795L;
    private static final Logger log = LoggerFactory.getLogger(AboutWindow.class);
    private VerticalLayout layout;
    private Button btClose;
    private TextArea txtThirdParty;

    public AboutWindow() {
        this.setSizeFull();
        this.layout = new VerticalLayout();
        this.setContent((Component)this.layout);
        this.layout.setSizeFull();
        this.layout.setMargin(true);
        HorizontalLayout hLayout = new HorizontalLayout();
        Image logoAnnis = new Image();
        logoAnnis.setSource((Resource)new ThemeResource("images/annis-logo-128.png"));
        hLayout.addComponent((Component)logoAnnis);
        Image logoSfb = new Image();
        logoSfb.setSource((Resource)new ThemeResource("images/sfb-logo.jpg"));
        hLayout.addComponent((Component)logoSfb);
        Link lnkFork = new Link();
        lnkFork.setResource((Resource)new ExternalResource("https://github.com/korpling/ANNIS"));
        lnkFork.setIcon((Resource)new ExternalResource("https://s3.amazonaws.com/github/ribbons/forkme_right_red_aa0000.png"));
        lnkFork.setTargetName("_blank");
        hLayout.addComponent((Component)lnkFork);
        hLayout.setComponentAlignment((Component)logoAnnis, Alignment.MIDDLE_LEFT);
        hLayout.setComponentAlignment((Component)logoSfb, Alignment.MIDDLE_RIGHT);
        hLayout.setComponentAlignment((Component)lnkFork, Alignment.TOP_RIGHT);
        this.layout.addComponent((Component)hLayout);
        this.layout.addComponent((Component)new Label("ANNIS is a project of the <a href=\"http://www.sfb632.uni-potsdam.de/\">SFB632</a>.", ContentMode.HTML));
        this.layout.addComponent((Component)new Label("Homepage: <a href=\"http://corpus-tools.org/annis/\">http://corpus-tools.org/annis/</a>.", ContentMode.HTML));
        this.layout.addComponent((Component)new Label("Version: " + VersionInfo.getVersion()));
        this.layout.addComponent((Component)new Label("Vaadin-Version: " + Version.getFullVersion()));
        this.txtThirdParty = new TextArea();
        this.txtThirdParty.setSizeFull();
        this.txtThirdParty.setReadOnly(true);
        this.txtThirdParty.addStyleName("shared-text");
        this.txtThirdParty.setWordWrap(false);
        this.layout.addComponent((Component)this.txtThirdParty);
        this.btClose = new Button("Close");
        AboutWindow finalThis = this;
        this.btClose.addClickListener((Button.ClickListener)new OkClickListener(finalThis));
        this.layout.addComponent((Component)this.btClose);
        this.layout.setComponentAlignment((Component)hLayout, Alignment.MIDDLE_CENTER);
        this.layout.setComponentAlignment((Component)this.btClose, Alignment.MIDDLE_CENTER);
        this.layout.setExpandRatio((Component)this.txtThirdParty, 1.0f);
    }

    public void attach() {
        super.attach();
        IDGenerator.assignIDForFields((HasComponents)this, new Component[]{this.btClose});
        try {
            File citationFile = new ClassPathResource("CITATION.cff").getFile();
            this.txtThirdParty.setValue(FileUtils.readFileToString((File)citationFile));
        }
        catch (IOException ex) {
            ExceptionDialog.show(ex, this.getUI());
        }
    }

    private static class OkClickListener
    implements Button.ClickListener {
        private static final long serialVersionUID = -4082849367760765188L;
        private final AboutWindow finalThis;

        public OkClickListener(AboutWindow finalThis) {
            this.finalThis = finalThis;
        }

        public void buttonClick(Button.ClickEvent event) {
            UI.getCurrent().removeWindow((Window)this.finalThis);
        }
    }
}

