/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.ui.Table;
import java.util.HashSet;
import java.util.Set;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.QueryGenerator;
import org.corpus_tools.annis.gui.beans.CitationProvider;
import org.corpus_tools.annis.gui.objects.ContextualizedQuery;
import org.corpus_tools.annis.gui.objects.DisplayedResultQuery;
import org.corpus_tools.annis.gui.objects.Query;
import org.corpus_tools.annis.gui.query_references.ShareQueryReferenceWindow;

public class CitationLinkGenerator
implements Table.ColumnGenerator,
Button.ClickListener {
    private static final long serialVersionUID = -3225593134882374700L;

    public void buttonClick(Button.ClickEvent event) {
    }

    public Object generateCell(Table source, Object itemId, Object columnId) {
        Button btLink = new Button();
        btLink.addStyleName("borderless");
        btLink.setIcon((Resource)VaadinIcons.CONNECT);
        btLink.setDescription("Share query reference link");
        btLink.addClickListener((Button.ClickListener)this);
        if (itemId instanceof DisplayedResultQuery) {
            btLink.addClickListener((Button.ClickListener)new LinkClickListener((DisplayedResultQuery)itemId));
        } else if (itemId instanceof Query) {
            CitationProviderForQuery citationProvider = new CitationProviderForQuery((Query)itemId);
            btLink.addClickListener((Button.ClickListener)new LinkClickListener(citationProvider));
        } else if (itemId instanceof CitationProvider) {
            CitationProvider citationProvider = (CitationProvider)itemId;
            btLink.addClickListener((Button.ClickListener)new LinkClickListener(citationProvider));
        }
        return btLink;
    }

    private static class LinkClickListener
    implements Button.ClickListener {
        private static final long serialVersionUID = 7347095995969160586L;
        private final CitationProvider citationProvider;
        private final DisplayedResultQuery query;

        public LinkClickListener(CitationProvider citationProvider) {
            this.citationProvider = citationProvider;
            this.query = null;
        }

        public LinkClickListener(DisplayedResultQuery query) {
            this.citationProvider = null;
            this.query = query;
        }

        public void buttonClick(Button.ClickEvent event) {
            UI ui = UI.getCurrent();
            boolean desktopMode = false;
            if (ui instanceof AnnisUI) {
                desktopMode = ((AnnisUI)ui).isDesktopMode();
            }
            if (this.query != null) {
                ShareQueryReferenceWindow c = new ShareQueryReferenceWindow(this.query, !desktopMode);
                UI.getCurrent().addWindow((Window)c);
                c.center();
            } else if (this.citationProvider != null) {
                ShareQueryReferenceWindow c = new ShareQueryReferenceWindow((DisplayedResultQuery)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)QueryGenerator.displayed().query(this.citationProvider.getQuery())).corpora(this.citationProvider.getCorpora())).left(this.citationProvider.getLeftContext())).right(this.citationProvider.getRightContext())).offset(0L)).limit(10)).build(), !desktopMode);
                UI.getCurrent().addWindow((Window)c);
                c.center();
            } else {
                Notification.show((String)"Internal error", (String)"No valid citation link was found", (Notification.Type)Notification.Type.WARNING_MESSAGE);
            }
        }
    }

    private static class CitationProviderForQuery
    implements CitationProvider {
        private final Query query;

        public CitationProviderForQuery(Query query) {
            this.query = query;
        }

        @Override
        public Set<String> getCorpora() {
            if (this.query == null) {
                return new HashSet<String>();
            }
            return this.query.getCorpora();
        }

        @Override
        public int getLeftContext() {
            if (this.query instanceof ContextualizedQuery) {
                return ((ContextualizedQuery)this.query).getLeftContext();
            }
            return 5;
        }

        @Override
        public String getQuery() {
            if (this.query == null) {
                return null;
            }
            return this.query.getQuery();
        }

        @Override
        public int getRightContext() {
            if (this.query instanceof ContextualizedQuery) {
                return ((ContextualizedQuery)this.query).getRightContext();
            }
            return 5;
        }
    }
}

