/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.vaadin.data.ValueProvider;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Grid;
import com.vaadin.ui.Label;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.api.model.CorpusConfiguration;
import org.corpus_tools.annis.api.model.ExampleQuery;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Background;
import org.corpus_tools.annis.gui.HelpPanel;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.controlpanel.ControlPanel;
import org.corpus_tools.annis.gui.controlpanel.CorpusListPanel;
import org.corpus_tools.annis.gui.controlpanel.QueryPanel;
import org.corpus_tools.annis.gui.objects.Query;
import org.corpus_tools.annis.gui.objects.QueryLanguage;
import org.corpus_tools.annis.gui.resultview.ResultViewPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleQueriesPanel
extends CssLayout {
    private static final long serialVersionUID = -2676130295297213669L;
    private static final Logger log = LoggerFactory.getLogger(ExampleQueriesPanel.class);
    private static final Resource SEARCH_ICON = VaadinIcons.SEARCH;
    private final String COLUMN_EXAMPLE_QUERY = "exampleQuery";
    private final String COLUMN_OPEN_CORPUS_BROWSER = "open corpus browser";
    private final String COLUMN_DESCRIPTION = "description";
    private final AnnisUI ui;
    private final Grid<Entry> table;
    private final ProgressBar loadingIndicator;
    private TabSheet.Tab tab;
    private final HelpPanel parentTab;

    private static List<Entry> loadExamplesFromRemote(Set<String> corpusNames, UI ui) {
        LinkedList<Entry> result = new LinkedList<Entry>();
        CorporaApi api = new CorporaApi(Helper.getClient(ui));
        try {
            if (corpusNames != null && !corpusNames.isEmpty()) {
                for (String c : corpusNames) {
                    CorpusConfiguration config = api.corpusConfiguration(c);
                    if (config.getExampleQueries() == null) continue;
                    for (ExampleQuery q : config.getExampleQueries()) {
                        Entry e = new Entry();
                        e.corpus = c;
                        e.example = q;
                        result.add(e);
                    }
                }
            }
        }
        catch (ApiException ex) {
            log.error("problems with getting example queries from remote for {}", corpusNames, (Object)ex);
        }
        return result;
    }

    public ExampleQueriesPanel(AnnisUI ui, HelpPanel parentTab) {
        this.ui = ui;
        this.parentTab = parentTab;
        this.loadingIndicator = new ProgressBar();
        this.loadingIndicator.setIndeterminate(true);
        this.loadingIndicator.setCaption("Loading example queries...");
        this.loadingIndicator.setVisible(false);
        this.addComponent((Component)this.loadingIndicator);
        this.table = new Grid();
        this.table.setVisible(true);
        this.addComponent((Component)this.table);
        this.setUpTable();
    }

    private Component getOpenCorpusPanel(String corpusName) {
        Button btn = new Button(corpusName);
        btn.setStyleName("link");
        btn.addClickListener((Button.ClickListener & Serializable)event -> {
            CorpusListPanel corpusList = this.ui.getSearchView().getControlPanel().getCorpusList();
            corpusList.initCorpusBrowser(corpusName, btn);
        });
        return btn;
    }

    private void hideTabSheet() {
        if (this.parentTab != null) {
            this.tab = this.parentTab.getTab((Component)this);
            if (this.tab != null) {
                this.tab.setEnabled(false);
            }
        }
    }

    public void setSelectedCorpusInBackground(Set<String> selectedCorpora) {
        this.loadingIndicator.setVisible(true);
        this.table.setVisible(false);
        Background.run(new ExampleFetcher(selectedCorpora, UI.getCurrent()));
    }

    private void setUpTable() {
        this.setSizeFull();
        this.table.setSizeFull();
        this.table.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.table.addStyleName("example-queries-table");
        Grid.Column corpusBrowserColumn = this.table.addComponentColumn((ValueProvider & Serializable)e -> this.getOpenCorpusPanel(e.corpus));
        corpusBrowserColumn.setId("open corpus browser");
        corpusBrowserColumn.setCaption("open corpus browser");
        Grid.Column exampleQueryColumn = this.table.addComponentColumn((ValueProvider & Serializable)e -> {
            Button btn = new Button();
            btn.setDescription("show corpus browser for " + e.corpus);
            btn.addStyleName("link");
            btn.setIcon(SEARCH_ICON);
            btn.setCaption(e.example.getQuery());
            btn.setDescription("show results for \"" + e.example.getQuery() + "\" in " + e.corpus);
            btn.addStyleName("corpus-font-force");
            btn.addClickListener((Button.ClickListener & Serializable)event -> {
                if (this.ui != null) {
                    ControlPanel controlPanel = this.ui.getSearchView().getControlPanel();
                    if (controlPanel == null) {
                        log.error("controlPanel is not initialized");
                        return;
                    }
                    QueryPanel queryPanel = controlPanel.getQueryPanel();
                    if (queryPanel == null) {
                        log.error("queryPanel is not initialized");
                        return;
                    }
                    HashSet<String> corpusNameSet = new HashSet<String>();
                    corpusNameSet.add(e.corpus);
                    if (this.ui.getQueryController() != null) {
                        QueryLanguage ql = QueryLanguage.AQL;
                        if (e.example.getQueryLanguage() == org.corpus_tools.annis.api.model.QueryLanguage.AQLQUIRKSV3) {
                            ql = QueryLanguage.AQL_QUIRKS_V3;
                        }
                        this.ui.getQueryController().setQuery(new Query(e.example.getQuery(), ql, corpusNameSet));
                        this.ui.getSearchView().getControlPanel().getCorpusList().scrollToSelectedCorpus();
                        this.ui.getQueryController().executeSearch(true, true);
                    }
                }
            });
            return btn;
        });
        exampleQueryColumn.setId("exampleQuery");
        exampleQueryColumn.setCaption("Example Query");
        Grid.Column descriptionColumn = this.table.addComponentColumn((ValueProvider & Serializable)e -> {
            Label l = new Label(e.example.getDescription());
            l.setContentMode(ContentMode.TEXT);
            l.addStyleName("corpus-font-force");
            return l;
        });
        descriptionColumn.setCaption("Description");
        descriptionColumn.setId("description");
        this.table.setColumns(new String[]{"exampleQuery", "description", "open corpus browser"});
        exampleQueryColumn.setExpandRatio(1);
        descriptionColumn.setExpandRatio(1);
    }

    private void showTab() {
        if (this.parentTab != null) {
            this.tab = this.parentTab.getTab((Component)this);
            if (this.tab != null) {
                this.tab.setEnabled(true);
                if (!(this.parentTab.getSelectedTab() instanceof ResultViewPanel)) {
                    this.parentTab.setSelectedTab(this.tab);
                }
            }
        }
    }

    public static class Entry {
        String corpus;
        ExampleQuery example;
    }

    private class ExampleFetcher
    implements Runnable {
        private final Set<String> selectedCorpora;
        private UI ui;

        public ExampleFetcher(Set<String> selectedCorpora, UI ui) {
            this.selectedCorpora = selectedCorpora;
            this.ui = ui;
        }

        @Override
        public void run() {
            LinkedList result = new LinkedList();
            try {
                result.addAll(ExampleQueriesPanel.loadExamplesFromRemote(this.selectedCorpora, this.ui));
            }
            finally {
                this.ui.access(() -> {
                    ExampleQueriesPanel.this.loadingIndicator.setVisible(false);
                    ExampleQueriesPanel.this.table.setVisible(true);
                    try {
                        ExampleQueriesPanel.this.table.setItems((Collection)result);
                        if (result.isEmpty()) {
                            ExampleQueriesPanel.this.hideTabSheet();
                        } else {
                            ExampleQueriesPanel.this.showTab();
                        }
                    }
                    catch (Exception ex) {
                        log.error("removing or adding of example queries failed for {}", this.selectedCorpora, (Object)ex);
                    }
                });
            }
        }
    }
}

