/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.google.common.base.Joiner;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.vaadin.server.JsonCodec;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import elemental.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.corpus_tools.annis.ApiClient;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.api.SearchApi;
import org.corpus_tools.annis.api.model.AnnoKey;
import org.corpus_tools.annis.api.model.Annotation;
import org.corpus_tools.annis.api.model.AnnotationComponentType;
import org.corpus_tools.annis.api.model.Component;
import org.corpus_tools.annis.api.model.CorpusConfiguration;
import org.corpus_tools.annis.api.model.CorpusConfigurationContext;
import org.corpus_tools.annis.api.model.CorpusConfigurationView;
import org.corpus_tools.annis.api.model.ExampleQuery;
import org.corpus_tools.annis.api.model.FindQuery;
import org.corpus_tools.annis.api.model.QueryLanguage;
import org.corpus_tools.annis.api.model.VisualizerRule;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.CommonUI;
import org.corpus_tools.annis.gui.UIConfig;
import org.corpus_tools.annis.gui.components.ExceptionDialog;
import org.corpus_tools.annis.gui.graphml.CorpusGraphMapper;
import org.corpus_tools.annis.gui.objects.Match;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SOrderRelation;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Label;
import org.corpus_tools.salt.util.DataSourceSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

public class Helper {
    private static final Pattern validQNamePattern = Pattern.compile("([a-zA-Z_%][a-zA-Z0-9_\\-%]*:)?[a-zA-Z_%][a-zA-Z0-9_\\-%]*");
    public static final String DEFAULT_CONFIG = "default-config";
    public static final String CORPUS_FONT_FORCE = "corpus-font-force";
    public static final String CORPUS_FONT = "corpus-font";
    private static final Logger log = LoggerFactory.getLogger(Helper.class);
    private static final String ERROR_MESSAGE_CORPUS_PROPS_HEADER = "Corpus properties does not exist";
    public static final Escaper AQL_REGEX_VALUE_ESCAPER = Escapers.builder().addEscape('/', "\\x2F").addEscape('\\', "\\\\").addEscape('.', "\\.").addEscape('+', "\\+").addEscape('*', "\\*").addEscape('?', "\\?").addEscape('(', "\\(").addEscape(')', "\\)").addEscape('|', "\\|").addEscape('[', "\\[").addEscape('[', "\\]").addEscape('{', "\\{").addEscape('}', "\\}").addEscape('^', "\\^").addEscape('$', "\\$").addEscape('#', "\\#").addEscape('&', "\\&").addEscape('-', "\\-").addEscape('~', "\\~").build();

    public static List<String> getCorpusPath(SCorpusGraph corpusGraph, SDocument doc) {
        final LinkedList<String> result = new LinkedList<String>();
        result.add(doc.getName());
        SCorpus c = corpusGraph.getCorpus(doc);
        ArrayList<SCorpus> cAsList = new ArrayList<SCorpus>();
        cAsList.add(c);
        corpusGraph.traverse(cAsList, SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_DEPTH_FIRST, "getRootCorpora", new GraphTraverseHandler(){

            public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation edge, SNode currNode, long order) {
                return true;
            }

            public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation edge, SNode fromNode, long order) {
            }

            public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation edge, SNode fromNode, long order) {
                result.add(currNode.getName());
            }
        });
        return result;
    }

    public static List<String> getCorpusPath(String uri) {
        if (uri.startsWith("salt:/")) {
            uri = uri.substring("salt:/".length());
        }
        String rawPath = StringUtils.strip((String)uri, (String)"/ \t");
        String[] path = rawPath.split("/");
        ArrayList<String> result = new ArrayList<String>(path.length);
        for (int i = 0; i < path.length; ++i) {
            try {
                int fragmentStart;
                if (i == path.length - 1 && (fragmentStart = path[i].lastIndexOf(35)) >= 0) {
                    path[i] = path[i].substring(0, fragmentStart);
                }
                result.add(URLDecoder.decode(path[i], "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException ex) {
                log.error(null, (Throwable)ex);
                result.add(path[i]);
            }
        }
        return result;
    }

    public static Map<SNode, Long> calculateMarkedAndCovered(SDocument doc, List<SNode> segNodes, String segmentationName) {
        HashMap<SNode, Long> initialCovered = new HashMap<SNode, Long>();
        for (SNode n : doc.getDocumentGraph().getNodes()) {
            SFeature featMatched = n.getFeature("annis", "matchednode");
            Long match = featMatched == null ? null : featMatched.getValue_SNUMERIC();
            if (match == null) continue;
            initialCovered.put(n, match);
        }
        Map<SToken, Integer> token2index = Helper.createToken2IndexMap(doc.getDocumentGraph(), null);
        CoveredMatchesCalculator cmc = new CoveredMatchesCalculator(doc.getDocumentGraph(), initialCovered, token2index);
        Map<SNode, Long> covered = cmc.getMatchedAndCovered();
        if (segmentationName != null) {
            HashMap<SToken, Long> coveredToken = new HashMap<SToken, Long>();
            for (Map.Entry<SNode, Long> e : covered.entrySet()) {
                SNode n = e.getKey();
                if (!(n instanceof SToken)) continue;
                coveredToken.put((SToken)n, e.getValue());
            }
            block2: for (SNode segNode : segNodes) {
                if (covered.containsKey(segNode)) continue;
                Range<Integer> segRange = Helper.getLeftRightSpan(segNode, doc.getDocumentGraph(), token2index);
                int leftTok = (Integer)segRange.lowerEndpoint();
                int rightTok = (Integer)segRange.upperEndpoint();
                for (Map.Entry e : coveredToken.entrySet()) {
                    Range<Integer> tokRange = Helper.getLeftRightSpan((SNode)e.getKey(), doc.getDocumentGraph(), token2index);
                    long entryTokenIndex = ((Integer)tokRange.lowerEndpoint()).intValue();
                    if (entryTokenIndex > (long)rightTok || entryTokenIndex < (long)leftTok) continue;
                    covered.put(segNode, (Long)e.getValue());
                    continue block2;
                }
            }
        }
        return covered;
    }

    public static String convertExceptionToMessage(Throwable ex) {
        StringBuilder sb = new StringBuilder();
        if (ex != null) {
            sb.append("Exception type: ").append(ex.getClass().getName()).append("\n");
            sb.append("Message: ").append(ex.getLocalizedMessage()).append("\n");
            sb.append("Stacktrace: \n");
            StackTraceElement[] st = ex.getStackTrace();
            for (int i = 0; i < st.length; ++i) {
                sb.append(st[i].toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static ApiClient getClient(UI ui) {
        if (ui instanceof CommonUI) {
            CommonUI annisUI = (CommonUI)ui;
            return annisUI.getClient();
        }
        return null;
    }

    public static Set<AnnoKey> getMetaAnnotationNames(String corpus, UI ui) throws ApiException {
        CorporaApi api = new CorporaApi(Helper.getClient(ui));
        SearchApi search = new SearchApi(Helper.getClient(ui));
        List nodeAnnos = api.nodeAnnotations(corpus, false, true).stream().filter(a -> !Objects.equals(a.getKey().getNs(), "annis") && !Objects.equals(a.getKey().getName(), "tok")).collect(Collectors.toList());
        HashSet<AnnoKey> metaAnnos = new HashSet<AnnoKey>();
        for (Annotation a2 : nodeAnnos) {
            FindQuery q = new FindQuery();
            q.setCorpora(Arrays.asList(corpus));
            q.setQuery("annis:node_type=\"corpus\" _ident_ " + Helper.getQName(a2.getKey()));
            q.setOrder(FindQuery.OrderEnum.NOTSORTED);
            q.setLimit(1);
            q.setOffset(0);
            q.setQueryLanguage(QueryLanguage.AQL);
            File findResult = search.find(q);
            if (findResult == null || !findResult.isFile()) continue;
            try {
                Stream<String> lines = Files.lines(findResult.toPath(), StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    Optional<String> anyLine = lines.findAny();
                    if (!anyLine.isPresent() || anyLine.get().isEmpty()) continue;
                    metaAnnos.add(a2.getKey());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (lines == null) continue;
                    if (throwable != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    lines.close();
                }
            }
            catch (IOException ex) {
                log.error("Error when accessing file with find results", (Throwable)ex);
            }
        }
        return metaAnnos;
    }

    public static String getQName(AnnoKey key) {
        if (key.getNs() == null || key.getNs().isEmpty()) {
            return key.getName();
        }
        return key.getNs() + ":" + key.getName();
    }

    public static String getQName(Component c) {
        if (c.getLayer() == null || c.getLayer().isEmpty()) {
            return c.getName();
        }
        return c.getLayer() + ":" + c.getName();
    }

    public static Map<SToken, Integer> createToken2IndexMap(SDocumentGraph graph, STextualDS textualDS) {
        List sortedTokens;
        LinkedHashMap<SToken, Integer> token2index = new LinkedHashMap<SToken, Integer>();
        if (graph == null) {
            return token2index;
        }
        Multimap orderRootsByType = graph.getRootsByRelationType(SALT_TYPE.SORDER_RELATION);
        HashSet orderRoots = new HashSet(orderRootsByType.get((Object)""));
        if (textualDS == null) {
            sortedTokens = graph.getSortedTokenByText();
        } else {
            DataSourceSequence seq = new DataSourceSequence();
            seq.setDataSource((SSequentialDS)textualDS);
            seq.setStart((Number)0);
            seq.setEnd((Number)(textualDS.getText() != null ? textualDS.getText().length() : 0));
            sortedTokens = graph.getSortedTokenByText(graph.getTokensBySequence(seq));
        }
        if (sortedTokens != null) {
            int i = 0;
            for (SToken t : sortedTokens) {
                if (i <= 0 || orderRoots.contains(t)) {
                    // empty if block
                }
                int n = ++i;
                ++i;
                token2index.put(t, n);
            }
        }
        return token2index;
    }

    public static JsonValue encodeGeneric(Object v) {
        return JsonCodec.encode((Object)v, null, (Type)v.getClass().getGenericSuperclass(), null).getEncodedValue();
    }

    public static String encodeBase64URL(String val) {
        return Base64.encodeBase64URLSafeString((byte[])val.getBytes(StandardCharsets.UTF_8));
    }

    public static String generateCorpusLink(Set<String> corpora) {
        try {
            URI appURI = UI.getCurrent().getPage().getLocation();
            String fragment = "_c=" + Helper.encodeBase64URL(StringUtils.join(corpora, (String)","));
            return new URI(appURI.getScheme(), null, appURI.getHost(), appURI.getPort(), appURI.getPath(), null, fragment).toASCIIString();
        }
        catch (URISyntaxException ex) {
            log.error(null, (Throwable)ex);
            return "ERROR";
        }
    }

    public static CorpusConfiguration getCorpusConfig(String corpus, UI ui) {
        if (corpus == null || corpus.isEmpty()) {
            Notification.show((String)"no corpus is selected", (String)"please select at least one corpus and execute query again", (Notification.Type)Notification.Type.WARNING_MESSAGE);
            return null;
        }
        CorpusConfiguration corpusConfig = new CorpusConfiguration();
        CorporaApi api = new CorporaApi(Helper.getClient(ui));
        try {
            corpusConfig = api.corpusConfiguration(corpus);
        }
        catch (ApiException ex) {
            ui.access(() -> ExceptionDialog.show(ex, ERROR_MESSAGE_CORPUS_PROPS_HEADER, ui));
        }
        return corpusConfig;
    }

    public static CorpusConfiguration getDefaultCorpusConfig() {
        CorpusConfiguration defaultCorpusConfig = new CorpusConfiguration();
        defaultCorpusConfig.setView(new CorpusConfigurationView());
        defaultCorpusConfig.setContext(new CorpusConfigurationContext());
        defaultCorpusConfig.setExampleQueries(new LinkedList<ExampleQuery>());
        defaultCorpusConfig.setVisualizers(new LinkedList<VisualizerRule>());
        defaultCorpusConfig.getView().setPageSize(10);
        defaultCorpusConfig.getContext().setDefault(5);
        defaultCorpusConfig.getContext().setSizes(Arrays.asList(1, 2, 5, 10));
        defaultCorpusConfig.getContext().setMax(Integer.MAX_VALUE);
        return defaultCorpusConfig;
    }

    public static Range<Integer> getLeftRightSpan(SNode node, SDocumentGraph graph, Map<SToken, Integer> token2index) {
        int left = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        if (node instanceof SToken) {
            left = Math.min(left, token2index.get(node));
            right = Math.max(right, token2index.get(node));
        } else {
            List overlappedToken = graph.getOverlappedTokens(node);
            for (SToken t : overlappedToken) {
                left = Math.min(left, token2index.get(t));
                right = Math.max(right, token2index.get(t));
            }
        }
        return Range.closed((Comparable)Integer.valueOf(left), (Comparable)Integer.valueOf(right));
    }

    public static List<SMetaAnnotation> getMetaData(String toplevelCorpusName, Optional<String> documentName, UI ui) {
        ArrayList<SMetaAnnotation> result = new ArrayList<SMetaAnnotation>();
        SearchApi api = new SearchApi(Helper.getClient(ui));
        try {
            String aql = documentName.isPresent() ? "(annis:node_type=\"corpus\" _ident_ annis:doc=/" + AQL_REGEX_VALUE_ESCAPER.escape(documentName.get()) + "/) |(annis:node_type=\"corpus\" _ident_ annis:doc=/" + AQL_REGEX_VALUE_ESCAPER.escape(documentName.get()) + "/ @* annis:node_type=\"corpus\")" : "annis:node_type=\"corpus\" _ident_ annis:node_name=/" + AQL_REGEX_VALUE_ESCAPER.escape(toplevelCorpusName) + "/";
            File graphML = api.subgraphForQuery(toplevelCorpusName, aql, QueryLanguage.AQL, AnnotationComponentType.PARTOF);
            SCorpusGraph cg = CorpusGraphMapper.map(graphML);
            for (SNode n : cg.getNodes()) {
                result.addAll(n.getMetaAnnotations());
            }
        }
        catch (IOException | XMLStreamException | ApiException ex) {
            log.error(null, (Throwable)ex);
            ui.access(() -> ExceptionDialog.show(ex, "Could not retrieve metadata", ui));
        }
        return result;
    }

    public static List<SMetaAnnotation> getMetaDataDoc(String toplevelCorpusName, String documentName, UI ui) {
        ArrayList<SMetaAnnotation> result = new ArrayList<SMetaAnnotation>();
        SearchApi api = new SearchApi(Helper.getClient(ui));
        try {
            File graphML = api.subgraphForQuery(toplevelCorpusName, "annis:node_type=\"corpus\" _ident_ annis:doc=/" + AQL_REGEX_VALUE_ESCAPER.escape(documentName) + "/", QueryLanguage.AQL, AnnotationComponentType.PARTOF);
            SCorpusGraph cg = CorpusGraphMapper.map(graphML);
            for (SNode n : cg.getNodes()) {
                result.addAll(n.getMetaAnnotations());
            }
        }
        catch (IOException | XMLStreamException | ApiException ex) {
            ui.access(() -> ExceptionDialog.show(ex, "Could not retrieve metadata for document", ui));
        }
        return result;
    }

    public static String getQualifiedName(SAnnotation anno) {
        if (anno != null) {
            if (anno.getNamespace() == null || anno.getNamespace().isEmpty()) {
                return anno.getName();
            }
            return anno.getNamespace() + ":" + anno.getName();
        }
        return "";
    }

    public static Optional<OidcUser> getUser(UI ui) {
        if (ui instanceof AnnisUI) {
            return Helper.getUser(((AnnisUI)ui).getSecurityContext());
        }
        return Helper.getUser(SecurityContextHolder.getContext());
    }

    public static Optional<OidcUser> getUser(SecurityContext context) {
        Object principalRaw;
        Authentication auth = context.getAuthentication();
        if (auth != null && !(auth instanceof AnonymousAuthenticationToken) && auth.isAuthenticated() && (principalRaw = auth.getPrincipal()) instanceof OidcUser) {
            return Optional.of((OidcUser)principalRaw);
        }
        return Optional.empty();
    }

    public static String getDisplayName(OidcUser user) {
        if (user.getPreferredUsername() != null) {
            return user.getPreferredUsername();
        }
        if (user.getNickName() != null) {
            return user.getNickName();
        }
        if (user.getEmail() != null) {
            return user.getEmail();
        }
        return user.getSubject();
    }

    public static void addMatchToDocumentGraph(Match match, SDocumentGraph documentGraph) {
        SFeature existingFeatAnnos;
        SFeature existingFeatIDs;
        LinkedList<String> allUrisAsString = new LinkedList<String>();
        long i = 1L;
        for (String u : match.getSaltIDs()) {
            SFeature existing;
            SNode matchedNode;
            allUrisAsString.add(u.replace(",", "%2C"));
            if (!u.startsWith("salt:/")) {
                u = "salt:/" + u;
            }
            if ((matchedNode = (SNode)documentGraph.getNode(u)) != null && (existing = matchedNode.getFeature("annis", "matchednode")) == null) {
                SFeature featMatchedNode = SaltFactory.createSFeature();
                featMatchedNode.setNamespace("annis");
                featMatchedNode.setName("matchednode");
                featMatchedNode.setValue((Object)i);
                matchedNode.addFeature(featMatchedNode);
            }
            ++i;
        }
        SDocumentGraph metaDataContainer = documentGraph;
        if (documentGraph.getDocument() != null) {
            metaDataContainer = documentGraph.getDocument();
        }
        if ((existingFeatIDs = metaDataContainer.getFeature("annis", "matchedids")) == null) {
            SFeature featIDs = SaltFactory.createSFeature();
            featIDs.setNamespace("annis");
            featIDs.setName("matchedids");
            featIDs.setValue((Object)Joiner.on((String)",").join(allUrisAsString));
            metaDataContainer.addFeature(featIDs);
        }
        if ((existingFeatAnnos = metaDataContainer.getFeature("annis", "matchedannos")) == null) {
            SFeature featAnnos = SaltFactory.createSFeature();
            featAnnos.setNamespace("annis");
            featAnnos.setName("matchedannos");
            featAnnos.setValue((Object)Joiner.on((String)",").join(match.getAnnos()));
            metaDataContainer.addFeature(featAnnos);
        }
    }

    public static List<SNode> getSortedSegmentationNodes(String segName, SDocumentGraph graph) {
        ArrayList<SNode> token = new ArrayList<SNode>();
        if (segName == null) {
            List unsortedToken = graph.getSortedTokenByText();
            if (unsortedToken != null) {
                token.addAll(unsortedToken);
            }
        } else {
            List orderRoots;
            LinkedHashSet<SNode> startNodes = new LinkedHashSet<SNode>();
            if (graph != null && (orderRoots = graph.getRootsByRelation(new SALT_TYPE[]{SALT_TYPE.SORDER_RELATION})) != null) {
                block0: for (SNode n : orderRoots) {
                    for (SRelation rel : n.getOutRelations()) {
                        if (!(rel instanceof SOrderRelation) || !segName.equals(rel.getType())) continue;
                        startNodes.add(n);
                        continue block0;
                    }
                }
            }
            HashSet<String> alreadyAdded = new HashSet<String>();
            Iterator iterator = startNodes.iterator();
            while (iterator.hasNext()) {
                SNode s;
                SNode current = s = (SNode)iterator.next();
                block3: while (current != null) {
                    token.add(current);
                    List out = graph.getOutRelations(current.getId());
                    current = null;
                    if (out == null) continue;
                    for (SRelation e : out) {
                        if (!(e instanceof SOrderRelation)) continue;
                        current = (SNode)((SOrderRelation)e).getTarget();
                        if (alreadyAdded.contains(current.getId())) {
                            current = null;
                            continue block3;
                        }
                        alreadyAdded.add(current.getId());
                        continue block3;
                    }
                }
            }
        }
        return token;
    }

    public static boolean containsRTLText(String str) {
        if (str != null) {
            for (int i = 0; i < str.length(); ++i) {
                char cc = str.charAt(i);
                if (!(cc >= '\u0591' && cc <= '\u06f9' || cc >= '\ufb1e' && cc <= '\ufdfb') && (cc < '\ufe70' || cc > '\ufefc')) continue;
                return true;
            }
        }
        return false;
    }

    public static String getSpannedText(SToken tok) {
        SDocumentGraph graph = tok.getGraph();
        List edges = graph.getOutRelations(tok.getId());
        for (SRelation e : edges) {
            if (!(e instanceof STextualRelation)) continue;
            STextualRelation textRel = (STextualRelation)e;
            return ((STextualDS)textRel.getTarget()).getText().substring((Integer)textRel.getStart(), (Integer)textRel.getEnd());
        }
        return "";
    }

    public static STextualDS getTextualDSForNode(SNode node, SDocumentGraph graph) {
        List dataSources;
        if (node != null && (dataSources = graph.getOverlappedDataSourceSequence(node, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION})) != null) {
            for (DataSourceSequence seq : dataSources) {
                if (!(seq.getDataSource() instanceof STextualDS)) continue;
                return (STextualDS)seq.getDataSource();
            }
        }
        return null;
    }

    public static Set<String> getTokenAnnotationLevelSet(SaltProject p) {
        TreeSet<String> result = new TreeSet<String>();
        for (SCorpusGraph corpusGraphs : p.getCorpusGraphs()) {
            for (SDocument doc : corpusGraphs.getDocuments()) {
                SDocumentGraph g = doc.getDocumentGraph();
                result.addAll(Helper.getTokenAnnotationLevelSet(g));
            }
        }
        return result;
    }

    public static Set<String> getTokenAnnotationLevelSet(SDocumentGraph graph) {
        TreeSet<String> result = new TreeSet<String>();
        if (graph != null) {
            for (SToken n : graph.getTokens()) {
                for (SAnnotation anno : n.getAnnotations()) {
                    result.add(anno.getQName());
                }
            }
        }
        return result;
    }

    public static boolean checkSLayer(String layerName, SNode node) {
        if (layerName == null || node == null) {
            return false;
        }
        Set sLayers = node.getLayers();
        if (sLayers != null) {
            for (SLayer l : sLayers) {
                Collection labels = l.getLabels();
                if (labels == null) continue;
                for (Label label : labels) {
                    if (!layerName.equals(label.getValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Set<String> getToplevelCorpusNames(SaltProject p) {
        HashSet<String> names = new HashSet<String>();
        if (p != null && p.getCorpusGraphs() != null) {
            for (SCorpusGraph g : p.getCorpusGraphs()) {
                if (g.getRoots() == null) continue;
                for (SNode c : g.getRoots()) {
                    names.add(c.getName());
                }
            }
        }
        return names;
    }

    public static Map<String, String> parseFragment(String fragment) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String[] split = StringUtils.split((String)(fragment = StringUtils.removeStart((String)fragment, (String)"!")), (String)"&");
        if (split != null) {
            for (String s : split) {
                String[] parts = s.split("=", 2);
                String name = parts[0].trim();
                String value = "";
                if (parts.length == 2) {
                    try {
                        value = name.startsWith("_") ? new String(Base64.decodeBase64((String)parts[1]), "UTF-8") : URLDecoder.decode(parts[1], "UTF-8");
                    }
                    catch (UnsupportedEncodingException ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                }
                name = StringUtils.removeStart((String)name, (String)"_");
                result.put(name, value);
            }
        }
        return result;
    }

    public static String buildDocumentQuery(List<String> docPath, List<String> nodeAnnoFilter, boolean useRawText) {
        boolean fallbackToAll;
        boolean bl = fallbackToAll = !useRawText && nodeAnnoFilter == null;
        if (!fallbackToAll && nodeAnnoFilter != null) {
            fallbackToAll = nodeAnnoFilter.stream().map(annoName -> annoName.replaceFirst("::", ":")).anyMatch(nodeAnno -> !validQNamePattern.matcher((CharSequence)nodeAnno).matches());
        }
        StringBuilder aql = new StringBuilder();
        if (fallbackToAll) {
            aql.append("(n#node");
            aql.append(") & doc#annis:node_name=/");
            aql.append(AQL_REGEX_VALUE_ESCAPER.escape(Joiner.on((char)'/').join(docPath)));
            aql.append("/ & #n @* #doc");
        } else {
            aql.append("(a#tok");
            if (nodeAnnoFilter != null) {
                for (String nodeAnno2 : nodeAnnoFilter) {
                    aql.append(" | a#");
                    aql.append(nodeAnno2);
                }
            }
            aql.append(") & doc#annis:node_name=/");
            aql.append(AQL_REGEX_VALUE_ESCAPER.escape(Joiner.on((char)'/').join(docPath)));
            aql.append("/ & #a @* #doc");
        }
        return aql.toString();
    }

    public static MultiPartEmail createEMailFromConfiguration(UIConfig config) throws EmailException, UnknownHostException {
        MultiPartEmail result = new MultiPartEmail();
        if (config.getMailHost() == null) {
            result.setHostName("localhost");
        } else {
            result.setHostName(config.getMailHost());
        }
        if (config.getMailUser() != null && config.getMailPassword() != null) {
            result.setAuthentication(config.getMailUser(), config.getMailPassword());
        }
        result.setStartTLSRequired(config.isMailTLS());
        if (config.getMailFrom() == null) {
            result.setFrom("annis@" + InetAddress.getLocalHost().getHostName(), "ANNIS");
        } else {
            result.setFrom(config.getMailFrom());
        }
        return result;
    }

    public static class CoveredMatchesCalculator
    implements GraphTraverseHandler {
        private final Map<SNode, Long> matchedAndCovered;
        private final Map<SToken, Integer> token2index;
        private final SDocumentGraph graph;
        private final Comparator<SNode> comp = new Comparator<SNode>(){

            @Override
            public int compare(SNode o1, SNode o2) {
                Range<Integer> range1 = Helper.getLeftRightSpan(o1, graph, token2index);
                Range<Integer> range2 = Helper.getLeftRightSpan(o2, graph, token2index);
                int leftTokIdxO1 = (Integer)range1.lowerEndpoint();
                int rightTokIdxO1 = (Integer)range1.upperEndpoint();
                int leftTokIdxO2 = (Integer)range2.lowerEndpoint();
                int rightTokIdxO2 = (Integer)range2.upperEndpoint();
                int intervallO1 = Math.abs(leftTokIdxO1 - rightTokIdxO1);
                int intervallO2 = Math.abs(leftTokIdxO2 - rightTokIdxO2);
                SFeature featMatch1 = o1.getFeature("annis", "matchednode");
                SFeature featMatch2 = o2.getFeature("annis", "matchednode");
                long matchNode1 = featMatch1 == null ? Long.MAX_VALUE : featMatch1.getValue_SNUMERIC();
                long matchNode2 = featMatch2 == null ? Long.MAX_VALUE : featMatch2.getValue_SNUMERIC();
                SFeature o1_feat_id = o1.getFeature("annis", "node_id");
                SFeature o2_feat_id = o2.getFeature("annis", "node_id");
                long o1_internal_id = o1_feat_id == null ? 0L : o1_feat_id.getValue_SNUMERIC();
                long o2_internal_id = o2_feat_id == null ? 0L : o2_feat_id.getValue_SNUMERIC();
                return ComparisonChain.start().compare(intervallO1, intervallO2).compare(range1.lowerEndpoint(), range2.lowerEndpoint()).compare(range1.upperEndpoint(), range2.upperEndpoint()).compare(matchNode1, matchNode2).compare(o1_internal_id, o2_internal_id).result();
            }
        };

        public CoveredMatchesCalculator(SDocumentGraph graph, Map<SNode, Long> initialMatches, Map<SToken, Integer> token2index) {
            this.graph = graph;
            this.matchedAndCovered = initialMatches;
            this.token2index = token2index;
            TreeMap<SNode, Long> sortedMatchedNodes = new TreeMap<SNode, Long>(this.comp);
            for (Map.Entry<SNode, Long> entry : initialMatches.entrySet()) {
                SNode n = entry.getKey();
                sortedMatchedNodes.put(n, entry.getValue());
            }
            if (initialMatches.size() > 0) {
                graph.traverse(new ArrayList(sortedMatchedNodes.keySet()), SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "CoveredMatchesCalculator", (GraphTraverseHandler)this, true);
            }
        }

        public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation edge, SNode currNode, long order) {
            return edge == null || edge instanceof SDominanceRelation || edge instanceof SSpanningRelation;
        }

        public Map<SNode, Long> getMatchedAndCovered() {
            return this.matchedAndCovered;
        }

        public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation edge, SNode fromNode, long order) {
        }

        public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation edge, SNode fromNode, long order) {
            if (fromNode != null && this.matchedAndCovered.containsKey(fromNode) && currNode != null) {
                long currentMatchPos = this.matchedAndCovered.get(fromNode);
                Long oldMatchPos = this.matchedAndCovered.get(currNode);
                if (oldMatchPos == null) {
                    this.matchedAndCovered.put(currNode, currentMatchPos);
                }
            }
        }
    }
}

