/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.BeanItemContainer;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Table;
import java.io.Serializable;
import org.corpus_tools.annis.gui.CitationLinkGenerator;
import org.corpus_tools.annis.gui.QueryController;
import org.corpus_tools.annis.gui.objects.Query;

public class HistoryPanel
extends Panel
implements Property.ValueChangeListener,
ItemClickEvent.ItemClickListener {
    private static final long serialVersionUID = 3747177440870920327L;
    private Table tblHistory;
    private QueryController controller;
    private final CitationLinkGenerator citationGenerator;

    public HistoryPanel(BeanItemContainer<Query> containerHistory, QueryController controller) {
        this.controller = controller;
        this.setSizeFull();
        this.tblHistory = new Table();
        this.tblHistory.setSelectable(true);
        this.tblHistory.setPageLength(8);
        this.tblHistory.setImmediate(true);
        this.tblHistory.setSizeFull();
        this.tblHistory.setContainerDataSource(containerHistory);
        this.tblHistory.addGeneratedColumn((Object)"gennumber", (Table.ColumnGenerator & Serializable)(source, itemId, columnId) -> {
            int idx = containerHistory.indexOfId(itemId);
            return new Label("" + (idx + 1));
        });
        this.tblHistory.setColumnExpandRatio((Object)"query", 1.0f);
        this.citationGenerator = new CitationLinkGenerator();
        this.tblHistory.addGeneratedColumn((Object)"genlink", (Table.ColumnGenerator)this.citationGenerator);
        this.tblHistory.setVisibleColumns(new Object[]{"gennumber", "query", "genlink"});
        this.tblHistory.setColumnHeaders(new String[]{"#", "Query", "URL"});
        this.tblHistory.addStyleName("corpus-font");
        this.tblHistory.addValueChangeListener((Property.ValueChangeListener)this);
        this.tblHistory.addItemClickListener((ItemClickEvent.ItemClickListener)this);
        VerticalLayout layout = new VerticalLayout(new Component[]{this.tblHistory});
        layout.setSizeFull();
        this.setContent((Component)layout);
    }

    public void itemClick(ItemClickEvent event) {
        if (this.controller != null && event.isDoubleClick()) {
            this.controller.executeSearch(true, true);
            if (this.getParent() instanceof Window) {
                UI.getCurrent().removeWindow((Window)this.getParent());
            }
        }
    }

    public void valueChange(Property.ValueChangeEvent event) {
        Query q = (Query)event.getProperty().getValue();
        if (q != null && this.controller != null) {
            this.controller.setQuery(q);
        }
    }
}

