/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.google.common.base.Preconditions;
import com.vaadin.ui.Component;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.UI;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDGenerator {
    private static Logger log = LoggerFactory.getLogger(IDGenerator.class);

    public static String assignID(Component c) {
        String fieldName = "c";
        if (c != null) {
            fieldName = c.getClass().getSimpleName();
        }
        return IDGenerator.assignID(c, fieldName);
    }

    public static String assignID(Component c, String fieldName) {
        String id = null;
        if (c != null && fieldName != null && !fieldName.isEmpty()) {
            Preconditions.checkArgument((boolean)c.isAttached(), (Object)("Component " + c.getConnectorId() + " must be attached before it can get an automatic ID."));
            id = c.getId();
            if (id == null) {
                HasComponents parent = c.getParent();
                if (parent == null || parent instanceof UI) {
                    id = fieldName;
                } else {
                    String parentID = parent.getId();
                    if (parentID == null) {
                        parentID = IDGenerator.assignID((Component)parent);
                    }
                    String idBase = parentID + "-" + fieldName;
                    int counter = 1;
                    id = idBase;
                    while (IDGenerator.childHasID(parent, id)) {
                        id = idBase + "." + counter++;
                    }
                }
                c.setId(id);
            }
        }
        return id;
    }

    public static void assignIDForEachField(HasComponents parent) {
        if (parent != null) {
            for (Component c : parent) {
                IDGenerator.assignIDForField(parent, c);
            }
        }
    }

    protected static String assignIDForField(HasComponents parent, Component c) {
        String fieldName = "c";
        if (parent != null && c != null) {
            for (Field f : parent.getClass().getDeclaredFields()) {
                if (!Component.class.isAssignableFrom(f.getType())) continue;
                try {
                    f.setAccessible(true);
                    Component fieldComponent = (Component)f.get(parent);
                    if (fieldComponent != c) continue;
                    fieldName = f.getName();
                }
                catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
                    log.warn("Could not automatically get field name for assigning ID", (Throwable)ex);
                }
            }
        }
        return IDGenerator.assignID(c, fieldName);
    }

    public static void assignIDForFields(HasComponents parent, Component ... components) {
        for (Component c : components) {
            IDGenerator.assignIDForField(parent, c);
        }
    }

    private static boolean childHasID(HasComponents parent, String id) {
        if (parent != null && id != null) {
            for (Component child : parent) {
                if (!id.equals(child.getId())) continue;
                return true;
            }
        }
        return false;
    }
}

