/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.validator.EmailValidator;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.corpus_tools.annis.gui.AboutWindow;
import org.corpus_tools.annis.gui.AnnisBaseUI;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.CommonUI;
import org.corpus_tools.annis.gui.HelpUsWindow;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.IDGenerator;
import org.corpus_tools.annis.gui.LoginListener;
import org.corpus_tools.annis.gui.QueryController;
import org.corpus_tools.annis.gui.ReportBugWindow;
import org.corpus_tools.annis.gui.Sidebar;
import org.corpus_tools.annis.gui.SidebarState;
import org.corpus_tools.annis.gui.UIConfig;
import org.corpus_tools.annis.gui.components.ScreenshotMaker;
import org.corpus_tools.annis.gui.components.SettingsStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

public class MainToolbar
extends HorizontalLayout
implements ScreenshotMaker.ScreenshotCallback,
SettingsStorage.LoadedListener {
    private static final long serialVersionUID = -6033428470667608345L;
    private static final Logger log = LoggerFactory.getLogger(MainToolbar.class);
    private Button btSidebar;
    private final Button btNavigate;
    private NavigationTarget navigationTarget;
    private final Button btLogin;
    private final Button btLogout;
    private final Button btBugReport;
    private final Button btAboutAnnis;
    private final Button btOpenSource;
    private final Label lblUserName;
    private final String bugEMailAddress;
    private SidebarState sidebarState = SidebarState.VISIBLE;
    private final LinkedHashSet<LoginListener> loginListeners = new LinkedHashSet();
    private Throwable lastBugReportCause;
    private Sidebar sidebar;
    private ScreenshotMaker screenshotExtension;
    private QueryController queryController;
    private final OAuth2ClientProperties oauth2Clients;

    public MainToolbar(UIConfig config, OAuth2ClientProperties oauth2Clients) {
        this.oauth2Clients = oauth2Clients;
        String bugmail = config.getBugEmail();
        this.bugEMailAddress = bugmail != null && !bugmail.isEmpty() && !bugmail.startsWith("${") && new EmailValidator("").isValid((Object)bugmail) ? bugmail : null;
        UI ui = UI.getCurrent();
        if (ui instanceof CommonUI) {
            ((CommonUI)ui).getSettings().addedLoadedListener(this);
        }
        this.setWidth("100%");
        this.setHeight("-1px");
        this.addStyleName("toolbar");
        this.addStyleName("border-layout");
        this.btAboutAnnis = new Button("About ANNIS");
        this.btAboutAnnis.addStyleName("small");
        this.btAboutAnnis.setIcon((Resource)new ThemeResource("images/annis_16.png"));
        this.btAboutAnnis.addClickListener((Button.ClickListener)new AboutClickListener());
        this.btSidebar = new Button();
        this.btSidebar.setDisableOnClick(true);
        this.btSidebar.addStyleName("small");
        this.btSidebar.setDescription("Show and hide search sidebar");
        this.btSidebar.setIconAlternateText(this.btSidebar.getDescription());
        this.btBugReport = new Button("Report Problem");
        this.btBugReport.addStyleName("small");
        this.btBugReport.setDisableOnClick(true);
        this.btBugReport.setIcon((Resource)FontAwesome.ENVELOPE_O);
        this.btBugReport.addClickListener((Button.ClickListener & Serializable)event -> this.reportBug());
        this.btBugReport.setVisible(this.bugEMailAddress != null);
        this.btNavigate = new Button();
        this.btNavigate.setVisible(false);
        this.btNavigate.setDisableOnClick(true);
        this.btNavigate.addClickListener((Button.ClickListener & Serializable)event -> {
            this.btNavigate.setEnabled(true);
            if (this.navigationTarget != null) {
                UI.getCurrent().getNavigator().navigateTo(this.navigationTarget.state);
            }
        });
        this.lblUserName = new Label("not logged in");
        this.lblUserName.setWidth("-1px");
        this.lblUserName.setHeight("-1px");
        this.lblUserName.addStyleName("right-aligned-text");
        this.btLogin = new Button("Login", (Button.ClickListener & Serializable)event -> this.showLoginWindow());
        this.btLogout = new Button("Logout", (Button.ClickListener & Serializable)event -> {
            Page.getCurrent().setLocation("logout");
            UI.getCurrent().getSession().close();
            for (LoginListener l : this.loginListeners) {
                l.onLogout();
            }
            Notification.show((String)"Logged out", (Notification.Type)Notification.Type.TRAY_NOTIFICATION);
            this.updateUserInformation();
        });
        this.btLogin.setSizeUndefined();
        this.btLogin.setStyleName("small");
        this.btLogin.setIcon((Resource)FontAwesome.USER);
        this.btLogout.setSizeUndefined();
        this.btLogout.setStyleName("small");
        this.btLogout.setIcon((Resource)FontAwesome.USER);
        this.btOpenSource = new Button("Help us make ANNIS better!");
        this.btOpenSource.setStyleName("link");
        this.btOpenSource.addClickListener((Button.ClickListener & Serializable)event -> {
            HelpUsWindow w = new HelpUsWindow();
            w.setCaption("Help us make ANNIS better!");
            w.setModal(true);
            w.setResizable(true);
            w.setWidth("600px");
            w.setHeight("500px");
            UI.getCurrent().addWindow((Window)w);
            w.center();
        });
        this.addComponent((Component)this.btSidebar);
        this.setComponentAlignment((Component)this.btSidebar, Alignment.MIDDLE_LEFT);
        this.addComponent((Component)this.btAboutAnnis);
        this.addComponent((Component)this.btBugReport);
        this.addComponent((Component)this.btNavigate);
        this.addComponent((Component)this.btOpenSource);
        this.setSpacing(true);
        this.setComponentAlignment((Component)this.btAboutAnnis, Alignment.MIDDLE_LEFT);
        this.setComponentAlignment((Component)this.btBugReport, Alignment.MIDDLE_LEFT);
        this.setComponentAlignment((Component)this.btNavigate, Alignment.MIDDLE_LEFT);
        this.setComponentAlignment((Component)this.btOpenSource, Alignment.MIDDLE_CENTER);
        this.setExpandRatio((Component)this.btOpenSource, 1.0f);
        this.addLoginButton();
        this.btSidebar.addClickListener((Button.ClickListener & Serializable)event -> {
            this.btSidebar.setEnabled(true);
            switch (this.sidebarState) {
                case VISIBLE: {
                    if (event.isCtrlKey()) {
                        this.sidebarState = SidebarState.AUTO_VISIBLE;
                        break;
                    }
                    this.sidebarState = SidebarState.HIDDEN;
                    break;
                }
                case HIDDEN: {
                    if (event.isCtrlKey()) {
                        this.sidebarState = SidebarState.AUTO_HIDDEN;
                        break;
                    }
                    this.sidebarState = SidebarState.VISIBLE;
                    break;
                }
                case AUTO_VISIBLE: {
                    if (event.isCtrlKey()) {
                        this.sidebarState = SidebarState.VISIBLE;
                        break;
                    }
                    this.sidebarState = SidebarState.AUTO_HIDDEN;
                    break;
                }
                case AUTO_HIDDEN: {
                    this.sidebarState = event.isCtrlKey() ? SidebarState.HIDDEN : SidebarState.AUTO_VISIBLE;
                }
            }
            this.updateSidebarState();
            this.updateUserInformation();
        });
        this.screenshotExtension = new ScreenshotMaker(this);
        this.updateSidebarState();
    }

    private void addLoginButton() {
        boolean desktopMode = false;
        UI ui = UI.getCurrent();
        if (ui instanceof AnnisUI) {
            desktopMode = ((AnnisUI)ui).isDesktopMode();
        }
        if (!desktopMode && this.oauth2Clients != null) {
            this.addComponent((Component)this.lblUserName);
            this.setComponentAlignment((Component)this.lblUserName, Alignment.MIDDLE_RIGHT);
            this.addComponent((Component)this.btLogin);
            this.setComponentAlignment((Component)this.btLogin, Alignment.MIDDLE_RIGHT);
        }
    }

    public void addLoginListener(LoginListener listener) {
        this.loginListeners.add(listener);
    }

    public void attach() {
        super.attach();
        UI ui = UI.getCurrent();
        this.updateUserInformation();
        if (ui instanceof AnnisBaseUI) {
            ((AnnisBaseUI)ui).getLoginDataLostBus().register((Object)this);
        }
        IDGenerator.assignIDForFields((HasComponents)this, new Component[]{this.btAboutAnnis, this.btOpenSource});
    }

    public boolean canReportBugs() {
        return this.bugEMailAddress != null;
    }

    public void detach() {
        UI ui = UI.getCurrent();
        if (ui instanceof AnnisBaseUI) {
            ((AnnisBaseUI)ui).getLoginDataLostBus().unregister((Object)this);
        }
        super.detach();
    }

    public QueryController getQueryController() {
        return this.queryController;
    }

    public ScreenshotMaker getScreenshotExtension() {
        return this.screenshotExtension;
    }

    public Sidebar getSidebar() {
        return this.sidebar;
    }

    public boolean isLoggedIn() {
        return Helper.getUser(UI.getCurrent()).isPresent();
    }

    void notifiyQueryStarted() {
        if (this.sidebarState == SidebarState.AUTO_VISIBLE) {
            this.sidebarState = SidebarState.AUTO_HIDDEN;
        }
        this.updateSidebarState();
    }

    void onLogin() {
        for (LoginListener l : this.loginListeners) {
            try {
                l.onLogin();
            }
            catch (Exception ex) {
                log.error("exception thrown while notifying login listeners", (Throwable)ex);
            }
        }
        this.updateUserInformation();
    }

    @Override
    public void onSettingsLoaded(SettingsStorage settings) {
        String sidebarStateSetting = settings.get("annis-sidebar-state");
        if (sidebarStateSetting != null) {
            try {
                this.sidebarState = SidebarState.valueOf(sidebarStateSetting);
                if (this.sidebarState == SidebarState.AUTO_HIDDEN) {
                    this.sidebarState = SidebarState.AUTO_VISIBLE;
                } else if (this.sidebarState == SidebarState.HIDDEN) {
                    this.sidebarState = SidebarState.VISIBLE;
                }
            }
            catch (IllegalArgumentException ex) {
                log.debug("Invalid cookie for sidebar state", (Throwable)ex);
            }
        }
        this.updateSidebarState();
    }

    private void reportBug() {
        this.reportBug(null);
    }

    void reportBug(Throwable cause) {
        this.lastBugReportCause = cause;
        if (this.screenshotExtension.isAttached()) {
            this.screenshotExtension.makeScreenshot();
            this.btBugReport.setCaption("problem report is initialized...");
        } else {
            Notification.show((String)"This user interface does not allow screenshots. Can't report bug.", (Notification.Type)Notification.Type.ERROR_MESSAGE);
        }
    }

    @Override
    public void screenshotReceived(byte[] imageData, String mimeType) {
        this.btBugReport.setEnabled(true);
        this.btBugReport.setCaption("Report Problem");
        if (this.bugEMailAddress != null) {
            ReportBugWindow reportBugWindow = new ReportBugWindow(this.bugEMailAddress, imageData, mimeType, this.lastBugReportCause);
            reportBugWindow.setModal(true);
            reportBugWindow.setResizable(true);
            UI.getCurrent().addWindow((Window)reportBugWindow);
            reportBugWindow.center();
            this.lastBugReportCause = null;
        }
    }

    public void setNavigationTarget(NavigationTarget target, UI ui) {
        if (target == this.navigationTarget) {
            // empty if block
        }
        this.navigationTarget = target;
        this.btNavigate.setVisible(false);
        if (target == NavigationTarget.ADMIN) {
            this.updateAdministratorButtonVisibility(Helper.getUser(ui));
        } else if (target != null) {
            this.btNavigate.setVisible(true);
            this.btNavigate.setCaption(target.caption);
            this.btNavigate.setIcon(target.icon);
        }
    }

    public void setQueryController(QueryController queryController) {
        this.queryController = queryController;
    }

    public void setSidebar(Sidebar sidebar) {
        this.sidebar = sidebar;
        this.btSidebar.setVisible(sidebar != null);
        this.updateSidebarState();
    }

    public void showLoginWindow() {
        UI ui = UI.getCurrent();
        if (ui instanceof CommonUI) {
            ((CommonUI)ui).redirectToLogin();
        }
    }

    private void updateSidebarState() {
        if (this.sidebar != null && this.btSidebar != null) {
            this.btSidebar.setIcon(this.sidebarState.getIcon());
            this.sidebar.updateSidebarState(this.sidebarState);
        }
    }

    private void updateAdministratorButtonVisibility(Optional<OidcUser> user) {
        if (user.isPresent() && user.get().containsClaim("https://corpus-tools.org/annis/roles").booleanValue() && user.get().getClaimAsStringList("https://corpus-tools.org/annis/roles").contains("admin")) {
            this.btNavigate.setCaption(NavigationTarget.ADMIN.caption);
            this.btNavigate.setIcon(NavigationTarget.ADMIN.icon);
            this.btNavigate.setVisible(true);
        }
    }

    private void updateUserInformation() {
        Optional<OidcUser> user;
        if (this.lblUserName == null) {
            return;
        }
        if (this.navigationTarget == NavigationTarget.ADMIN) {
            this.btNavigate.setVisible(false);
        }
        if ((user = Helper.getUser(UI.getCurrent())).isPresent()) {
            String displayName = Helper.getDisplayName(user.get());
            Notification.show((String)("Logged in as \"" + displayName + "\""), (Notification.Type)Notification.Type.TRAY_NOTIFICATION);
            this.lblUserName.setValue("logged in as \"" + displayName + "\"");
            if (this.getComponentIndex((Component)this.btLogin) > -1) {
                this.replaceComponent((Component)this.btLogin, (Component)this.btLogout);
                this.setComponentAlignment((Component)this.btLogout, Alignment.MIDDLE_RIGHT);
            }
            if (this.navigationTarget == NavigationTarget.ADMIN) {
                this.updateAdministratorButtonVisibility(user);
            }
        } else {
            this.lblUserName.setValue("not logged in");
            if (this.getComponentIndex((Component)this.btLogout) > -1) {
                this.replaceComponent((Component)this.btLogout, (Component)this.btLogin);
                this.setComponentAlignment((Component)this.btLogin, Alignment.MIDDLE_RIGHT);
            }
        }
    }

    public static enum NavigationTarget {
        SEARCH("", "Search interface", (Resource)FontAwesome.SEARCH),
        ADMIN("admin", "Administration", (Resource)FontAwesome.WRENCH);

        private final String caption;
        private final String state;
        private final Resource icon;

        private NavigationTarget(String state, String caption, Resource icon) {
            this.caption = caption;
            this.state = state;
            this.icon = icon;
        }
    }

    private static class AboutClickListener
    implements Button.ClickListener {
        private static final long serialVersionUID = 7147113799757433869L;

        public void buttonClick(Button.ClickEvent event) {
            AboutWindow w = new AboutWindow();
            w.setCaption("About ANNIS");
            w.setModal(true);
            w.setResizable(true);
            w.setWidth("500px");
            w.setHeight("500px");
            UI.getCurrent().addWindow((Window)w);
        }
    }
}

