/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.corpus_tools.annis.api.model.FindQuery;
import org.corpus_tools.annis.gui.objects.ContextualizedQuery;
import org.corpus_tools.annis.gui.objects.DisplayedResultQuery;
import org.corpus_tools.annis.gui.objects.FrequencyQuery;
import org.corpus_tools.annis.gui.objects.FrequencyTableQuery;
import org.corpus_tools.annis.gui.objects.PagedResultQuery;
import org.corpus_tools.annis.gui.objects.Query;
import org.corpus_tools.annis.gui.objects.QueryLanguage;

public class QueryGenerator<T extends Query, QG extends QueryGenerator<T, QG>> {
    private final T current;

    public static DisplayedResultQueryGenerator displayed() {
        return new DisplayedResultQueryGenerator();
    }

    public static FrequencyQueryGenerator frequency() {
        return new FrequencyQueryGenerator();
    }

    private QueryGenerator(T current) {
        this.current = current;
    }

    public T build() {
        return this.current;
    }

    public QG corpora(Set<String> corpora) {
        ((Query)this.current).setCorpora(new LinkedHashSet<String>(corpora));
        return (QG)this;
    }

    protected T getCurrent() {
        return this.current;
    }

    public QG query(String aql) {
        ((Query)this.current).setQuery(aql);
        return (QG)this;
    }

    public QG queryLanguage(QueryLanguage queryLanguage) {
        ((Query)this.current).setQueryLanguage(queryLanguage);
        return (QG)this;
    }

    /* synthetic */ QueryGenerator(Query x0, 1 x1) {
        this(x0);
    }

    public static class PagedQueryGenerator<T extends PagedResultQuery, QG extends PagedQueryGenerator<T, QG>>
    extends ContextQueryGenerator<T, QG> {
        private PagedQueryGenerator(T query) {
            super(query);
        }

        public QG limit(int limit) {
            ((PagedResultQuery)this.getCurrent()).setLimit(limit);
            return (QG)this;
        }

        public QG offset(long offset) {
            ((PagedResultQuery)this.getCurrent()).setOffset(offset);
            return (QG)this;
        }

        public QG order(FindQuery.OrderEnum order) {
            ((PagedResultQuery)this.getCurrent()).setOrder(order);
            return (QG)this;
        }

        /* synthetic */ PagedQueryGenerator(PagedResultQuery x0, 1 x1) {
            this(x0);
        }
    }

    public static class FrequencyQueryGenerator
    extends QueryGenerator<FrequencyQuery, FrequencyQueryGenerator> {
        FrequencyQueryGenerator() {
            super(new FrequencyQuery(), null);
        }

        public FrequencyQueryGenerator def(FrequencyTableQuery def) {
            ((FrequencyQuery)this.getCurrent()).setFrequencyDefinition(def);
            return this;
        }
    }

    public static class DisplayedResultQueryGenerator
    extends PagedQueryGenerator<DisplayedResultQuery, DisplayedResultQueryGenerator> {
        private DisplayedResultQueryGenerator() {
            super(new DisplayedResultQuery(), null);
        }

        public DisplayedResultQueryGenerator baseText(String val) {
            ((DisplayedResultQuery)this.getCurrent()).setBaseText(val);
            return this;
        }

        public DisplayedResultQueryGenerator selectedMatches(Set<Long> selected) {
            ((DisplayedResultQuery)this.getCurrent()).setSelectedMatches(selected == null ? new TreeSet() : selected);
            return this;
        }
    }

    public static class ContextQueryGenerator<T extends ContextualizedQuery, QG extends ContextQueryGenerator<T, QG>>
    extends QueryGenerator<T, QG> {
        protected ContextQueryGenerator(T query) {
            super((Query)query, null);
        }

        public QG left(int left) {
            ((ContextualizedQuery)this.getCurrent()).setLeftContext(left);
            return (QG)this;
        }

        public QG right(int right) {
            ((ContextualizedQuery)this.getCurrent()).setRightContext(right);
            return (QG)this;
        }

        public QG segmentation(String segmentation) {
            ((ContextualizedQuery)this.getCurrent()).setSegmentation(segmentation);
            return (QG)this;
        }
    }
}

