/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.google.common.base.Splitter;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.vaadin.event.Action;
import com.vaadin.event.ShortcutListener;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Page;
import com.vaadin.server.RequestHandler;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.WebBrowser;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.HelpPanel;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.InstanceConfig;
import org.corpus_tools.annis.gui.LoginListener;
import org.corpus_tools.annis.gui.MainToolbar;
import org.corpus_tools.annis.gui.QueryGenerator;
import org.corpus_tools.annis.gui.Sidebar;
import org.corpus_tools.annis.gui.SidebarState;
import org.corpus_tools.annis.gui.components.ExceptionDialog;
import org.corpus_tools.annis.gui.controlpanel.ControlPanel;
import org.corpus_tools.annis.gui.docbrowser.DocBrowserController;
import org.corpus_tools.annis.gui.frequency.FrequencyQueryPanel;
import org.corpus_tools.annis.gui.media.MediaController;
import org.corpus_tools.annis.gui.media.MediaControllerImpl;
import org.corpus_tools.annis.gui.media.MimeTypeErrorListener;
import org.corpus_tools.annis.gui.media.PDFController;
import org.corpus_tools.annis.gui.media.PDFControllerImpl;
import org.corpus_tools.annis.gui.objects.DisplayedResultQuery;
import org.corpus_tools.annis.gui.objects.PagedResultQuery;
import org.corpus_tools.annis.gui.objects.Query;
import org.corpus_tools.annis.gui.objects.QueryLanguage;
import org.corpus_tools.annis.gui.resultview.ResultViewPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchView
extends GridLayout
implements View,
MimeTypeErrorListener,
Page.UriFragmentChangedListener,
TabSheet.CloseHandler,
LoginListener,
Sidebar,
TabSheet.SelectedTabChangeListener {
    private static final long serialVersionUID = 4726183716126582129L;
    private static final Logger log = LoggerFactory.getLogger(SearchView.class);
    public static final String NAME = "";
    private static final Escaper urlPathEscape = UrlEscapers.urlPathSegmentEscaper();
    public static final int CONTROL_PANEL_WIDTH = 400;
    private final Pattern citationPattern = Pattern.compile("AQL\\((.*)\\),CIDS\\(([^)]*)\\)(,CLEFT\\(([^)]*)\\),)?(CRIGHT\\(([^)]*)\\))?", 40);
    private ControlPanel controlPanel;
    private TabSheet mainTab;
    private String lastEvaluatedFragment;
    private DocBrowserController docBrowserController;
    private Set<Component> selectedTabHistory;
    private final AnnisUI ui;
    private MainToolbar toolbar;
    private HelpPanel helpPanel;

    public SearchView(AnnisUI ui) {
        super(2, 2);
        this.ui = ui;
        this.selectedTabHistory = new LinkedHashSet<Component>();
        this.docBrowserController = new DocBrowserController(ui);
        this.setSizeFull();
        this.setMargin(false);
        this.setRowExpandRatio(1, 1.0f);
        this.setColumnExpandRatio(1, 1.0f);
        this.helpPanel = new HelpPanel(ui);
        this.mainTab = new TabSheet();
        this.mainTab.setSizeFull();
        this.mainTab.setCloseHandler((TabSheet.CloseHandler)this);
        this.mainTab.addStyleName("framed");
        this.mainTab.addSelectedTabChangeListener((TabSheet.SelectedTabChangeListener)this);
        TabSheet.Tab helpTab = this.mainTab.addTab((Component)this.helpPanel, "Help/Examples");
        helpTab.setIcon((Resource)FontAwesome.QUESTION_CIRCLE);
        helpTab.setClosable(false);
        this.controlPanel = new ControlPanel(ui, this.helpPanel);
        this.controlPanel.setWidth(400.0f, Sizeable.Unit.PIXELS);
        this.controlPanel.setHeight(100.0f, Sizeable.Unit.PERCENTAGE);
        ui.addAction((Action)new ShortcutListener("Tutor^eial"){
            private static final long serialVersionUID = 4230090114473234656L;

            public void handleAction(Object sender, Object target) {
                SearchView.this.mainTab.setSelectedTab((Component)SearchView.this.helpPanel);
            }
        });
        this.addComponent((Component)this.controlPanel, 0, 1);
        this.addComponent((Component)this.mainTab, 1, 1);
    }

    public void checkCitation() {
        if (VaadinSession.getCurrent() == null || VaadinSession.getCurrent().getSession() == null) {
            return;
        }
        Object origURLRaw = VaadinSession.getCurrent().getSession().getAttribute("citation");
        if (origURLRaw == null || !(origURLRaw instanceof String)) {
            return;
        }
        String origURL = (String)origURLRaw;
        String parameters = origURL.replaceAll(".*?/Cite(/)?", NAME);
        if (!NAME.equals(parameters) && !origURL.equals(parameters)) {
            try {
                String decoded = URLDecoder.decode(parameters, "UTF-8");
                this.evaluateCitation(decoded);
            }
            catch (UnsupportedEncodingException ex) {
                log.error(null, (Throwable)ex);
            }
        }
    }

    public void closeTab(Component c) {
        this.selectedTabHistory.remove(c);
        this.mainTab.removeComponent(c);
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        if (event.getOldView() == event.getNewView()) {
            return;
        }
        InstanceConfig config = this.ui.getInstanceConfig();
        Page.getCurrent().setTitle(config.getInstanceDisplayName() + " (ANNIS Corpus Search)");
        Page.getCurrent().addUriFragmentChangedListener((Page.UriFragmentChangedListener)this);
        this.getSession().addRequestHandler((RequestHandler)new CitationRequestHandler());
        this.getSession().setAttribute(MediaController.class, (Object)new MediaControllerImpl());
        this.getSession().setAttribute(PDFController.class, (Object)new PDFControllerImpl());
        this.checkCitation();
        this.lastEvaluatedFragment = NAME;
        this.evaluateFragment(Page.getCurrent().getUriFragment());
        if (config.isLoginOnStart() && this.toolbar != null && !Helper.getUser(this.ui.getSecurityContext()).isPresent()) {
            this.toolbar.showLoginWindow();
        }
    }

    public void evaluateCitation(String relativeUri) {
        Matcher m = this.citationPattern.matcher(relativeUri);
        if (m.matches()) {
            String aql = NAME;
            if (m.group(1) != null) {
                aql = m.group(1);
            }
            HashSet<String> selectedCorpora = new HashSet<String>();
            if (m.group(2) != null) {
                String[] cids = m.group(2).split(",");
                selectedCorpora.addAll(Arrays.asList(cids));
            }
            CorporaApi api = new CorporaApi(Helper.getClient(this.ui));
            try {
                List<String> userCorpora = api.listCorpora();
                selectedCorpora.retainAll(userCorpora);
            }
            catch (ApiException ex) {
                log.error("Could not get list of corpora", (Throwable)ex);
            }
            if (m.group(4) != null && m.group(6) != null) {
                int cleft = 0;
                int cright = 0;
                try {
                    cleft = Integer.parseInt(m.group(4));
                    cright = Integer.parseInt(m.group(6));
                }
                catch (NumberFormatException ex) {
                    log.error("could not parse context value", (Throwable)ex);
                }
                this.ui.getQueryController().setQuery(new PagedResultQuery(cleft, cright, 0L, 10, null, aql, selectedCorpora));
            } else {
                this.ui.getQueryController().setQuery(new Query(aql, QueryLanguage.AQL_QUIRKS_V3, selectedCorpora));
            }
            HashSet all = new HashSet(this.ui.getWindows());
            for (Window w : all) {
                this.ui.removeWindow(w);
            }
        } else {
            Notification.show((String)"Invalid citation", (Notification.Type)Notification.Type.WARNING_MESSAGE);
        }
    }

    private void evaluateFragment(String fragment) {
        if (fragment == null || fragment.isEmpty() || fragment.equals(this.lastEvaluatedFragment)) {
            return;
        }
        Map<String, String> args = Helper.parseFragment(fragment);
        if (args.containsKey("c")) {
            String[] originalCorpusNames = args.get("c").split("\\s*,\\s*");
            TreeSet<String> corpora = new TreeSet<String>(Arrays.asList(originalCorpusNames));
            try {
                CorporaApi api = new CorporaApi(Helper.getClient(this.ui));
                HashSet<String> availableCorpora = new HashSet<String>(api.listCorpora());
                corpora.removeIf(c -> !availableCorpora.contains(c));
            }
            catch (ApiException e) {
                ExceptionDialog.show(e, "Could not get corpus list", this.ui);
            }
            if (corpora.isEmpty()) {
                if (!Helper.getUser(this.ui.getSecurityContext()).isPresent() && this.toolbar != null) {
                    this.toolbar.showLoginWindow();
                } else {
                    new Notification("Linked corpus does not exist", "<div><p>The corpus you wanted to access unfortunally does not (yet) exist in ANNIS.</p><h2>possible reasons are:</h2><ul><li>that it has not been imported yet,</li><li>you don't have the access rights to see this corpus,</li><li>or the ANNIS service is not running.</li></ul><p>Please ask the responsible person of the site that contained the link to import the corpus.</p></div>", Notification.Type.WARNING_MESSAGE, true).show(Page.getCurrent());
                }
            } else {
                if (args.containsKey("c") && args.size() == 1) {
                    this.ui.getQueryState().getSelectedCorpora().clear();
                    this.ui.getQueryState().getSelectedCorpora().addAll(corpora);
                } else if (args.get("cl") != null && args.get("cr") != null) {
                    String matchSelectionRaw;
                    this.getControlPanel().getSearchOptions().setUpdateStateFromConfig(false);
                    DisplayedResultQuery query = (DisplayedResultQuery)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)QueryGenerator.displayed().left(Integer.parseInt(args.get("cl")))).right(Integer.parseInt(args.get("cr")))).offset(Integer.parseInt(args.get("s")))).limit(Integer.parseInt(args.get("l")))).segmentation(args.get("seg"))).baseText(args.get("bt")).query(args.get("q"))).corpora(corpora)).build();
                    if (query.getBaseText() == null && query.getSegmentation() != null) {
                        query.setBaseText(query.getSegmentation());
                    }
                    if (query.getBaseText() != null && query.getBaseText().isEmpty()) {
                        query.setBaseText(null);
                    }
                    if ((matchSelectionRaw = args.get("m")) != null) {
                        for (String selectedMatchNr : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)matchSelectionRaw)) {
                            try {
                                long nr = Long.parseLong(selectedMatchNr);
                                query.getSelectedMatches().add(nr);
                            }
                            catch (NumberFormatException ex) {
                                log.warn("Invalid long provided as selected match", (Throwable)ex);
                            }
                        }
                    }
                    if (args.get("o") != null) {
                        try {
                            query.setOrder(DisplayedResultQuery.parseOrderFromCitationFragment(args.get("0")));
                        }
                        catch (IllegalArgumentException ex) {
                            log.warn("Could not parse query fragment argument for order", (Throwable)ex);
                        }
                    }
                    if (args.get("ql") != null) {
                        try {
                            query.setQueryLanguage(QueryLanguage.valueOf(args.get("ql").toUpperCase()));
                        }
                        catch (IllegalArgumentException ex) {
                            log.warn("Could not parse query fragment argument for the query language", (Throwable)ex);
                        }
                    }
                    this.ui.getQueryController().setQuery(query);
                    this.ui.getQueryController().executeSearch(true, false);
                } else if (args.get("q") != null) {
                    QueryLanguage ql = QueryLanguage.AQL;
                    if (args.get("ql") != null) {
                        try {
                            ql = QueryLanguage.valueOf(args.get("ql").toUpperCase());
                        }
                        catch (IllegalArgumentException ex) {
                            log.warn("Could not parse query fragment argument for the query language", (Throwable)ex);
                        }
                    }
                    this.ui.getQueryController().setQuery(new Query(args.get("q"), ql, corpora));
                    this.ui.getQueryController().executeSearch(true, true);
                }
                this.getControlPanel().getCorpusList().scrollToSelectedCorpus();
            }
        }
    }

    public ControlPanel getControlPanel() {
        return this.controlPanel;
    }

    public DocBrowserController getDocBrowserController() {
        return this.docBrowserController;
    }

    public ResultViewPanel getLastSelectedResultView() {
        for (Component c : this.selectedTabHistory) {
            if (!(c instanceof ResultViewPanel) || this.mainTab.getTab(c) == null) continue;
            return (ResultViewPanel)c;
        }
        return null;
    }

    public TabSheet getMainTab() {
        return this.mainTab;
    }

    public MainToolbar getMainToolbar() {
        return this.toolbar;
    }

    public TabSheet getTabSheet() {
        return this.mainTab;
    }

    public void notifiyQueryStarted() {
        if (this.toolbar != null) {
            this.toolbar.notifiyQueryStarted();
        }
    }

    @Override
    public void notifyCannotPlayMimeType(String mimeType) {
        if (mimeType == null) {
            return;
        }
        if (mimeType.startsWith("audio/ogg") || mimeType.startsWith("video/web")) {
            String browserList = "<ul><li>Mozilla Firefox: <a href=\"http://www.mozilla.org/firefox\" target=\"_blank\">http://www.mozilla.org/firefox</a></li><li>Google Chrome: <a href=\"http://www.google.com/chrome\" target=\"_blank\">http://www.google.com/chrome</a></li></ul>";
            WebBrowser browser = Page.getCurrent().getWebBrowser();
            HashSet<String> supportedByIE9Plugin = new HashSet<String>();
            supportedByIE9Plugin.add("video/webm");
            supportedByIE9Plugin.add("audio/ogg");
            supportedByIE9Plugin.add("video/ogg");
            if (browser.isIE() && browser.getBrowserMajorVersion() >= 9 && supportedByIE9Plugin.contains(mimeType)) {
                Notification n = new Notification("Media file type unsupported by your browser", "Please install the WebM plugin for Internet Explorer 9 from <a target=\"_blank\" href=\"https://tools.google.com/dlpage/webmmf\">https://tools.google.com/dlpage/webmmf</a>  or use a browser from the following list (these are known to work with WebM or OGG files)<br/>" + browserList + "<br/><br /><strong>Click on this message to hide it</strong>", Notification.Type.WARNING_MESSAGE, true);
                n.setDelayMsec(15000);
                n.show(Page.getCurrent());
            } else {
                Notification n = new Notification("Media file type unsupported by your browser", "Please use a browser from the following list (these are known to work with WebM or OGG files)<br/>" + browserList + "<br/><br /><strong>Click on this message to hide it</strong>", Notification.Type.WARNING_MESSAGE, true);
                n.setDelayMsec(15000);
                n.show(Page.getCurrent());
            }
        } else {
            Notification.show((String)("Media file type \"" + mimeType + "\" unsupported by your browser!"), (String)"Try to check your browsers documentation how to enable support for the media type or inform the corpus creator about this problem.", (Notification.Type)Notification.Type.WARNING_MESSAGE);
        }
    }

    @Override
    public void notifyMightNotPlayMimeType(String mimeType) {
    }

    @Override
    public void onLogin() {
        this.getControlPanel().getCorpusList().updateCorpusSetList(true);
        this.evaluateFragment(Page.getCurrent().getUriFragment());
    }

    @Override
    public void onLogout() {
        this.getControlPanel().getCorpusList().updateCorpusSetList(false);
    }

    public void onTabClose(TabSheet tabsheet, Component tabContent) {
        if (tabsheet == this.mainTab) {
            this.selectedTabHistory.remove(tabContent);
            if (!this.selectedTabHistory.isEmpty()) {
                Component[] asArray = this.selectedTabHistory.toArray(new Component[this.selectedTabHistory.size()]);
                this.mainTab.setSelectedTab(asArray[asArray.length - 1]);
            }
        }
        tabsheet.removeComponent(tabContent);
        if (tabContent instanceof FrequencyQueryPanel) {
            this.controlPanel.getQueryPanel().notifyFrequencyTabClose();
        }
    }

    public void selectedTabChange(TabSheet.SelectedTabChangeEvent event) {
        Component tab = event.getTabSheet().getSelectedTab();
        if (tab != null) {
            this.selectedTabHistory.remove(tab);
            this.selectedTabHistory.add(tab);
        }
    }

    public void setToolbar(MainToolbar newToolbar) {
        if (this.toolbar != null) {
            this.removeComponent((Component)this.toolbar);
            this.toolbar = null;
        }
        if (newToolbar != null) {
            this.toolbar = newToolbar;
            this.addComponent((Component)this.toolbar, 0, 0, 1, 0);
        }
    }

    public void updateFragment(DisplayedResultQuery q) {
        this.lastEvaluatedFragment = q.toCitationFragment();
        UI.getCurrent().getPage().setUriFragment(this.lastEvaluatedFragment, false);
        Page.getCurrent().setTitle(this.ui.getInstanceConfig().getInstanceDisplayName() + " (ANNIS Corpus Search)");
    }

    @Override
    public void updateSidebarState(SidebarState state) {
        if (this.controlPanel != null && state != null) {
            this.controlPanel.setVisible(state.isSidebarVisible());
            this.ui.getSettings().set("annis-sidebar-state", state.name(), 30);
        }
    }

    public void uriFragmentChanged(Page.UriFragmentChangedEvent event) {
        this.evaluateFragment(event.getUriFragment());
    }

    public HelpPanel getHelpPanel() {
        return this.helpPanel;
    }

    private class CitationRequestHandler
    implements RequestHandler {
        private static final long serialVersionUID = -5700172209282345278L;

        private CitationRequestHandler() {
        }

        public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
            SearchView.this.checkCitation();
            return false;
        }
    }
}

