/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionInfo {
    private static final Logger log = LoggerFactory.getLogger(VersionInfo.class);
    private static final Properties versionProperties = new Properties();

    public static Date getBuildDate() {
        Date result = null;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            String raw = versionProperties.getProperty("build_date");
            if (raw != null) {
                result = format.parse(raw);
            }
        }
        catch (ParseException ex) {
            log.debug(null, (Throwable)ex);
        }
        return result;
    }

    public static String getBuildRevision() {
        return versionProperties.getProperty("build_revision", "");
    }

    public static String getReleaseName() {
        return versionProperties.getProperty("version", "");
    }

    public static String getVersion() {
        String rev = VersionInfo.getBuildRevision();
        Date date = VersionInfo.getBuildDate();
        StringBuilder result = new StringBuilder();
        result.append(VersionInfo.getReleaseName());
        if (!"".equals(rev) || date != null) {
            result.append(" (");
            boolean added = false;
            if (!"".equals(rev)) {
                result.append("rev. ");
                result.append(rev);
                added = true;
            }
            if (date != null) {
                result.append(added ? ", built " : "");
                SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                result.append(d.format(date));
            }
            result.append(")");
        }
        return result.toString();
    }

    static {
        try (InputStream is = VersionInfo.class.getResourceAsStream("version.properties");){
            versionProperties.load(is);
        }
        catch (IOException | NullPointerException ex) {
            log.warn("Could not load the version information", (Throwable)ex);
        }
    }
}

