/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.admin;

import com.google.common.util.concurrent.FutureCallback;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.ui.Component;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.VerticalLayout;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.corpus_tools.annis.ApiClient;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Background;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.LoginListener;
import org.corpus_tools.annis.gui.MainToolbar;
import org.corpus_tools.annis.gui.admin.CorpusAdminPanel;
import org.corpus_tools.annis.gui.admin.GroupManagementPanel;
import org.corpus_tools.annis.gui.admin.ImportPanel;
import org.corpus_tools.annis.gui.admin.controller.CorpusController;
import org.corpus_tools.annis.gui.admin.controller.GroupController;
import org.corpus_tools.annis.gui.admin.model.ApiClientProvider;
import org.corpus_tools.annis.gui.admin.model.CorpusManagement;
import org.corpus_tools.annis.gui.admin.model.GroupManagement;
import org.corpus_tools.annis.gui.admin.reflinks.MigrationPanel;
import org.corpus_tools.annis.gui.admin.reflinks.ReferenceLinkEditor;
import org.corpus_tools.annis.gui.admin.view.UIView;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class AdminView
extends VerticalLayout
implements View,
UIView,
LoginListener,
TabSheet.SelectedTabChangeListener,
ApiClientProvider {
    private static final long serialVersionUID = -5142632455076589645L;
    public static final String NAME = "admin";
    private final List<UIView.Listener> listeners = new LinkedList<UIView.Listener>();
    private final TabSheet tabSheet;
    private final ImportPanel importPanel;
    private final CorpusAdminPanel corpusAdminPanel;
    private final GroupManagementPanel groupManagementPanel;
    private MainToolbar toolbar;
    private final AnnisUI ui;
    private final SecurityContext securityContext;
    private MigrationPanel migrationPanel;
    private ReferenceLinkEditor referenceLinkEditor;

    public AdminView(AnnisUI ui) {
        this.ui = ui;
        this.securityContext = SecurityContextHolder.getContext();
        Page.getCurrent().setTitle("ANNIS Adminstration");
        GroupManagement groupManagement = new GroupManagement();
        groupManagement.setWebResourceProvider(this);
        CorpusManagement corpusManagement = new CorpusManagement();
        corpusManagement.setClientProvider(this);
        boolean isLoggedIn = Helper.getUser(this.securityContext).isPresent();
        this.corpusAdminPanel = new CorpusAdminPanel();
        new CorpusController(corpusManagement, this.corpusAdminPanel, this, isLoggedIn);
        this.groupManagementPanel = new GroupManagementPanel();
        new GroupController(groupManagement, corpusManagement, this.groupManagementPanel, this, isLoggedIn);
        this.importPanel = new ImportPanel();
        this.migrationPanel = new MigrationPanel();
        this.referenceLinkEditor = new ReferenceLinkEditor();
        this.tabSheet = new TabSheet();
        this.tabSheet.addTab((Component)this.importPanel, "Import Corpus", (Resource)VaadinIcons.UPLOAD);
        this.tabSheet.addTab((Component)this.corpusAdminPanel, "Corpus management", (Resource)VaadinIcons.LIST);
        this.tabSheet.addTab((Component)this.groupManagementPanel, "Group management", (Resource)VaadinIcons.USERS);
        this.tabSheet.addTab((Component)this.referenceLinkEditor, "Reference links", (Resource)VaadinIcons.CONNECT);
        this.tabSheet.addTab((Component)this.migrationPanel, "Reference link migration", (Resource)VaadinIcons.CLOUD_DOWNLOAD_O);
        this.tabSheet.setSizeFull();
        this.tabSheet.addSelectedTabChangeListener((TabSheet.SelectedTabChangeListener)this);
        this.addComponents(new Component[]{this.tabSheet});
        this.setSizeFull();
        this.setMargin(false);
        this.setExpandRatio((Component)this.tabSheet, 1.0f);
        this.tabSheet.addStyleName("framed");
    }

    @Override
    public void addListener(UIView.Listener listener) {
        this.listeners.add(listener);
    }

    public void detach() {
        for (UIView.Listener l : this.listeners) {
            l.loadedTab(null);
        }
        super.detach();
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        this.importPanel.updateMode(Helper.getUser(this.securityContext).isPresent());
        this.tabSheet.getTab((Component)this.groupManagementPanel).setVisible(!this.ui.isDesktopMode());
        this.tabSheet.getTab((Component)this.migrationPanel).setVisible(!this.ui.isDesktopMode());
        this.tabSheet.getTab((Component)this.referenceLinkEditor).setVisible(!this.ui.isDesktopMode());
        Component selectedTab = this.getComponentForFragment(event.getParameters());
        if (selectedTab != null && selectedTab != this.tabSheet.getSelectedTab()) {
            this.tabSheet.setSelectedTab(selectedTab);
        } else {
            selectedTab = this.tabSheet.getSelectedTab();
            for (UIView.Listener l : this.listeners) {
                l.loadedTab(selectedTab);
            }
            this.setFragmentParameter(this.getFragmentForComponent(selectedTab));
        }
    }

    private Component getComponentForFragment(String fragment) {
        if (fragment != null) {
            switch (fragment) {
                case "import": {
                    return this.importPanel;
                }
                case "corpora": {
                    return this.corpusAdminPanel;
                }
                case "groups": {
                    return this.groupManagementPanel;
                }
                case "reference-link-migration": {
                    return this.migrationPanel;
                }
                case "reference-link-editor": {
                    return this.referenceLinkEditor;
                }
            }
        }
        return null;
    }

    private String getFragmentForComponent(Component c) {
        if (c == this.importPanel) {
            return "import";
        }
        if (c == this.corpusAdminPanel) {
            return "corpora";
        }
        if (c == this.groupManagementPanel) {
            return "groups";
        }
        if (c == this.migrationPanel) {
            return "reference-link-migration";
        }
        if (c == this.referenceLinkEditor) {
            return "reference-link-editor";
        }
        return "";
    }

    @Override
    public void invalidateClient() {
    }

    @Override
    public void onLogin() {
        for (UIView.Listener l : this.listeners) {
            l.loginChanged(true);
        }
        if (this.importPanel != null) {
            this.importPanel.onLogin();
        }
    }

    @Override
    public void onLogout() {
        for (UIView.Listener l : this.listeners) {
            l.loginChanged(false);
        }
        if (this.importPanel != null) {
            this.importPanel.onLogout();
        }
    }

    @Override
    public <T> void runInBackground(Callable<T> job, FutureCallback<T> callback) {
        Background.runWithCallback(job, callback);
    }

    public void selectedTabChange(TabSheet.SelectedTabChangeEvent event) {
        Component selected = event.getTabSheet().getSelectedTab();
        for (UIView.Listener l : this.listeners) {
            l.loadedTab(selected);
        }
        this.setFragmentParameter(this.getFragmentForComponent(selected));
    }

    private void setFragmentParameter(String param) {
        Page.getCurrent().setUriFragment("!admin/" + param, false);
    }

    public void setToolbar(MainToolbar newToolbar) {
        if (this.toolbar != null) {
            this.removeComponent((Component)this.toolbar);
            this.toolbar = null;
        }
        if (newToolbar != null) {
            this.toolbar = newToolbar;
            this.addComponent((Component)this.toolbar, 0);
            this.setExpandRatio((Component)this.toolbar, 0.0f);
            this.toolbar.addLoginListener(this);
        }
    }

    @Override
    public void showBackgroundInfo(String info, String description) {
        Notification.show((String)info, (String)description, (Notification.Type)Notification.Type.TRAY_NOTIFICATION);
    }

    @Override
    public void showError(String error, String description) {
        Notification.show((String)error, (String)description, (Notification.Type)Notification.Type.ERROR_MESSAGE);
    }

    @Override
    public void showInfo(String info, String description) {
        Notification.show((String)info, (String)description, (Notification.Type)Notification.Type.HUMANIZED_MESSAGE);
    }

    @Override
    public void showWarning(String error, String description) {
        Notification.show((String)error, (String)description, (Notification.Type)Notification.Type.WARNING_MESSAGE);
    }

    @Override
    public ApiClient getClient() {
        return this.ui.getClient();
    }
}

