/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.admin;

import com.vaadin.data.ValueProvider;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.corpus_tools.annis.gui.admin.view.CorpusListView;

public class CorpusAdminPanel
extends Panel
implements CorpusListView {
    private static final long serialVersionUID = 2132712553250095606L;
    private final List<CorpusListView.Listener> listeners = new LinkedList<CorpusListView.Listener>();
    private final Grid<String> corporaGrid = new Grid();

    public CorpusAdminPanel() {
        this.corporaGrid.setSizeFull();
        this.corporaGrid.setSelectionMode(Grid.SelectionMode.MULTI);
        Grid.Column corpusColumn = this.corporaGrid.addColumn((ValueProvider & Serializable)corpus -> corpus);
        corpusColumn.setCaption("Corpus Name");
        Button btDelete = new Button("Delete selected");
        btDelete.addClickListener((Button.ClickListener & Serializable)event -> {
            Set selection = this.corporaGrid.getSelectedItems();
            if (!selection.isEmpty()) {
                for (CorpusListView.Listener l : this.listeners) {
                    l.deleteCorpora(selection);
                }
            }
            this.corporaGrid.asMultiSelect().clear();
        });
        VerticalLayout layout = new VerticalLayout(new Component[]{btDelete, this.corporaGrid});
        layout.setSizeFull();
        layout.setExpandRatio(this.corporaGrid, 1.0f);
        layout.setSpacing(true);
        layout.setMargin(new MarginInfo(true, false, false, false));
        layout.setComponentAlignment((Component)btDelete, Alignment.MIDDLE_CENTER);
        this.setContent((Component)layout);
        this.setSizeFull();
    }

    @Override
    public void addListener(CorpusListView.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void setAvailableCorpora(Collection<String> corpora) {
        this.corporaGrid.setItems(corpora);
    }
}

