/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.admin;

import com.vaadin.event.Action;
import com.vaadin.event.ShortcutAction;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.fieldgroup.FieldGroup;
import com.vaadin.v7.data.util.BeanContainer;
import com.vaadin.v7.data.util.GeneratedPropertyContainer;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.PropertyValueGenerator;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.Grid;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.renderers.ButtonRenderer;
import com.vaadin.v7.ui.renderers.ClickableRenderer;
import com.vaadin.v7.ui.renderers.Renderer;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.corpus_tools.annis.api.model.Group;
import org.corpus_tools.annis.gui.admin.EditSingleGroup;
import org.corpus_tools.annis.gui.admin.view.GroupListView;
import org.corpus_tools.annis.gui.converter.CommaSeperatedStringConverterSet;

public class GroupManagementPanel
extends Panel
implements GroupListView {
    private static final long serialVersionUID = -4159690760269810930L;
    private final List<GroupListView.Listener> listeners = new LinkedList<GroupListView.Listener>();
    private final Grid groupsGrid = new Grid();
    private final TextField txtGroupName;
    private final ProgressBar progress;
    private final HorizontalLayout actionLayout;
    private final BeanContainer<String, Group> groupsContainer = new BeanContainer(Group.class);
    private final IndexedContainer corpusContainer = new IndexedContainer();

    public GroupManagementPanel() {
        this.groupsContainer.setBeanIdProperty((Object)"name");
        this.progress = new ProgressBar();
        this.progress.setCaption("Loading group list");
        this.progress.setIndeterminate(true);
        this.progress.setVisible(false);
        GeneratedPropertyContainer generated = new GeneratedPropertyContainer(this.groupsContainer);
        generated.addGeneratedProperty((Object)"edit", (PropertyValueGenerator)new PropertyValueGenerator<String>(){
            private static final long serialVersionUID = -4167110257296656329L;

            public Class<String> getType() {
                return String.class;
            }

            public String getValue(Item item, Object itemId, Object propertyId) {
                return "Edit";
            }
        });
        this.groupsGrid.setContainerDataSource((Container.Indexed)generated);
        this.groupsGrid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.groupsGrid.setSizeFull();
        this.groupsGrid.setColumns(new Object[]{"name", "edit", "corpora"});
        Grid.HeaderRow filterRow = this.groupsGrid.appendHeaderRow();
        TextField groupFilterField = new TextField();
        groupFilterField.setInputPrompt("Filter");
        groupFilterField.addTextChangeListener((FieldEvents.TextChangeListener & Serializable)event -> {
            this.groupsContainer.removeContainerFilters((Object)"name");
            if (!event.getText().isEmpty()) {
                this.groupsContainer.addContainerFilter((Container.Filter)new SimpleStringFilter((Object)"name", event.getText(), true, false));
            }
        });
        ((Grid.HeaderCell)filterRow.getCell((Object)"name")).setComponent((Component)groupFilterField);
        TextField corpusFilterField = new TextField();
        corpusFilterField.setInputPrompt("Filter by corpus");
        corpusFilterField.addTextChangeListener((FieldEvents.TextChangeListener & Serializable)event -> {
            this.groupsContainer.removeContainerFilters((Object)"corpora");
            if (!event.getText().isEmpty()) {
                this.groupsContainer.addContainerFilter((Container.Filter)new StringPatternInSetFilter("corpora", event.getText()));
            }
        });
        ((Grid.HeaderCell)filterRow.getCell((Object)"corpora")).setComponent((Component)corpusFilterField);
        Grid.Column editColumn = this.groupsGrid.getColumn((Object)"edit");
        editColumn.setRenderer((Renderer)new ButtonRenderer((ClickableRenderer.RendererClickListener & Serializable)event -> {
            Group g = (Group)this.groupsContainer.getItem(event.getItemId()).getBean();
            FieldGroup fields = new FieldGroup((Item)this.groupsContainer.getItem(event.getItemId()));
            fields.addCommitHandler((FieldGroup.CommitHandler)new GroupCommitHandler(g.getName()));
            EditSingleGroup edit = new EditSingleGroup(fields, this.corpusContainer);
            Window w = new Window("Edit group \"" + g.getName() + "\"");
            w.setContent((Component)edit);
            w.setModal(true);
            w.setWidth("500px");
            w.setHeight("250px");
            UI.getCurrent().addWindow(w);
        }));
        Grid.Column corporaColumn = this.groupsGrid.getColumn((Object)"corpora");
        corporaColumn.setConverter((Converter)new CommaSeperatedStringConverterSet());
        this.txtGroupName = new TextField();
        this.txtGroupName.setInputPrompt("New group name");
        Button btAddNewGroup = new Button("Add new group");
        btAddNewGroup.addClickListener((Button.ClickListener & Serializable)event -> this.handleAdd());
        btAddNewGroup.addStyleName("default");
        Button btDeleteGroup = new Button("Delete selected group(s)");
        btDeleteGroup.addClickListener((Button.ClickListener & Serializable)event -> {
            TreeSet<String> selectedGroups = new TreeSet<String>();
            for (Object id : this.groupsGrid.getSelectedRows()) {
                selectedGroups.add((String)id);
            }
            this.groupsGrid.getSelectionModel().reset();
            for (GroupListView.Listener l : this.listeners) {
                l.deleteGroups(selectedGroups);
            }
        });
        this.actionLayout = new HorizontalLayout(new Component[]{this.txtGroupName, btAddNewGroup, btDeleteGroup});
        VerticalLayout layout = new VerticalLayout(new Component[]{this.actionLayout, this.progress, this.groupsGrid});
        layout.setSizeFull();
        layout.setExpandRatio((Component)this.groupsGrid, 1.0f);
        layout.setExpandRatio((Component)this.progress, 1.0f);
        layout.setSpacing(true);
        layout.setMargin(new MarginInfo(true, false, false, false));
        layout.setComponentAlignment((Component)this.actionLayout, Alignment.MIDDLE_CENTER);
        layout.setComponentAlignment((Component)this.progress, Alignment.TOP_CENTER);
        this.setContent((Component)layout);
        this.setSizeFull();
        this.addActionHandler(new AddGroupHandler(this.txtGroupName));
    }

    @Override
    public void addAvailableCorpusNames(Collection<String> corpusNames) {
        for (String c : corpusNames) {
            this.corpusContainer.addItem((Object)c);
        }
    }

    @Override
    public void addListener(GroupListView.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void emptyNewGroupNameTextField() {
        this.txtGroupName.setValue("");
    }

    private void handleAdd() {
        for (GroupListView.Listener l : this.listeners) {
            l.addNewGroup((String)this.txtGroupName.getValue());
        }
    }

    @Override
    public void setGroupList(Collection<Group> groups) {
        this.groupsContainer.removeAllItems();
        this.groupsContainer.addAll(groups);
    }

    @Override
    public void setLoadingAnimation(boolean show) {
        this.progress.setVisible(show);
        this.groupsGrid.setVisible(!show);
        this.actionLayout.setEnabled(!show);
    }

    public static class StringPatternInSetFilter
    implements Container.Filter {
        private static final long serialVersionUID = 4056375452214888364L;
        private final Object propertyId;
        private final String pattern;

        public StringPatternInSetFilter(Object propertyId, String pattern) {
            this.propertyId = propertyId;
            this.pattern = pattern.toLowerCase();
        }

        public boolean appliesToProperty(Object propertyId) {
            return this.propertyId.equals(propertyId);
        }

        public boolean passesFilter(Object itemId, Item item) throws UnsupportedOperationException {
            Property p = item.getItemProperty(this.propertyId);
            if (p.getValue() instanceof Set) {
                Set val = (Set)p.getValue();
                for (Object o : val) {
                    if (!o.toString().toLowerCase().contains(this.pattern)) continue;
                    return true;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            return false;
        }
    }

    private class GroupCommitHandler
    implements FieldGroup.CommitHandler {
        private static final long serialVersionUID = -3816526526945191335L;
        private String groupName;

        public GroupCommitHandler(String groupName) {
            this.groupName = groupName;
        }

        public void postCommit(FieldGroup.CommitEvent commitEvent) throws FieldGroup.CommitException {
            for (GroupListView.Listener l : GroupManagementPanel.this.listeners) {
                l.groupUpdated((Group)GroupManagementPanel.this.groupsContainer.getItem((Object)this.groupName).getBean());
            }
        }

        public void preCommit(FieldGroup.CommitEvent commitEvent) throws FieldGroup.CommitException {
        }
    }

    public class AddGroupHandler
    implements Action.Handler {
        private static final long serialVersionUID = -4855324916352101750L;
        private final Action enterKeyShortcutAction = new ShortcutAction(null, 13, null);
        private final Object registeredTarget;

        public AddGroupHandler(Object registeredTarget) {
            this.registeredTarget = registeredTarget;
        }

        public Action[] getActions(Object target, Object sender) {
            return new Action[]{this.enterKeyShortcutAction};
        }

        public void handleAction(Action action, Object sender, Object target) {
            if (action == this.enterKeyShortcutAction && target == this.registeredTarget) {
                GroupManagementPanel.this.handleAdd();
            }
        }
    }
}

