/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.admin;

import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.UI;
import com.vaadin.ui.Upload;
import com.vaadin.ui.VerticalLayout;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.util.List;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.ApiResponse;
import org.corpus_tools.annis.JSON;
import org.corpus_tools.annis.api.AdministrationApi;
import org.corpus_tools.annis.api.model.ImportResult;
import org.corpus_tools.annis.api.model.Job;
import org.corpus_tools.annis.gui.Background;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.LoginListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class ImportPanel
extends Panel
implements Upload.ProgressListener,
Upload.FinishedListener,
Upload.StartedListener,
Upload.Receiver,
LoginListener {
    private static final long serialVersionUID = 2246043360503976290L;
    private static final Logger log = LoggerFactory.getLogger(ImportPanel.class);
    private final VerticalLayout layout;
    private final TextArea txtMessages;
    private final Upload upload;
    private final CheckBox cbOverwrite;
    private final ProgressBar progress;
    private final Label lblProgress;
    private final Button btDetailedLog;
    private File temporaryCorpusFile;

    public ImportPanel() {
        this.setSizeFull();
        this.layout = new VerticalLayout();
        this.layout.setWidth("100%");
        this.layout.setHeight("100%");
        this.layout.setMargin(true);
        this.setContent((Component)this.layout);
        FormLayout form = new FormLayout();
        this.layout.addComponent((Component)form);
        this.cbOverwrite = new CheckBox("Overwrite existing corpus");
        form.addComponent((Component)this.cbOverwrite);
        HorizontalLayout actionBar = new HorizontalLayout();
        actionBar.setSpacing(true);
        actionBar.setWidth("100%");
        this.upload = new Upload("", (Upload.Receiver)this);
        this.upload.setButtonCaption("Upload ZIP file with relANNIS corpus and start import");
        this.upload.addStartedListener((Upload.StartedListener)this);
        this.upload.addFinishedListener((Upload.FinishedListener)this);
        this.upload.setEnabled(true);
        actionBar.addComponent((Component)this.upload);
        this.progress = new ProgressBar();
        this.progress.setIndeterminate(true);
        this.progress.setVisible(false);
        actionBar.addComponent((Component)this.progress);
        this.lblProgress = new Label();
        this.lblProgress.setWidth("100%");
        actionBar.addComponent((Component)this.lblProgress);
        actionBar.setExpandRatio((Component)this.lblProgress, 1.0f);
        actionBar.setComponentAlignment((Component)this.lblProgress, Alignment.MIDDLE_LEFT);
        actionBar.setComponentAlignment((Component)this.upload, Alignment.MIDDLE_LEFT);
        actionBar.setComponentAlignment((Component)this.progress, Alignment.MIDDLE_LEFT);
        this.layout.addComponent((Component)actionBar);
        this.btDetailedLog = new Button();
        this.btDetailedLog.setStyleName("link");
        this.btDetailedLog.addClickListener((Button.ClickListener & Serializable)event -> this.setLogVisible(!this.isLogVisible()));
        this.layout.addComponent((Component)this.btDetailedLog);
        this.txtMessages = new TextArea();
        this.txtMessages.setSizeFull();
        this.txtMessages.setValue("");
        this.txtMessages.setReadOnly(true);
        this.layout.addComponent((Component)this.txtMessages);
        this.layout.setExpandRatio((Component)this.txtMessages, 1.0f);
        this.setLogVisible(false);
        this.appendMessage("Ready.");
    }

    private void appendMessage(String message) {
        this.lblProgress.setValue(message);
        this.txtMessages.setReadOnly(false);
        String oldVal = this.txtMessages.getValue();
        if (oldVal == null || oldVal.isEmpty()) {
            this.txtMessages.setValue(message);
        } else {
            this.txtMessages.setValue(oldVal + "\n" + message);
        }
        this.txtMessages.setCursorPosition(this.txtMessages.getValue().length() - 1);
        this.txtMessages.setReadOnly(true);
    }

    private boolean isLogVisible() {
        return this.txtMessages.isVisible();
    }

    @Override
    public void onLogin() {
        this.upload.setEnabled(true);
    }

    @Override
    public void onLogout() {
        this.upload.setEnabled(false);
    }

    public OutputStream receiveUpload(String filename, String mimeType) {
        try {
            this.temporaryCorpusFile = File.createTempFile(filename, ".zip");
            this.temporaryCorpusFile.deleteOnExit();
            return new FileOutputStream(this.temporaryCorpusFile);
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
    }

    private void setLogVisible(boolean visible) {
        this.txtMessages.setVisible(visible);
        if (visible) {
            this.btDetailedLog.setCaption("Hide log");
            this.btDetailedLog.setIcon((Resource)VaadinIcons.MINUS_SQUARE_LEFT_O, "minus sign");
            this.layout.setExpandRatio((Component)this.btDetailedLog, 0.0f);
        } else {
            this.btDetailedLog.setCaption("Show log");
            this.btDetailedLog.setIcon((Resource)VaadinIcons.PLUS_SQUARE_LEFT_O, "plus sign");
            this.layout.setExpandRatio((Component)this.btDetailedLog, 1.0f);
        }
    }

    private void startImport() {
        AdministrationApi api = new AdministrationApi(Helper.getClient(UI.getCurrent()));
        try {
            ApiResponse<ImportResult> response = api.importPostWithHttpInfo(this.temporaryCorpusFile, this.cbOverwrite.getValue());
            if (response.getStatusCode() == HttpStatus.ACCEPTED.value()) {
                String uuid = response.getData().getUuid();
                this.appendMessage("Import requested, update UUID is " + uuid);
                UI ui = UI.getCurrent();
                Background.run(new WaitForFinishRunner(uuid, ui));
            } else {
                this.upload.setEnabled(true);
                this.progress.setVisible(false);
                this.appendMessage("Error (response code " + response.getStatusCode() + ")");
            }
        }
        catch (ApiException ex) {
            this.upload.setEnabled(true);
            this.progress.setVisible(false);
            this.appendMessage("Error (response code " + ex.getCode() + "): " + ex.getResponseBody());
        }
    }

    public void updateMode(boolean isLoggedIn) {
        this.upload.setEnabled(isLoggedIn);
    }

    public void updateProgress(long readBytes, long contentLength) {
        float ratioComplete = (float)readBytes / (float)contentLength;
        DecimalFormat format = new DecimalFormat("#0.00");
        this.appendMessage("uploaded " + format.format(ratioComplete * 100.0f) + "%");
    }

    public void uploadFinished(Upload.FinishedEvent event) {
        this.appendMessage("Finished upload, starting import");
        this.startImport();
    }

    public void uploadStarted(Upload.StartedEvent event) {
        this.upload.setEnabled(false);
        this.progress.setVisible(true);
        this.progress.setEnabled(true);
        this.appendMessage("Started upload");
        event.getUpload().addProgressListener((Upload.ProgressListener)this);
    }

    private class WaitForFinishRunner
    implements Runnable {
        private final UI ui;
        private final String uuid;
        private int currentMessageIndex = 0;
        private JSON json;

        public WaitForFinishRunner(String uuid, UI ui) {
            this.ui = ui;
            this.uuid = uuid;
            this.json = new JSON();
        }

        private void appendFromBackground(List<String> message) {
            for (String m : message) {
                this.appendFromBackground(m);
            }
        }

        private void appendFromBackground(String message) {
            this.ui.access(() -> ImportPanel.this.appendMessage(message));
        }

        private void outputNewMessages(List<String> allMessages) {
            if (this.currentMessageIndex < allMessages.size()) {
                List<String> newMessages = allMessages.subList(this.currentMessageIndex, allMessages.size());
                this.currentMessageIndex = allMessages.size();
                this.appendFromBackground(newMessages);
            }
        }

        @Override
        public void run() {
            AdministrationApi api = new AdministrationApi(Helper.getClient(this.ui));
            Job job = null;
            try {
                do {
                    job = null;
                    ApiResponse response = api.getApiClient().execute(api.getJobCall(this.uuid, null), (Type)((Object)String.class));
                    int statusCode = response.getStatusCode();
                    if (statusCode == HttpStatus.ACCEPTED.value()) {
                        job = (Job)this.json.deserialize((String)response.getData(), (Type)((Object)Job.class));
                        this.outputNewMessages(job.getMessages());
                    } else if (statusCode == HttpStatus.OK.value()) {
                        String[] finishMessages = (String[])this.json.deserialize((String)response.getData(), (Type)((Object)String[].class));
                        for (int i = 0; i < finishMessages.length; ++i) {
                            this.appendFromBackground(finishMessages[i]);
                        }
                    } else {
                        this.appendFromBackground("Unknown status code " + response.getStatusCode());
                    }
                    Thread.sleep(500L);
                } while (job != null && job.getStatus() == Job.StatusEnum.RUNNING);
                if (job == null) {
                    this.appendFromBackground("Finished.");
                }
                if (job != null) {
                    if (job.getStatus() == Job.StatusEnum.FAILED) {
                        this.appendFromBackground("FAILED.");
                    } else {
                        this.appendFromBackground("Unknown status.");
                    }
                }
                this.ui.access(() -> {
                    ImportPanel.this.progress.setVisible(false);
                    ImportPanel.this.upload.setEnabled(true);
                });
            }
            catch (InterruptedException ex) {
                log.error(null, (Throwable)ex);
                Thread.currentThread().interrupt();
            }
            catch (ApiException ex) {
                if (ex.getCode() == HttpStatus.GONE.value()) {
                    job = (Job)this.json.deserialize(ex.getResponseBody(), (Type)((Object)Job.class));
                    this.outputNewMessages(job.getMessages());
                } else {
                    this.appendFromBackground("Exception while polling for import status: " + ex.getMessage() + "\n" + ex.getResponseBody());
                }
                this.ui.access(() -> {
                    ImportPanel.this.progress.setVisible(false);
                    ImportPanel.this.upload.setEnabled(true);
                });
            }
        }
    }
}

