/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.admin;

import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.PopupView;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.ItemSorter;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.ui.AbstractTextField;
import com.vaadin.v7.ui.CustomField;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.TwinColSelect;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.corpus_tools.annis.gui.CaseSensitiveOrder;
import org.corpus_tools.annis.gui.converter.CommaSeperatedStringConverterSet;
import org.corpus_tools.annis.gui.converter.TreeSetConverter;

public class PopupTwinColumnSelect
extends CustomField<Set> {
    private static final long serialVersionUID = -7972139316697398658L;
    private final HorizontalLayout layout;
    private final AbstractTextField txtValue;
    private final TwinColSelect selector;
    private IndexedContainer selectableContainer = new IndexedContainer();

    public PopupTwinColumnSelect() {
        this.txtValue = this.createTextField();
        this.txtValue.setConverter((Converter)new CommaSeperatedStringConverterSet());
        this.txtValue.setWidth("100%");
        this.txtValue.setPropertyDataSource((Property)this);
        this.selector = new TwinColSelect();
        this.selector.setConverter((Converter)new TreeSetConverter());
        this.selector.setNewItemsAllowed(false);
        this.selector.setLeftColumnCaption("Available");
        this.selector.setRightColumnCaption("Selected");
        this.selector.setContainerDataSource((Container)this.selectableContainer);
        this.selector.setWidth("44em");
        this.selector.setPropertyDataSource((Property)this);
        PopupView popup = new PopupView("Select", (Component)this.selector);
        this.layout = new HorizontalLayout(new Component[]{popup, this.txtValue});
        this.layout.setExpandRatio((Component)popup, 0.0f);
        this.layout.setExpandRatio((Component)this.txtValue, 1.0f);
        this.layout.setWidth("100%");
        this.layout.setSpacing(true);
        this.addValueChangeListener(new UpdateContainerListener());
    }

    protected AbstractTextField createTextField() {
        return new TextField();
    }

    public IndexedContainer getSelectableContainer() {
        return this.selectableContainer;
    }

    public Class<? extends Set> getType() {
        return Set.class;
    }

    protected Component initContent() {
        return this.layout;
    }

    public void setCaption(String caption) {
        super.setCaption(caption);
        this.selector.setCaption(caption);
    }

    public void setSelectableContainer(IndexedContainer selectableContainer) {
        this.selectableContainer = selectableContainer;
        this.selectableContainer.setItemSorter((ItemSorter)new StringItemSorter());
        this.selectableContainer.sort(new Object[0], new boolean[0]);
        this.selector.setContainerDataSource((Container)this.selectableContainer);
    }

    public void setValue(Set newFieldValue) throws Property.ReadOnlyException {
        if (newFieldValue != null && !(newFieldValue instanceof TreeSet)) {
            TreeSet<String> sortedSet = new TreeSet<String>(CaseSensitiveOrder.INSTANCE);
            for (Object e : newFieldValue) {
                if (!(e instanceof String)) continue;
                sortedSet.add((String)e);
            }
            newFieldValue = sortedSet;
        }
        super.setValue(newFieldValue);
    }

    public class UpdateContainerListener
    implements Property.ValueChangeListener {
        private static final long serialVersionUID = 9023840978945536294L;

        public void valueChange(Property.ValueChangeEvent event) {
            Object val = event.getProperty().getValue();
            if (val instanceof Collection) {
                for (Object id : (Collection)val) {
                    PopupTwinColumnSelect.this.selectableContainer.addItem(id);
                }
            } else {
                PopupTwinColumnSelect.this.selectableContainer.addItem(val);
            }
            PopupTwinColumnSelect.this.selectableContainer.sort(new Object[0], new boolean[0]);
        }
    }

    public static class StringItemSorter
    implements ItemSorter {
        private static final long serialVersionUID = 1926594984666450829L;

        public int compare(Object itemId1, Object itemId2) {
            if (itemId1 instanceof String && itemId2 instanceof String) {
                return CaseSensitiveOrder.INSTANCE.compare((String)itemId1, (String)itemId2);
            }
            return 0;
        }

        public void setSortProperties(Container.Sortable container, Object[] propertyId, boolean[] ascending) {
        }
    }
}

