/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.admin.controller;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.corpus_tools.annis.gui.CriticalServiceQueryException;
import org.corpus_tools.annis.gui.ServiceQueryException;
import org.corpus_tools.annis.gui.admin.model.CorpusManagement;
import org.corpus_tools.annis.gui.admin.view.CorpusListView;
import org.corpus_tools.annis.gui.admin.view.UIView;

public class CorpusController
implements CorpusListView.Listener,
UIView.Listener {
    private static final long serialVersionUID = -3931526662554533493L;
    private final CorpusManagement model;
    private final CorpusListView view;
    private final UIView uiView;
    private boolean isLoggedIn = false;
    private boolean viewIsActive = false;

    public CorpusController(CorpusManagement model, CorpusListView view, UIView uiView, boolean isLoggedIn) {
        this.model = model;
        this.view = view;
        this.uiView = uiView;
        this.isLoggedIn = isLoggedIn;
        view.addListener(this);
        uiView.addListener(this);
    }

    private void clearModel() {
        this.model.clear();
        this.view.setAvailableCorpora((Collection<String>)this.model.getCorpora());
    }

    @Override
    public void deleteCorpora(Set<String> corpusName) {
        LinkedHashSet<String> deleted = new LinkedHashSet<String>();
        for (String c : corpusName) {
            try {
                this.model.delete(c);
                deleted.add(c);
            }
            catch (CriticalServiceQueryException ex) {
                this.uiView.showWarning(ex.getMessage(), null);
            }
            catch (ServiceQueryException ex) {
                this.uiView.showInfo(ex.getMessage(), null);
            }
        }
        if (!deleted.isEmpty()) {
            this.uiView.showInfo("Deleted corpora: " + Joiner.on((String)", ").join(deleted), null);
        }
        this.view.setAvailableCorpora((Collection<String>)this.model.getCorpora());
    }

    private void fetchFromService() {
        try {
            this.model.fetchFromService();
            this.view.setAvailableCorpora((Collection<String>)this.model.getCorpora());
        }
        catch (CriticalServiceQueryException ex) {
            this.uiView.showWarning("Cannot get the corpus list", null);
            this.view.setAvailableCorpora(new LinkedList<String>());
        }
        catch (ServiceQueryException ex) {
            this.uiView.showInfo("Cannot get the corpus list", null);
            this.view.setAvailableCorpora(new LinkedList<String>());
        }
    }

    @Override
    public void loadedTab(Object selectedTab) {
        boolean bl = this.viewIsActive = selectedTab == this.view;
        if (this.isLoggedIn && this.viewIsActive) {
            this.fetchFromService();
        }
    }

    @Override
    public void loginChanged(boolean isLoggedIn) {
        this.isLoggedIn = isLoggedIn;
        if (this.model.getClientProvider() != null) {
            this.model.getClientProvider().invalidateClient();
        }
        if (isLoggedIn && this.viewIsActive) {
            this.fetchFromService();
        } else {
            this.clearModel();
        }
    }
}

