/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.admin.controller;

import com.google.common.base.Joiner;
import com.google.common.util.concurrent.FutureCallback;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.corpus_tools.annis.api.model.Group;
import org.corpus_tools.annis.gui.CriticalServiceQueryException;
import org.corpus_tools.annis.gui.ServiceQueryException;
import org.corpus_tools.annis.gui.admin.model.CorpusManagement;
import org.corpus_tools.annis.gui.admin.model.GroupManagement;
import org.corpus_tools.annis.gui.admin.view.GroupListView;
import org.corpus_tools.annis.gui.admin.view.UIView;

public class GroupController
implements GroupListView.Listener,
UIView.Listener {
    private static final long serialVersionUID = -6490890559663078065L;
    private final GroupManagement model;
    private final CorpusManagement corpusModel;
    private final GroupListView view;
    private final UIView uiView;
    private boolean isLoggedIn = false;
    private boolean viewIsActive = false;

    public GroupController(GroupManagement model, CorpusManagement corpusModel, GroupListView view, UIView uiView, boolean isLoggedIn) {
        this.model = model;
        this.corpusModel = corpusModel;
        this.view = view;
        this.uiView = uiView;
        this.isLoggedIn = isLoggedIn;
        this.view.addListener(this);
        this.uiView.addListener(this);
    }

    @Override
    public void addNewGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            this.uiView.showError("Group name is empty", null);
        } else if (this.model.getGroup(groupName) != null) {
            this.uiView.showError("Group already exists", null);
        } else {
            Group g = new Group();
            g.setName(groupName);
            g.setCorpora(new LinkedList<String>());
            this.model.createOrUpdateGroup(g);
            this.view.setGroupList(this.model.getGroups());
            this.view.emptyNewGroupNameTextField();
            this.updateUserUI();
        }
    }

    private void clearModel() {
        this.model.clear();
        this.corpusModel.clear();
        this.view.setGroupList(this.model.getGroups());
    }

    @Override
    public void deleteGroups(Set<String> groupName) {
        for (String g : groupName) {
            this.model.deleteGroup(g);
        }
        this.view.setGroupList(this.model.getGroups());
        if (groupName.size() == 1) {
            this.uiView.showInfo("Group \"" + groupName.iterator().next() + "\" was deleted", null);
        } else {
            this.uiView.showInfo("Deleted groups: " + Joiner.on((String)", ").join(groupName), null);
        }
        this.updateUserUI();
    }

    private void fetchDataFromService() {
        this.view.setLoadingAnimation(true);
        this.uiView.runInBackground(() -> {
            boolean result = this.model.fetchFromService();
            this.corpusModel.fetchFromService();
            return result;
        }, new FutureCallback<Boolean>(){

            public void onFailure(Throwable ex) {
                GroupController.this.view.setLoadingAnimation(false);
                if (ex instanceof CriticalServiceQueryException) {
                    GroupController.this.uiView.showWarning(ex.getMessage(), null);
                } else if (ex instanceof ServiceQueryException) {
                    GroupController.this.uiView.showInfo(ex.getMessage(), null);
                } else {
                    GroupController.this.uiView.showWarning("Cannot get the group list", ex.getMessage());
                    GroupController.this.view.setGroupList(new LinkedList<Group>());
                }
                GroupController.this.updateUserUI();
            }

            public void onSuccess(Boolean result) {
                GroupController.this.view.setLoadingAnimation(false);
                if (result.booleanValue()) {
                    GroupController.this.view.setGroupList(GroupController.this.model.getGroups());
                } else {
                    GroupController.this.uiView.showWarning("Cannot get the group list", null);
                    GroupController.this.view.setGroupList(new LinkedList<Group>());
                }
                GroupController.this.view.addAvailableCorpusNames((Collection<String>)GroupController.this.corpusModel.getCorpora());
                GroupController.this.updateUserUI();
            }
        });
    }

    @Override
    public void groupUpdated(Group user) {
        this.model.createOrUpdateGroup(user);
    }

    @Override
    public void loadedTab(Object selectedTab) {
        boolean bl = this.viewIsActive = selectedTab == this.view;
        if (this.isLoggedIn && this.viewIsActive) {
            this.fetchDataFromService();
        }
    }

    @Override
    public void loginChanged(boolean isLoggedIn) {
        this.isLoggedIn = isLoggedIn;
        if (this.model.getWebResourceProvider() != null) {
            this.model.getWebResourceProvider().invalidateClient();
        }
        if (this.corpusModel.getClientProvider() != null) {
            this.corpusModel.getClientProvider().invalidateClient();
        }
        if (isLoggedIn && this.viewIsActive) {
            this.fetchDataFromService();
        } else {
            this.clearModel();
        }
    }

    private void updateUserUI() {
        TreeSet<String> names = new TreeSet<String>((Collection<String>)this.model.getGroupNames());
        names.add("*");
    }
}

