/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.admin.model;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.AdministrationApi;
import org.corpus_tools.annis.api.model.Group;
import org.corpus_tools.annis.gui.CaseSensitiveOrder;
import org.corpus_tools.annis.gui.admin.model.ApiClientProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupManagement
implements Serializable {
    private static final long serialVersionUID = 7099096327534717378L;
    private final Logger log = LoggerFactory.getLogger(GroupManagement.class);
    private final Map<String, Group> groups = new TreeMap<String, Group>(CaseSensitiveOrder.INSTANCE);
    private ApiClientProvider apiClientProvider;

    public void clear() {
        this.groups.clear();
    }

    public void createOrUpdateGroup(Group newGroup) {
        if (this.apiClientProvider != null) {
            AdministrationApi api = new AdministrationApi(this.apiClientProvider.getClient());
            try {
                api.putGroup(newGroup.getName(), newGroup);
                this.groups.put(newGroup.getName(), newGroup);
            }
            catch (ApiException ex) {
                this.log.warn("Could not update group", (Throwable)ex);
            }
        }
    }

    public void deleteGroup(String groupName) {
        if (this.apiClientProvider != null) {
            AdministrationApi api = new AdministrationApi(this.apiClientProvider.getClient());
            try {
                api.deleteGroup(groupName);
                this.groups.remove(groupName);
            }
            catch (ApiException ex) {
                this.log.warn("Could not update group", (Throwable)ex);
            }
        }
    }

    public boolean fetchFromService() {
        if (this.apiClientProvider != null) {
            AdministrationApi api = new AdministrationApi(this.apiClientProvider.getClient());
            this.groups.clear();
            try {
                List<Group> list = api.listGroups();
                for (Group g : list) {
                    this.groups.put(g.getName(), g);
                }
                return true;
            }
            catch (ApiException ex) {
                this.log.error("Could not get the list of groups", (Throwable)ex);
            }
        }
        return false;
    }

    public Group getGroup(String groupName) {
        return this.groups.get(groupName);
    }

    public ImmutableSet<String> getGroupNames() {
        return ImmutableSet.copyOf(this.groups.keySet());
    }

    public Collection<Group> getGroups() {
        return this.groups.values();
    }

    public ApiClientProvider getWebResourceProvider() {
        return this.apiClientProvider;
    }

    public void setWebResourceProvider(ApiClientProvider apiClientProvider) {
        this.apiClientProvider = apiClientProvider;
    }
}

