/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.admin.reflinks;

import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.FutureCallback;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.admin.reflinks.MigrationPanel;
import org.corpus_tools.annis.gui.admin.reflinks.QueryStatus;
import org.corpus_tools.annis.gui.admin.reflinks.URLShortenerDefinition;
import org.corpus_tools.annis.gui.components.ExceptionDialog;

final class MigrationCallback
implements FutureCallback<Integer> {
    private final MigrationPanel migrationPanel;
    private final Multimap<QueryStatus, URLShortenerDefinition> failedQueries;

    MigrationCallback(MigrationPanel migrationPanel, Multimap<QueryStatus, URLShortenerDefinition> failedQueries) {
        this.migrationPanel = migrationPanel;
        this.failedQueries = failedQueries;
    }

    public void onSuccess(Integer successfulQueries) {
        this.migrationPanel.progress.setCaption("");
        Collection unknownCorpusQueries = this.failedQueries.get((Object)QueryStatus.UNKNOWN_CORPUS);
        StringBuilder detailedStatus = new StringBuilder();
        if (!unknownCorpusQueries.isEmpty()) {
            TreeMap<String, Integer> unknownCorpusCount = new TreeMap<String, Integer>();
            for (URLShortenerDefinition q : unknownCorpusQueries) {
                for (String c : q.getUnknownCorpora()) {
                    int oldCount = unknownCorpusCount.getOrDefault(c, 0);
                    unknownCorpusCount.put(c, oldCount + 1);
                }
            }
            String unknownCorpusCaption = "Unknown corpus (" + unknownCorpusCount.size() + " unknown corpora and " + unknownCorpusQueries.size() + " queries)";
            detailedStatus.append(unknownCorpusCaption);
            detailedStatus.append("\n");
            detailedStatus.append(Strings.repeat((String)"=", (int)unknownCorpusCaption.length()));
            detailedStatus.append("\n");
            for (Map.Entry e : unknownCorpusCount.entrySet()) {
                detailedStatus.append("Corpus \"" + (String)e.getKey() + "\": " + e.getValue() + " queries");
                detailedStatus.append("\n");
            }
            detailedStatus.append("\n");
        }
        this.printProblematicQueries("UUID already exists", this.failedQueries.get((Object)QueryStatus.UUID_EXISTS), detailedStatus);
        this.printProblematicQueries("Count different", this.failedQueries.get((Object)QueryStatus.COUNT_DIFFERS), detailedStatus);
        this.printProblematicQueries("Match list different", this.failedQueries.get((Object)QueryStatus.MATCHES_DIFFER), detailedStatus);
        this.printProblematicQueries("Timeout", this.failedQueries.get((Object)QueryStatus.TIMEOUT), detailedStatus);
        this.printProblematicQueries("Other server error", this.failedQueries.get((Object)QueryStatus.SERVER_ERROR), detailedStatus);
        this.printProblematicQueries("Empty corpus list", this.failedQueries.get((Object)QueryStatus.EMPTY_CORPUS_LIST), detailedStatus);
        this.printProblematicQueries("FAILED", this.failedQueries.get((Object)QueryStatus.FAILED), detailedStatus);
        String summaryString = "+ Successful: " + successfulQueries + " from " + (successfulQueries + this.failedQueries.size()) + " +";
        detailedStatus.append(Strings.repeat((String)"+", (int)summaryString.length()));
        detailedStatus.append("\n");
        detailedStatus.append(summaryString);
        detailedStatus.append("\n");
        detailedStatus.append(Strings.repeat((String)"+", (int)summaryString.length()));
        detailedStatus.append("\n");
        this.migrationPanel.setMessageAndScrollToEnd(detailedStatus.toString());
        this.migrationPanel.migrateButton.setEnabled(true);
        this.sendMail();
    }

    private void sendMail() {
        String mailAddress = this.migrationPanel.emailText.getValue();
        if (mailAddress != null && !mailAddress.isEmpty()) {
            try {
                MultiPartEmail mail = Helper.createEMailFromConfiguration(this.migrationPanel.ui.getConfig());
                mail.addTo(mailAddress);
                mail.setSubject("ANNIS reference link migration finished");
                String message = this.migrationPanel.getMessages();
                if (message == null || message.isEmpty()) {
                    message = "No further information provided";
                }
                mail.setMsg(message);
                mail.send();
            }
            catch (UnknownHostException | EmailException ex) {
                ExceptionDialog.show(ex, this.migrationPanel.ui);
            }
        }
    }

    public void onFailure(Throwable t) {
        ExceptionDialog.show(t, this.migrationPanel.ui);
        this.migrationPanel.migrateButton.setEnabled(true);
        this.sendMail();
    }

    private void printProblematicQueries(String statusCaption, Collection<URLShortenerDefinition> queries, StringBuilder sb) {
        if (queries != null && !queries.isEmpty()) {
            String captionWithCount = statusCaption + " (sum: " + queries.size() + ")";
            sb.append(captionWithCount);
            sb.append("\n");
            sb.append(Strings.repeat((String)"=", (int)captionWithCount.length()));
            sb.append("\n\n");
            for (URLShortenerDefinition q : queries) {
                if (q.getQuery() != null && q.getQuery().getCorpora() != null) {
                    sb.append("Corpus: \"" + q.getQuery().getCorpora() + "\"");
                    sb.append("\n");
                }
                sb.append("UUID: \"" + q.getUuid() + "\"");
                sb.append("\n");
                if (q.getQuery() != null && q.getQuery().getQuery() != null) {
                    sb.append("Query:");
                    sb.append("\n");
                    sb.append(q.getQuery().getQuery().trim());
                    sb.append("\n");
                }
                if (q.getErrorMsg() != null) {
                    sb.append("Error: " + q.getErrorMsg());
                    sb.append("\n");
                }
                sb.append("-------");
                sb.append("\n");
            }
            sb.append("\n");
        }
    }
}

