/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.admin.reflinks;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.TextField;
import com.vaadin.ui.Upload;
import com.vaadin.ui.VerticalLayout;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.corpus_tools.annis.ApiClient;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.api.SearchApi;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Background;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.admin.reflinks.MigrationCallback;
import org.corpus_tools.annis.gui.admin.reflinks.QueryStatus;
import org.corpus_tools.annis.gui.admin.reflinks.URLShortenerDefinition;
import org.corpus_tools.annis.gui.components.ExceptionDialog;
import org.corpus_tools.annis.gui.query_references.UrlShortener;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.web.util.UriComponentsBuilder;

public class MigrationPanel
extends Panel
implements Upload.Receiver,
Upload.FinishedListener,
Upload.FailedListener {
    private static final int TEXTFIELD_WIDTH = 30;
    static final String QUERY_PREFIX = "Query:";
    static final String UUID_PREFIX = "UUID: \"";
    static final String CORPUS_PREFIX = "Corpus: \"";
    private static final long serialVersionUID = -6893786947746535332L;
    private final TextArea txtMessages = new TextArea();
    private final Upload exportedFileUpload = new Upload();
    final ProgressBar progress = new ProgressBar();
    final TextField emailText = new TextField();
    final Button migrateButton = new Button("Start migration");
    private File urlShortenerFile;
    AnnisUI ui;
    private FormLayout formLayout;

    public MigrationPanel() {
        TextField serviceUrl = new TextField("Legacy ANNIS service URL");
        serviceUrl.setWidth(30.0f, Sizeable.Unit.EM);
        serviceUrl.setPlaceholder("https://example.com/annis3-service");
        TextField serviceUsername = new TextField("Username for legacy ANNIS service");
        serviceUsername.setWidth(30.0f, Sizeable.Unit.EM);
        PasswordField servicePassword = new PasswordField("Password for legacy ANNIS service");
        servicePassword.setWidth(30.0f, Sizeable.Unit.EM);
        CheckBox skipExisting = new CheckBox("Skip existing UUIDs");
        this.migrateButton.addClickListener((Button.ClickListener & Serializable)event -> {
            this.txtMessages.setValue("");
            this.progress.setValue(0.0f);
            this.progress.setCaption("");
            HashMultimap failedQueries = HashMultimap.create();
            String url = serviceUrl.getValue();
            String username = serviceUsername.getValue();
            String password = servicePassword.getValue();
            boolean skip = skipExisting.getValue();
            Background.runWithCallback(() -> this.lambda$null$0(url, username, password, skip, (Multimap)failedQueries), new MigrationCallback(this, (Multimap<QueryStatus, URLShortenerDefinition>)failedQueries));
        });
        this.emailText.setCaption("E-Mail for status reports (optional)");
        this.emailText.setPlaceholder("you@example.com");
        this.emailText.setWidth(30.0f, Sizeable.Unit.EM);
        this.formLayout = new FormLayout(new Component[]{this.exportedFileUpload, serviceUrl, serviceUsername, servicePassword, skipExisting});
    }

    public void attach() {
        List roles;
        super.attach();
        this.ui = (AnnisUI)this.getUI();
        this.setSizeFull();
        VerticalLayout layout = new VerticalLayout(new Component[]{this.formLayout, this.migrateButton, this.progress, this.txtMessages});
        layout.setSizeFull();
        layout.setMargin(true);
        layout.setExpandRatio((Component)this.txtMessages, 1.0f);
        if (this.ui.getConfig().getMailHost() != null) {
            this.formLayout.addComponent((Component)this.emailText);
        }
        this.exportedFileUpload.setCaption("Exported URL shortener entries as CSV file");
        this.exportedFileUpload.setReceiver((Upload.Receiver)this);
        this.exportedFileUpload.addFinishedListener((Upload.FinishedListener)this);
        this.exportedFileUpload.addFailedListener((Upload.FailedListener)this);
        this.progress.setValue(0.0f);
        this.progress.setCaption("");
        this.progress.setWidthFull();
        this.txtMessages.setSizeFull();
        this.txtMessages.setValue("");
        this.txtMessages.setReadOnly(true);
        this.txtMessages.addStyleName("message-output");
        this.migrateButton.setEnabled(false);
        this.migrateButton.setDisableOnClick(true);
        Optional<OidcUser> user = Helper.getUser(this.getUI());
        if (user.isPresent() && (roles = user.get().getClaimAsStringList("https://corpus-tools.org/annis/roles")) != null && roles.contains("admin")) {
            this.setContent((Component)layout);
        }
    }

    void setMessageAndScrollToEnd(String message) {
        this.txtMessages.setValue(message);
        this.txtMessages.setCursorPosition(this.txtMessages.getValue().length() - 1);
    }

    private boolean checkSingleQuery(URLShortenerDefinition q, SearchApi searchApi, UrlShortener urlShortener, OkHttpClient client, HttpUrl searchServiceBaseUrl, Multimap<QueryStatus, URLShortenerDefinition> failedQueries) {
        try {
            this.ui.access(() -> this.progress.setCaption(String.format("testing query %s on corpus %s (UUID %s)", q.getQuery().getQuery().trim(), q.getQuery().getCorpora(), q.getUuid())));
            QueryStatus status = q.test(searchApi, client, searchServiceBaseUrl);
            URI temporary = null;
            if (status != QueryStatus.OK) {
                failedQueries.put((Object)status, (Object)q);
                temporary = UriComponentsBuilder.newInstance().pathSegment(new String[]{"unsupported-query"}).queryParam("url", new Object[]{q.getUri().toASCIIString()}).build().toUri();
            }
            urlShortener.migrate(q.getUri(), temporary, "anonymous", q.getUuid(), q.getCreationTime() == null ? new Date() : q.getCreationTime().toDate());
            if (status == QueryStatus.OK) {
                return true;
            }
        }
        catch (RuntimeException ex) {
            q.setErrorMsg(this.getErrorMessage(ex));
            failedQueries.put((Object)QueryStatus.FAILED, (Object)q);
        }
        return false;
    }

    private String getErrorMessage(Exception ex) {
        if (ex == null) {
            return "";
        }
        if (ex.getMessage() == null) {
            return ex.getClass().toString();
        }
        return ex.getMessage();
    }

    private boolean readUrlShortenerLine(String[] line, boolean skipExisting, Set<String> knownCorpora, SearchApi searchApi, OkHttpClient client, HttpUrl searchServiceBaseUrl, Multimap<QueryStatus, URLShortenerDefinition> failedQueries) {
        block7: {
            if (line.length != 4) {
                return false;
            }
            try {
                URLShortenerDefinition q = URLShortenerDefinition.parse(line[3], line[0], line[2]);
                if (q == null) break block7;
                LinkedList<String> corpusNames = q.getQuery() == null || q.getQuery().getCorpora() == null ? new LinkedList<String>() : new LinkedList<String>(q.getQuery().getCorpora());
                corpusNames.stream().filter(c -> !knownCorpora.contains(c)).forEach(q::addUnknownCorpus);
                if (!q.getUnknownCorpora().isEmpty()) {
                    failedQueries.put((Object)QueryStatus.UNKNOWN_CORPUS, (Object)q);
                    break block7;
                }
                if (corpusNames.isEmpty()) {
                    q.setErrorMsg("Corpus name is empty");
                    failedQueries.put((Object)QueryStatus.FAILED, (Object)q);
                    break block7;
                }
                if (this.ui.getUrlShortener().unshorten(q.getUuid()).isPresent()) {
                    if (skipExisting) {
                        return false;
                    }
                    failedQueries.put((Object)QueryStatus.UUID_EXISTS, (Object)q);
                    break block7;
                }
                return this.checkSingleQuery(q, searchApi, this.ui.getUrlShortener(), client, searchServiceBaseUrl, failedQueries);
            }
            catch (RuntimeException | URISyntaxException ex) {
                URLShortenerDefinition q = new URLShortenerDefinition(null, URLShortenerDefinition.parseUUID(line[0]), null);
                q.setErrorMsg(this.getErrorMessage(ex));
                failedQueries.put((Object)QueryStatus.FAILED, (Object)q);
            }
        }
        return false;
    }

    private Optional<OkHttpClient> createClient(String serviceURL, final String username, final String password) {
        OkHttpClient.Builder client = new OkHttpClient.Builder();
        HttpUrl parsedServiceUrl = HttpUrl.parse((String)serviceURL);
        if (username != null && password != null) {
            client.addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    String credential = Credentials.basic((String)username, (String)password);
                    Request.Builder requestBuilder = chain.request().newBuilder().header("Authorization", credential);
                    return chain.proceed(requestBuilder.build());
                }
            });
            HttpUrl testUrl = parsedServiceUrl.newBuilder().addPathSegment("annis").addPathSegment("admin").addPathSegment("is-authenticated").build();
            Request testRequest = new Request.Builder().url(testUrl).build();
            try {
                String result = client.build().newCall(testRequest).execute().body().string();
                if (!"true".equalsIgnoreCase(result)) {
                    this.ui.access(() -> Notification.show((String)"Authentication failed, please check the provided user name and password", (Notification.Type)Notification.Type.ERROR_MESSAGE));
                    return Optional.empty();
                }
            }
            catch (IOException ex) {
                this.ui.access(() -> ExceptionDialog.show(ex, "Could not connect to legacy service", this.ui));
                return Optional.empty();
            }
        }
        return Optional.of(client.build());
    }

    private int migrateUrlShortener(String serviceURL, String username, String password, boolean skipExisting, Multimap<QueryStatus, URLShortenerDefinition> failedQueries) throws ApiException, IOException {
        int successfulQueries = 0;
        HttpUrl parsedServiceUrl = HttpUrl.parse((String)serviceURL);
        HttpUrl searchServiceBaseUrl = parsedServiceUrl.newBuilder().addPathSegment("annis").addPathSegment("query").addPathSegment("search").build();
        ApiClient apiClient = Helper.getClient(this.ui);
        CorporaApi corporaApi = new CorporaApi(apiClient);
        SearchApi searchApi = new SearchApi(apiClient);
        HashSet<String> knownCorpora = new HashSet<String>(corporaApi.listCorpora());
        Optional<OkHttpClient> client = this.createClient(serviceURL, username, password);
        if (client.isPresent() && this.urlShortenerFile != null && this.urlShortenerFile.isFile()) {
            long numberOfQueries = 0L;
            try (Stream<String> stream = Files.lines(this.urlShortenerFile.toPath(), StandardCharsets.UTF_8);){
                numberOfQueries = stream.count();
            }
            long processedQueries = 0L;
            try (CSVReader csvReader = new CSVReader((Reader)new FileReader(this.urlShortenerFile), '\t');){
                String[] line;
                while ((line = csvReader.readNext()) != null) {
                    if (this.readUrlShortenerLine(line, skipExisting, knownCorpora, searchApi, client.get(), searchServiceBaseUrl, failedQueries)) {
                        ++successfulQueries;
                    }
                    float progressValue = numberOfQueries > 0L && processedQueries < numberOfQueries ? (float)(++processedQueries) / (float)numberOfQueries : 1.0f;
                    this.ui.access(() -> this.progress.setValue(progressValue));
                }
            }
        }
        return successfulQueries;
    }

    public OutputStream receiveUpload(String filename, String mimeType) {
        try {
            this.urlShortenerFile = File.createTempFile(filename, "");
            this.urlShortenerFile.deleteOnExit();
            this.exportedFileUpload.setButtonCaption(filename + " (Click to change)");
            return new FileOutputStream(this.urlShortenerFile);
        }
        catch (IOException ex) {
            ExceptionDialog.show(ex, this.getUI());
            return null;
        }
    }

    public void uploadFinished(Upload.FinishedEvent event) {
        this.migrateButton.setEnabled(true);
    }

    public void uploadFailed(Upload.FailedEvent event) {
        this.setMessageAndScrollToEnd("Could not upload file: " + event.toString());
    }

    public String getMessages() {
        return this.txtMessages.getValue();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    private /* synthetic */ Integer lambda$null$0(String url, String username, String password, boolean skip, Multimap failedQueries) throws Exception {
        try {
            return this.migrateUrlShortener(url, username, password, skip, (Multimap<QueryStatus, URLShortenerDefinition>)failedQueries);
        }
        catch (IOException | ApiException ex) {
            ExceptionDialog.show(ex, "Migrating URL shortener table failed", this.ui);
            return 0;
        }
    }
}

