/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.admin.reflinks;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.SearchApi;
import org.corpus_tools.annis.api.model.CountExtra;
import org.corpus_tools.annis.api.model.CountQuery;
import org.corpus_tools.annis.api.model.FindQuery;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.QueryGenerator;
import org.corpus_tools.annis.gui.admin.reflinks.QueryStatus;
import org.corpus_tools.annis.gui.objects.DisplayedResultQuery;
import org.corpus_tools.annis.gui.objects.Match;
import org.corpus_tools.annis.gui.objects.Query;
import org.corpus_tools.annis.gui.objects.QueryLanguage;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class URLShortenerDefinition {
    private static final Logger log = LoggerFactory.getLogger(URLShortenerDefinition.class);
    private static final int MAX_RETRY = 5;
    private URI uri;
    private DisplayedResultQuery query;
    private UUID uuid;
    private DateTime creationTime;
    private Set<String> unknownCorpora = new LinkedHashSet<String>();
    private String errorMsg;
    private final XmlMapper mapper;

    protected URLShortenerDefinition(URI uri, UUID uuid, DateTime creationTime) {
        this(uri, uuid, creationTime, new DisplayedResultQuery());
    }

    protected URLShortenerDefinition(URI uri, UUID uuid, DateTime creationTime, DisplayedResultQuery query) {
        this.uri = uri;
        this.uuid = uuid;
        this.query = query;
        this.creationTime = creationTime;
        this.errorMsg = null;
        this.mapper = new XmlMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static UUID parseUUID(String uuid) {
        return UUID.fromString(uuid);
    }

    public static DateTime parseCreationTime(String creationTime) {
        DateTimeParser[] parsers = new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSZZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ssZZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZZ").getParser()};
        DateTimeFormatter dateFormatter = new DateTimeFormatterBuilder().append(null, parsers).toFormatter();
        return dateFormatter.parseDateTime(creationTime);
    }

    public static URLShortenerDefinition parse(String url, String uuid, String creationTime) throws URISyntaxException {
        URI parsedURI = new URI(url);
        URLShortenerDefinition result = new URLShortenerDefinition(parsedURI, URLShortenerDefinition.parseUUID(uuid), URLShortenerDefinition.parseCreationTime(creationTime));
        if (parsedURI.getPath().startsWith("/embeddedvis")) {
            for (NameValuePair arg : URLEncodedUtils.parse((URI)parsedURI, (Charset)StandardCharsets.UTF_8)) {
                if (!"embedded_interface".equals(arg.getName())) continue;
                URI interfaceURI = new URI(arg.getValue());
                result.query = URLShortenerDefinition.parseFragment(interfaceURI.getFragment());
                break;
            }
        } else {
            result.query = URLShortenerDefinition.parseFragment(parsedURI.getFragment());
        }
        return result;
    }

    private static DisplayedResultQuery parseFragment(String fragment) {
        Map<String, String> args = Helper.parseFragment(fragment);
        String corporaRaw = args.get("c");
        if (corporaRaw != null) {
            LinkedHashSet<String> corpora = new LinkedHashSet<String>(Arrays.asList(corporaRaw.split("\\s*,\\s*")));
            corpora.remove("");
            return (DisplayedResultQuery)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)QueryGenerator.displayed().left(Integer.parseInt(args.getOrDefault("cl", "0")))).right(Integer.parseInt(args.getOrDefault("cr", "0")))).offset(Integer.parseInt(args.getOrDefault("s", "0")))).limit(Integer.parseInt(args.getOrDefault("l", "0")))).segmentation(args.get("seg"))).baseText(args.get("bt")).query(args.get("q"))).corpora(corpora)).build();
        }
        return null;
    }

    public URLShortenerDefinition rewriteInQuirksMode() {
        DisplayedResultQuery rewrittenQuery = new DisplayedResultQuery(this.query);
        rewrittenQuery.setQueryLanguage(QueryLanguage.AQL_QUIRKS_V3);
        UriComponentsBuilder rewrittenUri = UriComponentsBuilder.fromUri((URI)this.uri);
        if (this.uri.getPath().startsWith("/embeddedvis")) {
            rewrittenUri.queryParam("embedded_interface", new Object[]{rewrittenQuery.toCitationFragment()});
        } else {
            rewrittenUri.fragment(rewrittenQuery.toCitationFragment());
        }
        return new URLShortenerDefinition(rewrittenUri.build().toUri(), this.uuid, this.creationTime, rewrittenQuery);
    }

    public Query getQuery() {
        return this.query;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public URI getUri() {
        return this.uri;
    }

    public DateTime getCreationTime() {
        return this.creationTime;
    }

    public Set<String> getUnknownCorpora() {
        return this.unknownCorpora;
    }

    public void addUnknownCorpus(String corpus) {
        this.unknownCorpora.add(corpus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryStatus testFind(SearchApi searchApi, OkHttpClient client, HttpUrl annisSearchServiceBaseUrl) throws IOException, ApiException {
        File matchesGraphANNISFile = searchApi.find(new FindQuery().query(this.query.getQuery()).corpora(new LinkedList<String>(this.query.getCorpora())).queryLanguage(this.query.getApiQueryLanguage()));
        HttpUrl findUrl = annisSearchServiceBaseUrl.newBuilder().addPathSegment("find").addQueryParameter("q", this.query.getQuery()).addQueryParameter("corpora", Joiner.on((String)",").join(this.query.getCorpora())).build();
        Request legacyFindRequest = new Request.Builder().url(findUrl).addHeader("Accept", "text/plain").build();
        int matchNr = 0;
        try (BufferedReader matchesGraphANNIS = new BufferedReader(new FileReader(matchesGraphANNISFile));
             BufferedReader matchesLegacy = new BufferedReader(client.newCall(legacyFindRequest).execute().body().charStream());){
            while (true) {
                String m2;
                String m1;
                if ((m1 = matchesGraphANNIS.readLine()) != null && (m2 = matchesLegacy.readLine()) != null) {
                    Match m2Parsed;
                    ++matchNr;
                    Match m1Parsed = Match.parseFromString(m1);
                    if (Objects.equals(m1Parsed, m2Parsed = Match.parseFromString(m2))) continue;
                    this.errorMsg = "Match " + matchNr + " (should be)" + System.lineSeparator() + m2 + System.lineSeparator() + "(but was)" + System.lineSeparator() + m1;
                    QueryStatus queryStatus = QueryStatus.MATCHES_DIFFER;
                    return queryStatus;
                    continue;
                }
                break;
            }
        }
        finally {
            Files.delete(matchesGraphANNISFile.toPath());
        }
        return QueryStatus.OK;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getLegacyCount(OkHttpClient client, HttpUrl annisSearchServiceBaseUrl) throws IOException {
        int tries = 0;
        while (tries < 5) {
            HttpUrl countLegacyUrl = annisSearchServiceBaseUrl.newBuilder().addPathSegment("count").addQueryParameter("q", this.query.getQuery()).addQueryParameter("corpora", Joiner.on((String)",").join(this.query.getCorpora())).build();
            try (Response countResponse = client.newCall(new Request.Builder().url(countLegacyUrl).build()).execute();){
                int responseCode = countResponse.code();
                if (responseCode == 200) {
                    String bodyString = countResponse.body().string();
                    CountExtra result = (CountExtra)this.mapper.readValue(bodyString, CountExtra.class);
                    int n = result.getMatchCount();
                    return n;
                }
                if (responseCode == 400) {
                    int n = 0;
                    return n;
                }
                if (responseCode != 504) throw new IOException("Legacy ANNIS service returned error code " + responseCode);
                throw new IOException("Timeout in legacy ANNIS service");
            }
            catch (IOException ex) {
                if (tries >= 4) {
                    throw ex;
                }
                log.warn("Server error when executing query {}", (Object)this.query.getQuery(), (Object)ex);
                ++tries;
            }
        }
        return 0;
    }

    private QueryStatus testQuirksMode(SearchApi searchApi, OkHttpClient client, HttpUrl annisSearchServiceBaseUrl) {
        URLShortenerDefinition quirksQuery = this.rewriteInQuirksMode();
        QueryStatus quirksStatus = quirksQuery.test(searchApi, client, annisSearchServiceBaseUrl);
        if (quirksStatus == QueryStatus.OK) {
            this.query = quirksQuery.query;
            this.uri = quirksQuery.uri;
            this.errorMsg = "Rewrite in quirks mode necessary";
            return QueryStatus.OK;
        }
        this.errorMsg = quirksQuery.getErrorMsg();
        return quirksStatus;
    }

    private QueryStatus testCountAndFind(SearchApi searchApi, OkHttpClient client, HttpUrl annisSearchServiceBaseUrl) throws IOException, ApiException {
        try {
            int countLegacy = this.getLegacyCount(client, annisSearchServiceBaseUrl);
            int countGraphANNIS = searchApi.count(new CountQuery().query(this.query.getQuery()).queryLanguage(this.query.getApiQueryLanguage()).corpora(new LinkedList<String>(this.query.getCorpora()))).getMatchCount();
            if (countGraphANNIS != countLegacy) {
                this.errorMsg = "should have been " + countLegacy + " but was " + countGraphANNIS;
                return QueryStatus.COUNT_DIFFERS;
            }
            if (countGraphANNIS == 0) {
                return QueryStatus.OK;
            }
            return this.testFind(searchApi, client, annisSearchServiceBaseUrl);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 400 && this.query.getQueryLanguage() == QueryLanguage.AQL) {
                this.errorMsg = ex.toString();
                return QueryStatus.FAILED;
            }
            throw ex;
        }
    }

    public QueryStatus test(SearchApi searchApi, OkHttpClient client, HttpUrl annisSearchServiceBaseUrl) {
        if (this.query.getCorpora().isEmpty()) {
            this.errorMsg = "Empty corpus list";
            return QueryStatus.EMPTY_CORPUS_LIST;
        }
        try {
            QueryStatus status = this.testCountAndFind(searchApi, client, annisSearchServiceBaseUrl);
            if (status != QueryStatus.OK && this.query.getQueryLanguage() == QueryLanguage.AQL) {
                status = this.testQuirksMode(searchApi, client, annisSearchServiceBaseUrl);
            }
            return status;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 408 || ex.getCode() == 504) {
                this.errorMsg = "Timeout in graphANNIS";
                return QueryStatus.TIMEOUT;
            }
            this.errorMsg = ex.toString();
            return QueryStatus.SERVER_ERROR;
        }
        catch (IOException ex) {
            this.errorMsg = ex.toString();
            return QueryStatus.SERVER_ERROR;
        }
    }
}

