/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.components;

import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.CommonUI;
import org.corpus_tools.annis.gui.Helper;

public class ExceptionDialog
extends Window
implements Button.ClickListener {
    private static final long serialVersionUID = -9195384309481177718L;
    private Panel detailsPanel;
    private Label lblStacktrace;
    private Button btDetails;
    private Button btClose;
    private Button btReportBug;
    private Throwable cause;
    private VerticalLayout layout;
    private HorizontalLayout actionsLayout;

    public static void show(Throwable ex, String caption, UI ui) {
        if (!(ui instanceof CommonUI) || !((CommonUI)ui).handleCommonError(ex, null)) {
            ExceptionDialog dlg = new ExceptionDialog(ex, caption);
            dlg.setClosable(true);
            dlg.setModal(true);
            dlg.setResizable(true);
            dlg.setWidth("500px");
            dlg.setHeight("-1");
            ui.addWindow((Window)dlg);
            dlg.center();
        }
    }

    public static void show(Throwable ex, UI ui) {
        ExceptionDialog.show(ex, null, ui);
    }

    private ExceptionDialog(Throwable ex, String caption) {
        String message;
        this.cause = ex;
        this.layout = new VerticalLayout();
        this.setContent((Component)this.layout);
        this.layout.setWidth("100%");
        this.layout.setHeight("-1");
        if (caption == null) {
            this.setCaption("Unexpected error");
        } else {
            this.setCaption(caption);
        }
        Label lblInfo = new Label("An error occured.<br />The error message was:", ContentMode.HTML);
        lblInfo.setHeight("-1px");
        lblInfo.setWidth("100%");
        this.layout.addComponent((Component)lblInfo);
        lblInfo.addStyleName("exception-message-caption");
        String string = message = ex != null ? ex.getMessage() : null;
        if (message == null || message.isEmpty()) {
            message = "<no message>";
        }
        Label lblMessage = new Label(message);
        lblMessage.addStyleName("exception-message-content");
        lblMessage.setHeight("-1px");
        lblMessage.setWidth("100%");
        this.layout.addComponent((Component)lblMessage);
        this.actionsLayout = new HorizontalLayout();
        this.actionsLayout.addStyleName("exception-dlg-details");
        this.actionsLayout.setWidth("100%");
        this.actionsLayout.setHeight("-1px");
        this.layout.addComponent((Component)this.actionsLayout);
        this.btDetails = new Button("Show Details", (Button.ClickListener)this);
        this.btDetails.setStyleName("link");
        this.actionsLayout.addComponent((Component)this.btDetails);
        this.btReportBug = new Button("Report Problem", (Button.ClickListener)this);
        this.btReportBug.setStyleName("link");
        this.btReportBug.setVisible(false);
        this.btReportBug.setIcon((Resource)VaadinIcons.ENVELOPE_O);
        UI ui = UI.getCurrent();
        if (ui instanceof AnnisUI) {
            this.btReportBug.setVisible(((AnnisUI)ui).canReportBugs());
        }
        this.actionsLayout.addComponent((Component)this.btReportBug);
        this.actionsLayout.setComponentAlignment((Component)this.btDetails, Alignment.TOP_LEFT);
        this.actionsLayout.setComponentAlignment((Component)this.btReportBug, Alignment.TOP_RIGHT);
        this.lblStacktrace = new Label(Helper.convertExceptionToMessage(ex), ContentMode.PREFORMATTED);
        this.detailsPanel = new Panel((Component)this.lblStacktrace);
        this.detailsPanel.setWidth("100%");
        this.detailsPanel.setHeight("300px");
        this.detailsPanel.setVisible(false);
        this.lblStacktrace.setSizeUndefined();
        this.lblStacktrace.setVisible(true);
        this.layout.addComponent((Component)this.detailsPanel);
        this.btClose = new Button("OK", (Button.ClickListener)this);
        this.layout.addComponent((Component)this.btClose);
        this.layout.setComponentAlignment((Component)this.btClose, Alignment.BOTTOM_CENTER);
        this.layout.setExpandRatio((Component)this.detailsPanel, 0.0f);
        this.layout.setExpandRatio((Component)this.actionsLayout, 1.0f);
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getButton() == this.btDetails) {
            if (this.detailsPanel.isVisible()) {
                this.detailsPanel.setVisible(false);
                this.btDetails.setCaption("Show Details");
                this.layout.setExpandRatio((Component)this.detailsPanel, 0.0f);
                this.layout.setExpandRatio((Component)this.actionsLayout, 1.0f);
            } else {
                this.detailsPanel.setVisible(true);
                this.btDetails.setCaption("Hide Details");
                this.layout.setExpandRatio((Component)this.detailsPanel, 1.0f);
                this.layout.setExpandRatio((Component)this.actionsLayout, 0.0f);
            }
        } else if (event.getButton() == this.btClose) {
            this.close();
        } else if (event.getButton() == this.btReportBug) {
            this.close();
            UI ui = UI.getCurrent();
            if (ui instanceof AnnisUI) {
                ((AnnisUI)ui).reportBug(this.cause);
            }
        }
    }
}

