/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.components;

import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.OptionGroup;
import java.io.Serializable;
import java.util.List;
import org.corpus_tools.annis.api.model.FrequencyTableRow;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.InstanceConfig;
import org.corpus_tools.annis.gui.components.FrequencyWhiteboard;
import org.corpus_tools.annis.gui.frequency.FrequencyResultPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrequencyChart
extends VerticalLayout {
    private static final long serialVersionUID = -3245406352504285685L;
    public static final Logger log = LoggerFactory.getLogger(FrequencyChart.class);
    private FrequencyWhiteboard whiteboard;
    private final OptionGroup options;
    private List<FrequencyTableRow> lastTable;

    public FrequencyChart(FrequencyResultPanel freqPanel) {
        this.setSizeFull();
        this.options = new OptionGroup();
        this.options.setSizeUndefined();
        this.options.addItem((Object)FrequencyWhiteboard.Scale.LINEAR);
        this.options.addItem((Object)FrequencyWhiteboard.Scale.LOG10);
        this.options.setItemCaption((Object)FrequencyWhiteboard.Scale.LINEAR, "linear scale");
        this.options.setItemCaption((Object)FrequencyWhiteboard.Scale.LOG10, "log<sub>10</sub> scale");
        this.options.setHtmlContentAllowed(true);
        this.options.setImmediate(true);
        this.options.setValue((Object)FrequencyWhiteboard.Scale.LINEAR);
        this.options.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            if (this.lastTable != null) {
                this.setFrequencyData(this.lastTable);
            }
        });
        this.addComponent((Component)this.options);
        InnerPanel panel = new InnerPanel(freqPanel);
        this.addComponent((Component)panel);
        this.setExpandRatio((Component)panel, 1.0f);
    }

    public void setFrequencyData(List<FrequencyTableRow> table) {
        InstanceConfig cfg;
        String font = "sans-serif";
        float fontSize = 7.0f;
        UI ui = UI.getCurrent();
        if (ui instanceof AnnisUI && (cfg = ((AnnisUI)ui).getInstanceConfig()) != null && cfg.getFont() != null) {
            if (cfg.getFrequencyFont() != null) {
                font = cfg.getFrequencyFont().getName();
                String size = cfg.getFrequencyFont().getSize();
                if (size != null && size.trim().endsWith("px")) {
                    fontSize = Float.parseFloat(size.replace("px", "").trim());
                    fontSize /= 1.3f;
                } else {
                    log.warn("No valid font size (must in in \"px\" unit) given for frequency font configuration. The value is {}", (Object)Float.valueOf(fontSize));
                }
            } else if (cfg.getFont() != null) {
                font = cfg.getFont().getName();
                String size = cfg.getFont().getSize();
                if (size != null && size.trim().endsWith("px")) {
                    fontSize = Float.parseFloat(size.replace("px", "").trim());
                    fontSize /= 1.3f;
                }
            }
        }
        this.lastTable = table;
        this.whiteboard.setFrequencyData(table, (FrequencyWhiteboard.Scale)((Object)this.options.getValue()), font, fontSize);
    }

    private class InnerPanel
    extends Panel {
        private static final long serialVersionUID = 1697906086130393179L;

        public InnerPanel(FrequencyResultPanel freqPanel) {
            this.setSizeFull();
            FrequencyChart.this.whiteboard = new FrequencyWhiteboard(freqPanel);
            FrequencyChart.this.whiteboard.addStyleName("corpus-font-force");
            this.setContent((Component)FrequencyChart.this.whiteboard);
        }
    }
}

