/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.components;

import com.vaadin.annotations.JavaScript;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.AbstractJavaScriptComponent;
import com.vaadin.ui.JavaScriptFunction;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.api.model.FrequencyTableRow;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.components.OnLoadCallbackExtension;
import org.corpus_tools.annis.gui.frequency.FrequencyResultPanel;

@JavaScript(value={"flotr2.js", "vaadin://jquery.js", "frequencychart.js"})
public class FrequencyWhiteboard
extends AbstractJavaScriptComponent
implements OnLoadCallbackExtension.Callback {
    private static final long serialVersionUID = -3666118907756684861L;
    public static final float PIXEL_PER_VALUE = 45.0f;
    public static final float ADDTIONAL_PIXEL_WIDTH = 100.0f;
    private List<String> labels;
    private List<Integer> values;
    private Scale lastScale;
    private String lastFont;
    private float lastFontSize = 10.0f;

    public FrequencyWhiteboard(FrequencyResultPanel freqPanel) {
        this.setHeight("100%");
        this.setWidth("200px");
        this.addStyleName("frequency-chart");
        this.addFunction("selectRow", (JavaScriptFunction & Serializable)arguments -> freqPanel.selectRow((int)arguments.getNumber(0)));
        OnLoadCallbackExtension ext = new OnLoadCallbackExtension(this);
        ext.extend((AbstractClientConnector)this);
    }

    public void beforeClientResponse(boolean initial) {
        super.beforeClientResponse(initial);
        if (this.labels != null && this.values != null && this.lastScale != null && this.lastFont != null) {
            this.callFunction("showData", new Object[]{Helper.encodeGeneric(this.labels), Helper.encodeGeneric(this.values), this.lastScale.desc, this.lastFont, Float.valueOf(this.lastFontSize)});
        }
    }

    @Override
    public boolean onCompononentLoaded(AbstractClientConnector source) {
        if (this.labels != null && this.values != null && this.lastScale != null && this.lastFont != null) {
            this.callFunction("showData", new Object[]{Helper.encodeGeneric(this.labels), Helper.encodeGeneric(this.values), this.lastScale.desc, this.lastFont, Float.valueOf(this.lastFontSize)});
        }
        return true;
    }

    public void setFrequencyData(List<FrequencyTableRow> table, Scale scale, String font, float fontSize) {
        this.labels = new LinkedList<String>();
        this.values = new LinkedList<Integer>();
        for (FrequencyTableRow e : table) {
            this.labels.add(StringUtils.join(e.getValues(), (String)"/") + " (" + e.getCount() + ")");
            this.values.add(e.getCount());
        }
        this.setWidth(100.0f + 45.0f * (float)this.values.size(), Sizeable.Unit.PIXELS);
        this.lastScale = scale;
        this.lastFont = font;
        this.lastFontSize = fontSize;
    }

    public static enum Scale {
        LINEAR("linear"),
        LOG10("logarithmic");

        public final String desc;

        private Scale(String desc) {
            this.desc = desc;
        }
    }
}

