/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.components;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import com.vaadin.v7.data.Buffered;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.ui.Field;
import java.util.Collection;
import org.apache.commons.lang3.Validate;

public class HelpButton<T>
extends CustomComponent
implements Field<T>,
Button.ClickListener {
    private static final long serialVersionUID = 905588134324200618L;
    private Field<T> field;

    public HelpButton(Field<T> field) {
        Validate.notNull(field);
        this.field = field;
        CssLayout layout = new CssLayout();
        this.setCompositionRoot((Component)layout);
        Button btHelp = new Button("");
        btHelp.setIcon((Resource)FontAwesome.QUESTION);
        btHelp.addStyleName("borderless");
        btHelp.addStyleName("helpbutton");
        btHelp.addClickListener((Button.ClickListener)this);
        this.setCaption(field.getCaption());
        field.setCaption(null);
        layout.addComponent(field);
        layout.addComponent((Component)btHelp);
    }

    @Deprecated
    public void addListener(Property.ValueChangeListener listener) {
        this.field.addListener(listener);
    }

    public void addValidator(Validator validator) {
        this.field.addValidator(validator);
    }

    public void addValueChangeListener(Property.ValueChangeListener listener) {
        this.field.addValueChangeListener(listener);
    }

    public void buttonClick(Button.ClickEvent event) {
        String caption = "Help";
        if (this.getCaption() != null && !this.getCaption().isEmpty()) {
            caption = "Help for \"" + this.getCaption();
        }
        caption = caption + "<br/><br/>(Click here to close)";
        Notification notify = new Notification(caption, Notification.Type.HUMANIZED_MESSAGE);
        notify.setHtmlContentAllowed(true);
        notify.setDescription(this.field.getDescription());
        notify.setDelayMsec(-1);
        notify.show(UI.getCurrent().getPage());
    }

    public void clear() {
        this.field.clear();
    }

    public void commit() throws Buffered.SourceException, Validator.InvalidValueException {
        this.field.commit();
    }

    public void discard() throws Buffered.SourceException {
        this.field.discard();
    }

    public void focus() {
        this.field.focus();
    }

    public Property getPropertyDataSource() {
        return this.field.getPropertyDataSource();
    }

    public String getRequiredError() {
        return this.field.getRequiredError();
    }

    public int getTabIndex() {
        return this.field.getTabIndex();
    }

    public Class<? extends T> getType() {
        return this.field.getType();
    }

    public Collection<Validator> getValidators() {
        return this.field.getValidators();
    }

    public T getValue() {
        return (T)this.field.getValue();
    }

    public boolean isBuffered() {
        return this.field.isBuffered();
    }

    public boolean isEmpty() {
        return this.field.isEmpty();
    }

    public boolean isInvalidAllowed() {
        return this.field.isInvalidAllowed();
    }

    public boolean isInvalidCommitted() {
        return this.field.isInvalidCommitted();
    }

    public boolean isModified() {
        return this.field.isModified();
    }

    public boolean isReadOnly() {
        return this.field.isReadOnly();
    }

    public boolean isRequired() {
        return this.field.isRequired();
    }

    public boolean isValid() {
        return this.field.isValid();
    }

    public void removeAllValidators() {
        this.field.removeAllValidators();
    }

    @Deprecated
    public void removeListener(Property.ValueChangeListener listener) {
        this.field.removeListener(listener);
    }

    public void removeValidator(Validator validator) {
        this.field.removeValidator(validator);
    }

    public void removeValueChangeListener(Property.ValueChangeListener listener) {
        this.field.removeValueChangeListener(listener);
    }

    public void setBuffered(boolean buffered) {
        this.field.setBuffered(buffered);
    }

    public void setInvalidAllowed(boolean invalidValueAllowed) throws UnsupportedOperationException {
        this.field.setInvalidAllowed(invalidValueAllowed);
    }

    public void setInvalidCommitted(boolean isCommitted) {
        this.field.setInvalidCommitted(isCommitted);
    }

    public void setPropertyDataSource(Property newDataSource) {
        this.field.setPropertyDataSource(newDataSource);
    }

    public void setReadOnly(boolean readOnly) {
        this.field.setReadOnly(readOnly);
    }

    public void setRequired(boolean required) {
        this.field.setRequired(required);
    }

    public void setRequiredError(String requiredMessage) {
        this.field.setRequiredError(requiredMessage);
    }

    public void setTabIndex(int tabIndex) {
        this.field.setTabIndex(tabIndex);
    }

    public void setValue(T newValue) throws Property.ReadOnlyException {
        this.field.setValue(newValue);
    }

    public void validate() throws Validator.InvalidValueException {
        this.field.validate();
    }

    public void valueChange(Property.ValueChangeEvent event) {
        this.field.valueChange(event);
    }
}

