/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.components;

import com.vaadin.annotations.JavaScript;
import com.vaadin.server.AbstractJavaScriptExtension;
import com.vaadin.server.ClientConnector;
import com.vaadin.ui.JavaScriptFunction;
import com.vaadin.ui.UI;
import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.Validate;

@JavaScript(value={"vaadin://jquery.js", "html2canvas.js", "screenshotmaker.js"})
public class ScreenshotMaker
extends AbstractJavaScriptExtension {
    private static final long serialVersionUID = 5600268726536841528L;

    public ScreenshotMaker(ScreenshotCallback callback) {
        Validate.notNull((Object)callback);
        this.addFunction("finishedScreenshot", (JavaScriptFunction & Serializable)arguments -> this.parseAndCallback(arguments.getString(0), callback));
    }

    protected Class<? extends ClientConnector> getSupportedParentType() {
        return UI.class;
    }

    public void makeScreenshot() {
        this.callFunction("makeScreenshot", new Object[0]);
    }

    private void parseAndCallback(String rawImage, ScreenshotCallback callback) {
        if (callback == null) {
            return;
        }
        String[] typeInfoAndData = rawImage.split(",");
        String[] mimeAndEncoding = typeInfoAndData[0].replaceFirst("data:", "").split(";");
        if (typeInfoAndData.length == 2 && mimeAndEncoding.length == 2 && "base64".equalsIgnoreCase(mimeAndEncoding[1])) {
            byte[] result = Base64.decodeBase64((String)typeInfoAndData[1]);
            callback.screenshotReceived(result, mimeAndEncoding[0]);
        }
    }

    public static interface ScreenshotCallback {
        public void screenshotReceived(byte[] var1, String var2);
    }
}

