/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.components;

import com.vaadin.annotations.JavaScript;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.AbstractJavaScriptExtension;
import com.vaadin.ui.JavaScriptFunction;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.corpus_tools.annis.gui.CommonUI;

@JavaScript(value={"js.cookie-2.0.3.min.js", "settingsstorage.js"})
public class SettingsStorage
extends AbstractJavaScriptExtension {
    private static final long serialVersionUID = -6054834521339901439L;
    private final ConcurrentMap<String, String> storage = new ConcurrentHashMap<String, String>();
    private final List<LoadedListener> loadedListeners = new LinkedList<LoadedListener>();
    private final CommonUI ui;

    public SettingsStorage(CommonUI ui) {
        this.ui = ui;
        if (ui != null) {
            this.extend((AbstractClientConnector)ui);
        }
        this.addFunction("loadFromClient", (JavaScriptFunction & Serializable)args -> {
            JsonObject values = (JsonObject)args.get(0);
            for (String key : values.keys()) {
                JsonValue v = values.get(key);
                if (v.getType() == JsonType.STRING) {
                    this.storage.put(key, v.asString());
                    continue;
                }
                if (v.getType() != JsonType.OBJECT) continue;
                this.storage.put(key, v.toJson());
            }
            for (LoadedListener l : this.loadedListeners) {
                l.onSettingsLoaded(this);
            }
        });
    }

    public void addedLoadedListener(LoadedListener listener) {
        this.loadedListeners.add(listener);
    }

    public String get(String name) {
        return (String)this.storage.get(name);
    }

    public void set(String name, String value, int lifetimeInDays) {
        this.storage.put(name, value);
        this.callFunction("set", new Object[]{name, value, this.ui.getServletContext().getContextPath(), lifetimeInDays});
    }

    public static interface LoadedListener {
        public void onSettingsLoaded(SettingsStorage var1);
    }
}

