/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.components;

import com.vaadin.annotations.JavaScript;
import com.vaadin.ui.AbstractJavaScriptComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.JavaScriptFunction;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.net.URI;
import org.corpus_tools.annis.gui.components.IframeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefulBrowserComponent
extends VerticalLayout {
    private static final long serialVersionUID = -7089777149165739882L;
    private static final Logger log = LoggerFactory.getLogger(StatefulBrowserComponent.class);
    private final IFrameComponent iframe = new IFrameComponent();

    public StatefulBrowserComponent(URI externalURI) {
        this.iframe.setSizeFull();
        this.addComponent((Component)this.iframe);
        this.setExpandRatio((Component)this.iframe, 1.0f);
        this.setSource(externalURI);
    }

    private void setSource(URI externalURI) {
        this.iframe.getState().setSource(externalURI.toASCIIString());
    }

    @JavaScript(value={"vaadin://jquery.js", "statefulbrowsercomponent.js"})
    private class IFrameComponent
    extends AbstractJavaScriptComponent {
        private static final long serialVersionUID = -4822333489764804388L;

        public IFrameComponent() {
            this.addFunction("urlChanged", (JavaScriptFunction & Serializable)arguments -> {
                this.getState().setSource(arguments.get(0).asString());
                this.getState().setLastScrollPos(0);
            });
            this.addFunction("scrolled", (JavaScriptFunction & Serializable)arguments -> this.getState().setLastScrollPos((int)arguments.getNumber(0)));
        }

        public final IframeState getState() {
            return (IframeState)super.getState();
        }
    }
}

