/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.components.medialement;

import com.vaadin.annotations.JavaScript;
import com.vaadin.annotations.StyleSheet;
import com.vaadin.ui.AbstractJavaScriptComponent;
import com.vaadin.ui.JavaScriptFunction;
import com.vaadin.ui.UI;
import elemental.json.JsonArray;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.corpus_tools.annis.gui.components.medialement.MediaElement;
import org.corpus_tools.annis.gui.components.medialement.MediaState;
import org.corpus_tools.annis.gui.media.MediaPlayer;
import org.corpus_tools.annis.gui.media.MimeTypeErrorListener;
import org.corpus_tools.annis.gui.visualizers.LoadableVisualizer;
import org.json.JSONException;

@JavaScript(value={"vaadin://jquery.js", "vaadin://mediaelement/mediaelement-and-player.js", "mediaelement_connector.js"})
@StyleSheet(value={"vaadin://mediaelement/mediaelementplayer.min.css"})
public class MediaElementPlayer
extends AbstractJavaScriptComponent
implements MediaPlayer,
LoadableVisualizer {
    private static final long serialVersionUID = 594724489035276610L;
    private Set<LoadableVisualizer.Callback> callbacks = new HashSet<LoadableVisualizer.Callback>();
    private boolean wasLoaded = false;

    public MediaElementPlayer(MediaElement elementType, String resourceURL, String mimeType) {
        this.getState().setElementType(elementType);
        this.getState().setResourceURL(resourceURL);
        this.getState().setMimeType(mimeType);
        MediaElementPlayer finalThis = this;
        this.addFunction("wasLoaded", (JavaScriptFunction & Serializable)arguments -> {
            this.wasLoaded = true;
            for (LoadableVisualizer.Callback c : this.callbacks) {
                c.visualizerLoaded(finalThis);
            }
        });
        this.addFunction("cannotPlay", new CannotPlayFunction());
    }

    @Override
    public void addOnLoadCallBack(LoadableVisualizer.Callback callback) {
        this.callbacks.add(callback);
    }

    @Override
    public void clearCallbacks() {
        this.callbacks.clear();
    }

    public final MediaState getState() {
        return (MediaState)super.getState();
    }

    @Override
    public boolean isLoaded() {
        return this.wasLoaded;
    }

    @Override
    public void pause() {
        this.callFunction("pause", new Object[0]);
    }

    @Override
    public void play(double start) {
        start = Math.floor(start);
        this.callFunction("play", new Object[]{start});
    }

    @Override
    public void play(double start, double end) {
        start = Math.floor(start);
        end = Math.ceil(end);
        this.callFunction("playRange", new Object[]{start, end});
    }

    private static class CannotPlayFunction
    implements JavaScriptFunction {
        private static final long serialVersionUID = -8343373228150445600L;

        private CannotPlayFunction() {
        }

        public void call(JsonArray arguments) throws JSONException {
            if (UI.getCurrent() instanceof MimeTypeErrorListener) {
                ((MimeTypeErrorListener)UI.getCurrent()).notifyCannotPlayMimeType(arguments.getString(0));
            }
        }
    }
}

