/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.controller;

import com.google.common.eventbus.EventBus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.model.CorpusConfiguration;
import org.corpus_tools.annis.api.model.QueryLanguage;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.ExportPanel;
import org.corpus_tools.annis.gui.exporter.ExporterPlugin;
import org.corpus_tools.annis.gui.objects.ExportQuery;

public class ExportBackgroundJob
implements Callable<File> {
    private final EventBus eventBus;
    private final ExportPanel panel;
    private final ExportQuery query;
    private final AnnisUI ui;
    private final ExporterPlugin exporter;
    private Exception exportError;

    public ExportBackgroundJob(ExportQuery query, ExporterPlugin exporter, AnnisUI ui, EventBus eventBus, ExportPanel panel) {
        this.query = query;
        this.eventBus = eventBus;
        this.panel = panel;
        this.ui = ui;
        this.exporter = exporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File call() throws Exception {
        File currentTmpFile = File.createTempFile("annis-export", "." + this.exporter.getFileEnding());
        currentTmpFile.deleteOnExit();
        LinkedHashMap<String, CorpusConfiguration> corpusConfigs = new LinkedHashMap<String, CorpusConfiguration>();
        for (String c : this.query.getCorpora()) {
            corpusConfigs.put(c, this.ui.getCorpusConfigWithCache(c));
        }
        try (OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(currentTmpFile), "UTF-8");){
            int leftCtx = this.exporter.needsContext() ? this.query.getLeftContext() : 0;
            int rightCtx = this.exporter.needsContext() ? this.query.getRightContext() : 0;
            QueryLanguage ql = this.query.getApiQueryLanguage();
            this.exportError = this.exporter.convertText(this.query.getQuery(), ql, leftCtx, rightCtx, this.query.getCorpora(), this.query.getAnnotationKeys(), this.query.getParameters(), this.query.getAlignmc(), outWriter, this.eventBus, corpusConfigs, this.ui);
        }
        finally {
            this.ui.access(() -> {
                if (this.panel != null) {
                    this.panel.showResult(currentTmpFile, this.exportError);
                }
                if (this.exportError instanceof ApiException) {
                    this.ui.getQueryController().reportServiceException((ApiException)this.exportError, true);
                }
            });
        }
        return currentTmpFile;
    }
}

