/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.controller;

import com.vaadin.ui.UI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.tuple.Pair;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.SearchApi;
import org.corpus_tools.annis.api.model.FrequencyQuery;
import org.corpus_tools.annis.api.model.FrequencyQueryDefinition;
import org.corpus_tools.annis.api.model.FrequencyTableRow;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.QueryController;
import org.corpus_tools.annis.gui.frequency.FrequencyQueryPanel;
import org.corpus_tools.annis.gui.objects.FrequencyTableEntry;
import org.corpus_tools.salt.util.SaltUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrequencyBackgroundJob
implements Callable<List<FrequencyTableRow>> {
    private static final Logger log = LoggerFactory.getLogger(FrequencyBackgroundJob.class);
    private final UI ui;
    private final QueryController queryController;
    private final org.corpus_tools.annis.gui.objects.FrequencyQuery query;
    private final FrequencyQueryPanel panel;

    public FrequencyBackgroundJob(UI ui, QueryController queryController, org.corpus_tools.annis.gui.objects.FrequencyQuery query, FrequencyQueryPanel panel) {
        this.ui = ui;
        this.queryController = queryController;
        this.query = query;
        this.panel = panel;
    }

    @Override
    public List<FrequencyTableRow> call() throws Exception {
        List<FrequencyTableRow> t = this.loadBeans();
        this.ui.access(() -> this.panel.showResult(t, this.query));
        return t;
    }

    private List<FrequencyTableRow> loadBeans() {
        List<FrequencyTableRow> result = new ArrayList<FrequencyTableRow>();
        SearchApi api = new SearchApi(Helper.getClient(this.ui));
        try {
            FrequencyQuery frequencyQuery = new FrequencyQuery();
            frequencyQuery.setQuery(this.query.getQuery());
            frequencyQuery.setCorpora(new LinkedList<String>(this.query.getCorpora()));
            frequencyQuery.setQueryLanguage(this.query.getApiQueryLanguage());
            LinkedList<FrequencyQueryDefinition> freqDef = new LinkedList<FrequencyQueryDefinition>();
            for (FrequencyTableEntry e : this.query.getFrequencyDefinition()) {
                FrequencyQueryDefinition d = new FrequencyQueryDefinition();
                d.setNodeRef(e.getReferencedNode());
                switch (e.getType()) {
                    case span: {
                        d.setNs("annis");
                        d.setName("tok");
                        break;
                    }
                    case annotation: {
                        Pair annoKey = SaltUtil.splitQName((String)e.getKey());
                        if (annoKey.getLeft() != null) {
                            d.setNs((String)annoKey.getLeft());
                        }
                        d.setNs((String)annoKey.getLeft());
                        d.setName((String)annoKey.getRight());
                    }
                }
                freqDef.add(d);
            }
            frequencyQuery.setDefinition(freqDef);
            result = api.frequency(frequencyQuery);
        }
        catch (ApiException ex) {
            this.ui.access(() -> this.queryController.reportServiceException(ex, true));
        }
        return result;
    }
}

