/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.controlpanel;

import com.vaadin.ui.Component;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.VerticalLayout;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.HelpPanel;
import org.corpus_tools.annis.gui.controlpanel.CorpusListPanel;
import org.corpus_tools.annis.gui.controlpanel.QueryPanel;
import org.corpus_tools.annis.gui.controlpanel.SearchOptionsPanel;

public class ControlPanel
extends VerticalLayout {
    private static final long serialVersionUID = -2220211539424865671L;
    private final AnnisUI ui;
    private final QueryPanel queryPanel;
    private final CorpusListPanel corpusList;
    private final SearchOptionsPanel searchOptions;
    private final TabSheet optionsTab;

    public ControlPanel(AnnisUI ui, HelpPanel helpPanel) {
        this.ui = ui;
        this.setSizeFull();
        this.setMargin(true);
        this.setStyleName("borderless");
        this.optionsTab = new TabSheet();
        this.optionsTab.setHeight("100%");
        this.optionsTab.setWidth("100%");
        this.optionsTab.addStyleName("framed");
        this.queryPanel = new QueryPanel(ui);
        this.corpusList = new CorpusListPanel(ui, helpPanel.getExamples());
        this.searchOptions = new SearchOptionsPanel();
        this.optionsTab.addTab((Component)this.corpusList, "Corpus List", null);
        this.optionsTab.addTab((Component)this.searchOptions, "Search Options", null);
        this.addComponent((Component)this.queryPanel);
        this.addComponent((Component)this.optionsTab);
        this.queryPanel.setHeightUndefined();
        this.queryPanel.setWidthFull();
        this.setExpandRatio((Component)this.optionsTab, 1.0f);
    }

    public CorpusListPanel getCorpusList() {
        return this.corpusList;
    }

    public QueryPanel getQueryPanel() {
        return this.queryPanel;
    }

    public SearchOptionsPanel getSearchOptions() {
        return this.searchOptions;
    }
}

