/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.controlpanel;

import com.google.common.collect.ImmutableList;
import com.vaadin.data.Binder;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.api.model.AnnotationComponentType;
import org.corpus_tools.annis.api.model.Component;
import org.corpus_tools.annis.api.model.CorpusConfiguration;
import org.corpus_tools.annis.api.model.FindQuery;
import org.corpus_tools.annis.api.model.QueryLanguage;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Background;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.objects.CorpusConfigMap;
import org.corpus_tools.annis.gui.objects.QueryUIState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchOptionsPanel
extends FormLayout {
    private static final long serialVersionUID = 7878445496945702778L;
    private static final String NULL_SEGMENTATION_VALUE = "tokens (default)";
    private static final String DEFAULT_CONFIG = "default-config";
    private static final Logger log = LoggerFactory.getLogger(SearchOptionsPanel.class);
    private static final List<Integer> PREDEFINED_PAGE_SIZES = ImmutableList.of((Object)1, (Object)2, (Object)5, (Object)10, (Object)20, (Object)25);
    public static final List<Integer> PREDEFINED_CONTEXTS = ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)5, (Object)10, (Object)20);
    private final ComboBox<Integer> cbLeftContext;
    private final ComboBox<Integer> cbRightContext;
    private final ComboBox<Integer> cbResultsPerPage;
    private final ComboBox<String> cbSegmentation;
    private final ComboBox<FindQuery.OrderEnum> cbOrder;
    private final ComboBox<QueryLanguage> cbQueryLanguage;
    private final ProgressBar pbLoadConfig;
    private final AtomicInteger maxContext = new AtomicInteger(Integer.MAX_VALUE);
    private boolean updateStateFromConfig = true;
    private QueryUIState state;

    private static List<String> getSegmentationNamesFromService(Collection<String> corpora, UI ui) {
        ArrayList<String> segNames = new ArrayList<String>();
        CorporaApi corporaApi = new CorporaApi(Helper.getClient(ui));
        for (String corpus : corpora) {
            try {
                for (Component c : corporaApi.components(corpus, AnnotationComponentType.ORDERING.getValue(), null)) {
                    if (c.getName().isEmpty() || "annis".equals(c.getLayer())) continue;
                    segNames.add(c.getName());
                }
            }
            catch (ApiException ex) {
                if (ex.getCode() == 403) {
                    log.debug("Did not have access rights to query segmentation names for corpus", (Throwable)ex);
                    continue;
                }
                log.warn("Could not query segmentation names for corpus", (Throwable)ex);
            }
        }
        return segNames;
    }

    public SearchOptionsPanel() {
        this.setWidth("100%");
        this.setHeight("-1px");
        this.pbLoadConfig = new ProgressBar();
        this.pbLoadConfig.setIndeterminate(true);
        this.pbLoadConfig.setCaption("Loading search options...");
        this.addComponent((com.vaadin.ui.Component)this.pbLoadConfig);
        this.cbLeftContext = new ComboBox("Left Context");
        this.cbRightContext = new ComboBox("Right Context");
        this.cbResultsPerPage = new ComboBox("Results Per Page");
        this.cbLeftContext.setEmptySelectionAllowed(false);
        this.cbRightContext.setEmptySelectionAllowed(false);
        this.cbResultsPerPage.setEmptySelectionAllowed(false);
        ComboBox.NewItemProvider & Serializable contextNewItemProvider = (ComboBox.NewItemProvider & Serializable)v -> {
            try {
                int numericValue = Integer.parseInt(v);
                if (numericValue >= 0 && numericValue < this.maxContext.get()) {
                    return Optional.of(numericValue);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return Optional.empty();
        };
        this.cbLeftContext.setNewItemProvider((ComboBox.NewItemProvider)contextNewItemProvider);
        this.cbRightContext.setNewItemProvider((ComboBox.NewItemProvider)contextNewItemProvider);
        this.cbResultsPerPage.setNewItemProvider((ComboBox.NewItemProvider & Serializable)v -> {
            try {
                return Optional.of(Integer.parseInt(v));
            }
            catch (NumberFormatException numberFormatException) {
                return Optional.empty();
            }
        });
        this.cbLeftContext.setTextInputAllowed(true);
        this.cbRightContext.setTextInputAllowed(true);
        this.cbResultsPerPage.setTextInputAllowed(true);
        this.cbSegmentation = new ComboBox("Show context in");
        this.cbSegmentation.setTextInputAllowed(false);
        this.cbSegmentation.setEmptySelectionAllowed(true);
        this.cbSegmentation.setNewItemProvider((ComboBox.NewItemProvider & Serializable)v -> Optional.of(v));
        this.cbSegmentation.setEmptySelectionCaption(NULL_SEGMENTATION_VALUE);
        this.cbSegmentation.setDescription("If corpora with multiple context definitions are selected, a list of available context units will be displayed. By default context is calculated in \u2018tokens\u2019 (e.g. 5 minimal units to the left and right of a search result). Some corpora might offer further context definitions, e.g. in syllables, word forms belonging to different speakers, normalized or diplomatic segmentations of a manuscript, etc.");
        this.cbOrder = new ComboBox("Order", Arrays.asList(FindQuery.OrderEnum.values()));
        this.cbOrder.setEmptySelectionAllowed(false);
        this.cbOrder.setItems((Object[])FindQuery.OrderEnum.values());
        this.cbOrder.setValue((Object)FindQuery.OrderEnum.NORMAL);
        this.cbQueryLanguage = new ComboBox("Query Language");
        this.cbQueryLanguage.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)ql -> {
            switch (ql) {
                case AQL: {
                    return "AQL (latest)";
                }
                case AQLQUIRKSV3: {
                    return "AQL (compatibility mode)";
                }
            }
            return "";
        });
        this.cbQueryLanguage.setItems((Object[])QueryLanguage.values());
        this.cbQueryLanguage.setValue((Object)QueryLanguage.AQL);
        this.cbQueryLanguage.setEmptySelectionAllowed(false);
        this.cbLeftContext.setVisible(false);
        this.cbRightContext.setVisible(false);
        this.cbResultsPerPage.setVisible(false);
        this.cbOrder.setVisible(false);
        this.addComponent((com.vaadin.ui.Component)this.cbLeftContext);
        this.addComponent((com.vaadin.ui.Component)this.cbRightContext);
        this.addComponent((com.vaadin.ui.Component)this.cbSegmentation);
        this.addComponent((com.vaadin.ui.Component)this.cbResultsPerPage);
        this.addComponent((com.vaadin.ui.Component)this.cbOrder);
        this.addComponent((com.vaadin.ui.Component)this.cbQueryLanguage);
    }

    public void attach() {
        super.attach();
        this.cbResultsPerPage.setItems(PREDEFINED_PAGE_SIZES);
        this.cbLeftContext.setItems(PREDEFINED_CONTEXTS);
        this.cbRightContext.setItems(PREDEFINED_CONTEXTS);
        if (this.getUI() instanceof AnnisUI) {
            AnnisUI ui = (AnnisUI)this.getUI();
            this.state = ui.getQueryState();
            Binder<QueryUIState> binder = ui.getQueryController().getBinder();
            binder.forField(this.cbLeftContext).bind("leftContext");
            binder.forField(this.cbRightContext).bind("rightContext");
            binder.forField(this.cbSegmentation).bind("contextSegmentation");
            binder.forField(this.cbResultsPerPage).bind("limit");
            binder.forField(this.cbOrder).bind("order");
            binder.forField(this.cbQueryLanguage).bind(QueryUIState::getQueryLanguage, QueryUIState::setQueryLanguage);
            Background.run(new CorpusConfigUpdater(ui, new LinkedHashSet<String>(this.state.getSelectedCorpora()), false));
        }
    }

    public boolean isUpdateStateFromConfig() {
        return this.updateStateFromConfig;
    }

    private CorpusConfiguration mergeConfigs(Collection<String> corpora, CorpusConfigMap corpusConfigurations) {
        Set allBaseTextSegmentations;
        Set allContextSegmentations;
        Optional<Integer> mergedPageSize;
        Optional<Integer> mergedMaxCtx;
        List selectedConfigs = corpora.stream().map(c -> corpusConfigurations.get((String)c)).filter(config -> config != null).collect(Collectors.toList());
        if (selectedConfigs.size() == 1) {
            return (CorpusConfiguration)selectedConfigs.get(0);
        }
        CorpusConfiguration corpusConfig = Helper.getDefaultCorpusConfig();
        Optional<Integer> mergedDefaultCtx = selectedConfigs.stream().map(config -> config.getContext().getDefault()).min(Comparator.naturalOrder());
        if (mergedDefaultCtx.isPresent()) {
            corpusConfig.getContext().setDefault(mergedDefaultCtx.get());
        }
        if ((mergedMaxCtx = selectedConfigs.stream().map(config -> config.getContext().getMax()).filter(maxCtx -> maxCtx != null).min(Comparator.naturalOrder())).isPresent()) {
            corpusConfig.getContext().setMax(mergedMaxCtx.get());
        }
        TreeSet<Integer> contextSizes = new TreeSet<Integer>();
        for (CorpusConfiguration config2 : selectedConfigs) {
            contextSizes.addAll(config2.getContext().getSizes());
        }
        if (!contextSizes.isEmpty()) {
            corpusConfig.getContext().setSizes(new ArrayList<Integer>(contextSizes));
        }
        if ((mergedPageSize = selectedConfigs.stream().map(config -> config.getView().getPageSize()).min(Comparator.naturalOrder())).isPresent()) {
            corpusConfig.getView().setPageSize(mergedPageSize.get());
        }
        if ((allContextSegmentations = selectedConfigs.stream().map(config -> config.getContext().getSegmentation()).collect(Collectors.toSet())).size() == 1) {
            corpusConfig.getContext().setSegmentation((String)allContextSegmentations.iterator().next());
        }
        if ((allBaseTextSegmentations = selectedConfigs.stream().map(config -> config.getView().getBaseTextSegmentation()).collect(Collectors.toSet())).size() == 1) {
            corpusConfig.getView().setBaseTextSegmentation((String)allBaseTextSegmentations.iterator().next());
        }
        return corpusConfig;
    }

    private void setLoadingState(boolean isLoading) {
        this.pbLoadConfig.setVisible(isLoading);
        this.cbLeftContext.setVisible(!isLoading);
        this.cbRightContext.setVisible(!isLoading);
        this.cbResultsPerPage.setVisible(!isLoading);
        this.cbSegmentation.setVisible(!isLoading);
        this.cbOrder.setVisible(!isLoading);
    }

    public void setUpdateStateFromConfig(boolean updateStateFromConfig) {
        this.updateStateFromConfig = updateStateFromConfig;
    }

    public void updateSearchPanelConfigurationInBackground(Collection<String> corpora) {
        this.setLoadingState(true);
        this.cbLeftContext.setItems((Object[])new Integer[0]);
        this.cbRightContext.setItems((Object[])new Integer[0]);
        this.cbSegmentation.setItems((Object[])new String[0]);
        UI ui = this.getUI();
        if (ui instanceof AnnisUI) {
            Background.run(new CorpusConfigUpdater((AnnisUI)ui, corpora, true));
        }
    }

    private class CorpusConfigUpdater
    implements Runnable {
        private final AnnisUI ui;
        private final Collection<String> corpora;
        private final boolean corpusSelectionChanged;
        private final boolean setValues;

        public CorpusConfigUpdater(AnnisUI ui, Collection<String> corpora, boolean corpusSelectionChanged) {
            this.ui = ui;
            this.corpora = corpora;
            this.corpusSelectionChanged = corpusSelectionChanged;
            this.setValues = corpusSelectionChanged && SearchOptionsPanel.this.isUpdateStateFromConfig();
        }

        @Override
        public void run() {
            List segmentations = SearchOptionsPanel.getSegmentationNamesFromService(this.corpora, this.ui);
            TreeSet<String> corporaWithDefault = new TreeSet<String>(this.corpora);
            corporaWithDefault.add(SearchOptionsPanel.DEFAULT_CONFIG);
            CorpusConfigMap corpusConfigs = new CorpusConfigMap();
            for (String c : corporaWithDefault) {
                corpusConfigs.put(c, this.ui.getCorpusConfigWithCache(c));
            }
            if (!corpusConfigs.containsConfig(SearchOptionsPanel.DEFAULT_CONFIG)) {
                corpusConfigs.put(SearchOptionsPanel.DEFAULT_CONFIG, Helper.getDefaultCorpusConfig());
            }
            this.ui.access(() -> {
                SearchOptionsPanel.this.setLoadingState(false);
                CorpusConfiguration c = SearchOptionsPanel.this.mergeConfigs(this.corpora, corpusConfigs);
                if (c.getContext().getMax() == null) {
                    SearchOptionsPanel.this.maxContext.set(Integer.MAX_VALUE);
                } else {
                    SearchOptionsPanel.this.maxContext.set(c.getContext().getMax());
                }
                SearchOptionsPanel.this.cbLeftContext.setItems(c.getContext().getSizes());
                SearchOptionsPanel.this.cbRightContext.setItems(c.getContext().getSizes());
                SearchOptionsPanel.this.cbSegmentation.setItems((Collection)segmentations);
                if (this.setValues) {
                    SearchOptionsPanel.this.cbLeftContext.setValue((Object)c.getContext().getDefault());
                    SearchOptionsPanel.this.cbRightContext.setValue((Object)c.getContext().getDefault());
                    SearchOptionsPanel.this.cbSegmentation.setValue((Object)c.getContext().getSegmentation());
                    SearchOptionsPanel.this.cbResultsPerPage.setValue((Object)c.getView().getPageSize());
                }
                if (this.corpusSelectionChanged) {
                    SearchOptionsPanel.this.setUpdateStateFromConfig(true);
                }
            });
        }
    }
}

