/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.docbrowser;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.ClientConnector;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.VerticalLayout;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.api.model.AnnotationComponentType;
import org.corpus_tools.annis.api.model.QueryLanguage;
import org.corpus_tools.annis.api.model.VisualizerRule;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Background;
import org.corpus_tools.annis.gui.CommonUI;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.components.ExceptionDialog;
import org.corpus_tools.annis.gui.docbrowser.DocBrowserPanel;
import org.corpus_tools.annis.gui.graphml.DocumentGraphMapper;
import org.corpus_tools.annis.gui.objects.RawTextWrapper;
import org.corpus_tools.annis.gui.visualizers.FilteringVisualizerPlugin;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.visualizers.VisualizerPlugin;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SaltProject;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocBrowserController
implements Serializable {
    private static final long serialVersionUID = 7035834674160143771L;
    private static final Logger log = LoggerFactory.getLogger(DocBrowserController.class);
    private static final Resource EYE_ICON = VaadinIcons.EYE;
    private static final Resource DOC_ICON = VaadinIcons.FILE_TEXT_O;
    private final AnnisUI ui;
    private final Map<String, Component> initedDocBrowsers;
    private final Map<String, Component> initiatedVis;
    private final Map<String, Panel> visibleVisHolder;

    public static VisualizerInput createInput(String corpus, List<String> docPath, VisualizerRule config, List<String> nodeAnnoFilter, boolean useRawText, CommonUI ui) {
        VisualizerInput input = new VisualizerInput();
        input.setMappings(config.getMappings());
        input.setNamespace(config.getLayer());
        input.setUI(ui);
        input.setContextPath(ui.getServletContext().getContextPath());
        try {
            CorporaApi api = new CorporaApi(Helper.getClient(ui));
            SaltProject p = SaltFactory.createSaltProject();
            SCorpusGraph cg = p.createCorpusGraph();
            URI docURI = URI.createURI((String)("salt:/" + Joiner.on((char)'/').join(docPath)));
            SDocument doc = cg.createDocument(docURI);
            String aql = Helper.buildDocumentQuery(docPath, nodeAnnoFilter, useRawText);
            File graphML = api.subgraphForQuery(docPath.get(0), aql, QueryLanguage.AQL, useRawText ? AnnotationComponentType.ORDERING : null);
            SDocumentGraph docGraph = DocumentGraphMapper.map(graphML);
            doc.setDocumentGraph(docGraph);
            input.setResult(doc);
            if (useRawText) {
                input.setRawText(new RawTextWrapper(docGraph));
            }
        }
        catch (ApiException e) {
            log.error("General remote service exception", (Throwable)e);
        }
        catch (IOException | XMLStreamException ex) {
            log.error("Could not map GraphML to Salt", (Throwable)ex);
            ui.access(() -> ExceptionDialog.show(ex, "Could not map GraphML to Salt", ui));
        }
        return input;
    }

    public DocBrowserController(AnnisUI ui) {
        this.ui = ui;
        this.initedDocBrowsers = new HashMap<String, Component>();
        this.initiatedVis = new HashMap<String, Component>();
        this.visibleVisHolder = new HashMap<String, Panel>();
    }

    public void openDocBrowser(String corpus) {
        this.initedDocBrowsers.computeIfAbsent(corpus, k -> DocBrowserPanel.initDocBrowserPanel(this.ui, k));
        TabSheet.Tab tab = this.ui.getSearchView().getTabSheet().addTab(this.initedDocBrowsers.get(corpus), corpus);
        tab.setIcon(DOC_ICON);
        tab.setClosable(true);
        this.ui.getSearchView().getTabSheet().setSelectedTab(tab);
    }

    public void openDocVis(String corpus, String docId, VisualizerRule visConfig, Button btn) {
        List<String> path = Helper.getCorpusPath(docId);
        String canonicalTitle = Joiner.on((String)" > ").join(path) + " - Visualizer: " + visConfig.getDisplayName();
        String tabCaption = StringUtils.substring((String)canonicalTitle, (int)0, (int)15) + "...";
        if (this.visibleVisHolder.containsKey(canonicalTitle)) {
            Panel visHolder = this.visibleVisHolder.get(canonicalTitle);
            this.ui.getSearchView().getTabSheet().setSelectedTab((Component)visHolder);
            return;
        }
        Panel visHolder = new Panel();
        visHolder.setSizeFull();
        visHolder.addDetachListener((ClientConnector.DetachListener & Serializable)event -> this.visibleVisHolder.remove(canonicalTitle));
        ProgressBar progressBar = new ProgressBar(1.0f);
        progressBar.setIndeterminate(true);
        progressBar.setSizeFull();
        VerticalLayout layoutProgress = new VerticalLayout(new Component[]{progressBar});
        layoutProgress.setSizeFull();
        layoutProgress.setComponentAlignment((Component)progressBar, Alignment.MIDDLE_CENTER);
        visHolder.setContent((Component)layoutProgress);
        TabSheet.Tab visTab = this.ui.getSearchView().getTabSheet().addTab((Component)visHolder, tabCaption);
        visTab.setDescription(canonicalTitle);
        visTab.setIcon(EYE_ICON);
        visTab.setClosable(true);
        this.ui.getSearchView().getTabSheet().setSelectedTab(visTab);
        this.visibleVisHolder.put(canonicalTitle, visHolder);
        Background.run(new DocVisualizerFetcher(corpus, path, canonicalTitle, visConfig.getVisType(), visHolder, visConfig, btn));
    }

    private class DocVisualizerFetcher
    implements Runnable {
        VisualizerRule config;
        String corpus;
        List<String> docPath;
        final Button btn;
        private final String canonicalTitle;
        private final String type;
        private final Panel visHolder;
        private VisualizerInput input;

        public DocVisualizerFetcher(String corpus, List<String> docPath, String canonicalTitle, String type, Panel visHolder, VisualizerRule config, Button btn) {
            this.corpus = corpus;
            this.docPath = docPath;
            this.btn = btn;
            this.config = config;
            this.canonicalTitle = canonicalTitle;
            this.type = type;
            this.visHolder = visHolder;
        }

        @Override
        public void run() {
            this.input = null;
            boolean createVis = !DocBrowserController.this.initiatedVis.containsKey(this.canonicalTitle);
            Optional<VisualizerPlugin> visualizer = DocBrowserController.this.ui.getVisualizerPlugins().stream().filter(p -> Objects.equal((Object)p.getShortName(), (Object)this.type)).findAny();
            List<String> nodeAnnoFilter = null;
            if (visualizer.isPresent() && visualizer.get() instanceof FilteringVisualizerPlugin) {
                nodeAnnoFilter = ((FilteringVisualizerPlugin)((Object)visualizer.get())).getFilteredNodeAnnotationNames(this.corpus, this.docPath.get(this.docPath.size() - 1), this.config.getMappings(), DocBrowserController.this.ui);
            } else if (visualizer.isPresent() && visualizer.get().isUsingRawText()) {
                nodeAnnoFilter = new LinkedList<String>();
            }
            if (createVis && visualizer.isPresent()) {
                this.input = DocBrowserController.createInput(this.corpus, this.docPath, this.config, nodeAnnoFilter, visualizer.get().isUsingRawText(), DocBrowserController.this.ui);
            }
            DocBrowserController.this.ui.access(() -> {
                this.btn.setEnabled(true);
                if (createVis && this.input != null && visualizer.isPresent()) {
                    Component vis1 = ((VisualizerPlugin)visualizer.get()).createComponent(this.input, null);
                    vis1.addStyleName("corpus-font-force");
                    vis1.setPrimaryStyleName("docviewer");
                    vis1.setCaption(this.canonicalTitle);
                    vis1.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
                    vis1.setHeight(-1.0f, Sizeable.Unit.PIXELS);
                    DocBrowserController.this.initiatedVis.put(this.canonicalTitle, vis1);
                }
                Component vis2 = (Component)DocBrowserController.this.initiatedVis.get(this.canonicalTitle);
                this.visHolder.setContent(vis2);
            });
        }
    }
}

