/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.docbrowser;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.vaadin.data.HasValue;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.api.model.AnnotationComponentType;
import org.corpus_tools.annis.api.model.QueryLanguage;
import org.corpus_tools.annis.api.model.VisualizerRule;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Background;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.components.ExceptionDialog;
import org.corpus_tools.annis.gui.docbrowser.DocBrowserTable;
import org.corpus_tools.annis.gui.graphml.CorpusGraphMapper;
import org.corpus_tools.annis.gui.objects.DocumentBrowserConfig;
import org.corpus_tools.annis.gui.objects.Visualizer;
import org.corpus_tools.salt.common.SCorpusGraph;

public class DocBrowserPanel
extends Panel {
    private static final long serialVersionUID = -1785316182826648719L;
    private static final Escaper urlPathEscape = UrlEscapers.urlPathSegmentEscaper();
    private final AnnisUI ui;
    private VerticalLayout layout;
    private String corpus;
    private DocBrowserTable table;
    final ProgressBar progress;

    public static DocBrowserPanel initDocBrowserPanel(AnnisUI ui, String corpus) {
        return new DocBrowserPanel(ui, corpus);
    }

    private DocBrowserPanel(AnnisUI ui, String corpus) {
        this.ui = ui;
        this.corpus = corpus;
        this.layout = new VerticalLayout();
        this.setContent((Component)this.layout);
        this.layout.setSizeFull();
        this.layout.addStyleName("borderless");
        this.setSizeFull();
        this.progress = new ProgressBar();
        this.progress.setIndeterminate(true);
        this.progress.setSizeFull();
    }

    public void attach() {
        super.attach();
        if (this.table == null) {
            this.layout.addComponent((Component)this.progress);
            this.layout.setComponentAlignment((Component)this.progress, Alignment.MIDDLE_CENTER);
            Background.run(new LoadingDocs());
        }
    }

    public String getCorpus() {
        return this.corpus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocumentBrowserConfig getDocBrowserConfig() {
        DocumentBrowserConfig defaultConfig = new DocumentBrowserConfig();
        VisualizerRule textVis = new VisualizerRule();
        textVis.setDisplayName("full text");
        textVis.setVisType("raw_text");
        defaultConfig.setVisualizers(Arrays.asList(new Visualizer(textVis)));
        CorporaApi api = new CorporaApi(Helper.getClient(this.ui));
        try {
            File result = api.getFile(this.getCorpus(), urlPathEscape.escape(this.getCorpus()) + "/document_browser.json");
            try (FileInputStream is = new FileInputStream(result);){
                DocumentBrowserConfig config;
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                DocumentBrowserConfig documentBrowserConfig = config = (DocumentBrowserConfig)mapper.readValue((InputStream)is, DocumentBrowserConfig.class);
                return documentBrowserConfig;
            }
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) return defaultConfig;
            ExceptionDialog.show(ex, "Could not get the document browser configuration file from the backend.", this.ui);
            return defaultConfig;
        }
        catch (IOException ex) {
            ExceptionDialog.show(ex, "Could not get the document browser configuration file from the backend.", this.ui);
        }
        return defaultConfig;
    }

    public void openVis(String docId, VisualizerRule config, Button btn) {
        this.ui.getSearchView().getDocBrowserController().openDocVis(this.corpus, docId, config, btn);
    }

    private class LoadingDocs
    implements Runnable {
        private LoadingDocs() {
        }

        @Override
        public void run() {
            CorporaApi api = new CorporaApi(Helper.getClient(DocBrowserPanel.this.ui));
            try {
                File graphML = api.subgraphForQuery(DocBrowserPanel.this.corpus, "annis:node_type=\"corpus\"", QueryLanguage.AQL, AnnotationComponentType.PARTOF);
                SCorpusGraph graph = CorpusGraphMapper.map(graphML);
                List docs = graph.getDocuments();
                DocBrowserPanel.this.ui.access(() -> {
                    DocBrowserPanel.this.table = DocBrowserTable.getDocBrowserTable(DocBrowserPanel.this);
                    DocBrowserPanel.this.layout.removeComponent((Component)DocBrowserPanel.this.progress);
                    TextField txtFilter = new TextField();
                    txtFilter.setWidth("100%");
                    txtFilter.setPlaceholder("Filter documents by name");
                    txtFilter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        if (DocBrowserPanel.this.table != null) {
                            DocBrowserPanel.this.table.setContainerFilter((Container.Filter)new SimpleStringFilter((Object)"document name", (String)event.getValue(), true, false));
                        }
                    });
                    DocBrowserPanel.this.layout.addComponent((Component)txtFilter);
                    DocBrowserPanel.this.layout.addComponent((Component)DocBrowserPanel.this.table);
                    DocBrowserPanel.this.layout.setExpandRatio((Component)DocBrowserPanel.this.table, 1.0f);
                    DocBrowserPanel.this.table.setDocuments(docs);
                });
            }
            catch (IOException | XMLStreamException | ApiException ex) {
                DocBrowserPanel.this.ui.access(() -> ExceptionDialog.show(ex, DocBrowserPanel.this.ui));
            }
        }
    }
}

