/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.exporter;

import com.vaadin.ui.UI;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.exporter.BaseMatrixExporter;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Label;
import org.springframework.stereotype.Component;

@Component
public class CSVExporter
extends BaseMatrixExporter {
    private static final long serialVersionUID = -8993537374171042122L;
    private Set<String> metakeys;
    private SortedMap<Integer, TreeSet<String>> annotationsForMatchedNodes;

    @Override
    public void createAdjacencyMatrix(SDocumentGraph graph, Map<String, String> args, int matchNumber, int nodeCount) throws IOException, IllegalArgumentException {
        if (matchNumber == 0) {
            this.metakeys = new LinkedHashSet<String>();
            if (args.containsKey("metakeys")) {
                this.metakeys.addAll(Arrays.asList(args.get("metakeys").split(",")));
            }
            this.annotationsForMatchedNodes = new TreeMap<Integer, TreeSet<String>>();
        }
        for (SNode node : this.getMatchedNodes(graph)) {
            int node_id = node.getFeature("annis", "matchednode").getValue_SNUMERIC().intValue();
            if (!this.annotationsForMatchedNodes.containsKey(node_id)) {
                this.annotationsForMatchedNodes.put(node_id, new TreeSet());
            }
            ArrayList annots = new ArrayList(node.getAnnotations());
            Set annoNames = (Set)this.annotationsForMatchedNodes.get(node_id);
            for (SAnnotation annot : annots) {
                annoNames.add(annot.getNamespace() + "::" + annot.getName());
            }
        }
    }

    @Override
    public String getFileEnding() {
        return "csv";
    }

    @Override
    public String getHelpMessage() {
        return "The CSV Exporter exports only the values of the elements searched for by the user, ignoring the context around search results. The values for all annotations of each of the found nodes is given in a comma-separated table (CSV). <br/><br/>Parameters: <br/><em>metakeys</em> - comma seperated list of all meta data to include in the result (e.g. <code>metakeys=title,documentname</code>)";
    }

    private Set<SNode> getMatchedNodes(SDocumentGraph graph) {
        HashSet<SNode> matchedNodes = new HashSet<SNode>();
        for (SNode node : graph.getNodes()) {
            if (node.getFeature("annis", "matchednode") == null) continue;
            matchedNodes.add(node);
        }
        return matchedNodes;
    }

    @Override
    public void getOrderedMatchNumbers() {
    }

    @Override
    public boolean isAlignable() {
        return false;
    }

    @Override
    public boolean needsContext() {
        return false;
    }

    @Override
    public void outputText(SDocumentGraph graph, boolean alignmc, int matchNumber, Writer out, UI ui) throws IOException, IllegalArgumentException {
        if (matchNumber == 0) {
            ArrayList<String> headerLine = new ArrayList<String>();
            for (Map.Entry<Integer, TreeSet<String>> match : this.annotationsForMatchedNodes.entrySet()) {
                int node_id = match.getKey();
                headerLine.add(String.valueOf(node_id) + "_id");
                headerLine.add(String.valueOf(node_id) + "_span");
                for (String annoName : match.getValue()) {
                    headerLine.add(String.valueOf(node_id) + "_anno_" + annoName);
                }
            }
            for (String key : this.metakeys) {
                headerLine.add("meta_" + key);
            }
            out.append(StringUtils.join(headerLine, (String)"\t"));
            out.append("\n");
        }
        TreeMap<Integer, String> contentLine = new TreeMap<Integer, String>();
        for (SNode node : this.getMatchedNodes(graph)) {
            ArrayList<String> nodeLine = new ArrayList<String>();
            nodeLine.add(node.getId());
            String span = graph.getText(node);
            if (span != null) {
                nodeLine.add(graph.getText(node));
            } else {
                nodeLine.add("");
            }
            int node_id = node.getFeature("annis", "matchednode").getValue_SNUMERIC().intValue();
            for (String annoName : (TreeSet)this.annotationsForMatchedNodes.get(node_id)) {
                SAnnotation anno = node.getAnnotation(annoName);
                if (anno != null) {
                    nodeLine.add(anno.getValue_STEXT());
                    continue;
                }
                nodeLine.add("'NULL'");
            }
            contentLine.put(node_id, StringUtils.join(nodeLine, (String)"\t"));
        }
        out.append(StringUtils.join(contentLine.values(), (String)"\t"));
        if (!this.metakeys.isEmpty()) {
            String corpus_name = Helper.getCorpusPath(graph.getDocument().getId().toString()).get(0);
            Map allMetaAnnos = Helper.getMetaData(corpus_name, Optional.of(graph.getDocument().getName()), ui).stream().collect(Collectors.toMap(Label::getName, Function.identity()));
            for (String metaName : this.metakeys) {
                SMetaAnnotation anno = (SMetaAnnotation)allMetaAnnos.get(metaName);
                if (anno == null) {
                    out.append("\t");
                    continue;
                }
                out.append("\t" + anno.getValue());
            }
        }
        out.append("\n");
    }
}

