/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.flatquerybuilder;

import com.vaadin.event.FieldEvents;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.ComboBox;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.corpus_tools.annis.gui.flatquerybuilder.FlatQueryBuilder;

public class EdgeBox
extends Panel {
    private static final long serialVersionUID = 6973221158152538822L;
    private static final String[][] BASIS_OPERATORS = new String[][]{{".", ".2", ".1,2", ".*"}, {".\t[is directly preceding]", ".2\t[is preceding with one token in between]", ".1,2\t[is directly preceding or with one token in between]", ".*\t[is indirectly preceding]"}};
    private static HashMap<String, String> EO;
    private static final String UD_EO_DESCRIPTION = "\t(user defined)";
    private static final String WIDTH = "45px";
    private static final String REGEX_PATTERN = "(\\.((\\*)|([1-9]+[0-9]*(,[1-9]+[0-9]*)?))?)";
    private static final String REGEX_PATTERN_DOUBLEBOUND = "\\\\.[1-9]+[0-9]*,[1-9]+[0-9]*";
    private ComboBox edge;
    private String storedValue;

    public EdgeBox(FlatQueryBuilder sq) {
        this.initEOs();
        this.storedValue = ".";
        this.edge = new ComboBox();
        this.edge.setItemCaptionMode(AbstractSelect.ItemCaptionMode.EXPLICIT);
        for (Map.Entry<String, String> o : EO.entrySet()) {
            this.edge.addItem((Object)o.getKey());
            this.edge.setItemCaption(o, o.getValue());
        }
        this.edge.setNewItemsAllowed(true);
        this.edge.setTextInputAllowed(true);
        this.edge.setWidth(WIDTH);
        this.edge.setNullSelectionAllowed(false);
        this.edge.setImmediate(true);
        this.edge.addFocusListener((FieldEvents.FocusListener & Serializable)e -> this.edge.select(null));
        this.edge.addBlurListener((FieldEvents.BlurListener & Serializable)e -> {
            if (this.edge.getValue() != null) {
                String value = this.edge.getValue().toString();
                if (!value.equals("")) {
                    boolean valid = this.validOperator(value);
                    if (!EO.containsKey(value) && valid) {
                        String caption = value + UD_EO_DESCRIPTION;
                        EO.put(value, caption);
                        this.edge.setItemCaption((Object)value, caption);
                    }
                    if (!valid) {
                        this.edge.removeItem((Object)value);
                        this.edge.select(null);
                    }
                }
                this.storedValue = this.edge.getValue() != null ? this.edge.getValue().toString() : this.storedValue;
            } else {
                this.edge.setValue((Object)this.storedValue);
            }
        });
        this.setContent((Component)this.edge);
        this.edge.select((Object)BASIS_OPERATORS[0][0]);
    }

    public String getValue() {
        Object value = this.edge.getValue();
        return value == null ? null : value.toString();
    }

    private void initEOs() {
        EO = new HashMap();
        for (int i = 0; i < BASIS_OPERATORS[0].length; ++i) {
            EO.put(BASIS_OPERATORS[0][i], BASIS_OPERATORS[1][i]);
        }
    }

    public void setValue(String value) {
        boolean valid = this.validOperator(value);
        if (!EO.containsKey(value) && valid) {
            String caption = value + UD_EO_DESCRIPTION;
            EO.put(value, caption);
            this.edge.addItem((Object)value);
            this.edge.setItemCaption((Object)value, caption);
        }
        if (valid) {
            this.edge.setValue((Object)value);
            this.storedValue = value;
        } else {
            this.edge.select(null);
        }
    }

    private boolean validOperator(String o) {
        String s = o.replace(" ", "");
        if (Pattern.matches(REGEX_PATTERN, s)) {
            if (Pattern.matches(REGEX_PATTERN_DOUBLEBOUND, s)) {
                int split = s.indexOf(",");
                String s1 = s.substring(1, split);
                String s2 = s.substring(split + 1);
                return Integer.parseInt(s1) <= Integer.parseInt(s2);
            }
            return true;
        }
        return false;
    }
}

