/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.flatquerybuilder;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.ui.OptionGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.corpus_tools.annis.gui.flatquerybuilder.FlatQueryBuilder;

public class MetaBox
extends Panel
implements Button.ClickListener {
    private static final long serialVersionUID = -2426294948420906953L;
    private Button btClose;
    private OptionGroup tcs;
    private VerticalLayout sb;
    private FlatQueryBuilder sq;
    private final String datum;

    public MetaBox(String level, FlatQueryBuilder sq) {
        this.sq = sq;
        this.sb = new VerticalLayout();
        this.datum = level;
        this.btClose = new Button("X", (Button.ClickListener)this);
        this.btClose.setStyleName("small");
        TreeSet<String> annonames = new TreeSet<String>();
        for (String a : sq.getAvailableAnnotationLevels(level)) {
            annonames.add(a);
        }
        OptionGroup l = new OptionGroup(level);
        for (String annoname : annonames) {
            if (annoname.isEmpty()) continue;
            l.addItem((Object)annoname);
        }
        l.setMultiSelect(true);
        l.setNullSelectionAllowed(true);
        l.addStyleName("corpus-font-force");
        l.setImmediate(true);
        this.tcs = l;
        this.sb.addComponent((Component)this.tcs);
        this.sb.addComponent((Component)this.btClose);
        this.setContent((Component)this.sb);
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getButton() == this.btClose) {
            this.sq.removeMetaBox(this);
        }
    }

    public String getMetaDatum() {
        return this.datum;
    }

    public Collection<String> getValues() {
        ArrayList<String> result = new ArrayList<String>();
        Object value = this.tcs.getValue();
        if (value instanceof Collection) {
            for (Object v : (Collection)value) {
                if (!(v instanceof String)) continue;
                result.add((String)v);
            }
        }
        return result;
    }

    public void setValue(Collection<String> values) {
        this.tcs.setValue(values);
    }

    public void setValue(String value) {
        this.tcs.setValue((Object)value);
    }
}

