/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.flatquerybuilder;

import com.vaadin.server.ClassResource;
import com.vaadin.ui.UI;
import java.io.IOException;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.corpus_tools.annis.gui.components.ExceptionDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReducingStringComparator {
    private static final String READING_ERROR_MESSAGE = "ERROR: Unable to load mapping file(s)!";
    private static String MAPPING_FILE = "mapfile.fqb";
    private HashMap<String, HashMap<Character, Character>> ALLOGRAPHS;
    public static final Pattern DIACRITICS = Pattern.compile("[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]+");

    public ReducingStringComparator() {
        this.readMappings();
    }

    public int compare(Object a, Object b, String mapname) {
        String s1 = this.removeCombiningCharacters((String)a);
        String s2 = this.removeCombiningCharacters((String)b);
        return this.compare2(s1.replace(" ", ""), s2.replace(" ", ""), mapname);
    }

    private int compare2(String s1, String s2, String mapname) {
        int l = s1.length();
        if (l < s2.length()) {
            return -1;
        }
        if (l > s2.length()) {
            return 1;
        }
        for (int i = 0; i < l; ++i) {
            char rc2;
            char c1 = s1.charAt(i);
            char c2 = s2.charAt(i);
            HashMap<Character, Character> curMap = this.ALLOGRAPHS.get(mapname);
            char rc1 = curMap.containsKey(Character.valueOf(c1)) ? curMap.get(Character.valueOf(c1)).charValue() : c1;
            char c = rc2 = curMap.containsKey(Character.valueOf(c2)) ? curMap.get(Character.valueOf(c2)).charValue() : c2;
            if (rc1 < rc2) {
                return -1;
            }
            if (rc1 <= rc2) continue;
            return 1;
        }
        return 0;
    }

    public boolean contains(String fullSequence, String subSequence, String mapname) {
        String subS = this.removeCombiningCharacters(subSequence);
        String fullS = this.removeCombiningCharacters(fullSequence);
        subS = subS.replace(" ", "");
        fullS = fullS.replace(" ", "");
        int l = subS.length();
        for (int i = 0; i < fullS.length() - l + 1; ++i) {
            if (this.compare2(fullS.substring(i, i + l), subS, mapname) != 0) continue;
            return true;
        }
        return false;
    }

    public HashMap<String, HashMap<Character, Character>> getMappings() {
        return this.ALLOGRAPHS;
    }

    private HashMap<Character, Character> initAlphabet() {
        HashMap<Character, Character> h = new HashMap<Character, Character>();
        for (int i = 97; i < 122; ++i) {
            char c = (char)i;
            h.put(Character.valueOf(c), Character.valueOf(c));
            h.put(Character.valueOf(Character.toUpperCase(c)), Character.valueOf(c));
        }
        return h;
    }

    private void readMappings() {
        this.ALLOGRAPHS = new HashMap();
        ClassResource cr = new ClassResource(ReducingStringComparator.class, MAPPING_FILE);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document mappingD = db.parse(cr.getStream().getStream());
            NodeList mappings = mappingD.getElementsByTagName("mapping");
            for (int i = 0; i < mappings.getLength(); ++i) {
                Element mapping = (Element)mappings.item(i);
                String mappingName = mapping.getAttribute("name");
                HashMap<Character, Character> mappingMap = this.initAlphabet();
                NodeList variants = mapping.getElementsByTagName("variant");
                for (int j = 0; j < variants.getLength(); ++j) {
                    Element var = (Element)variants.item(j);
                    char varvalue = var.getAttribute("value").charAt(0);
                    Element character = (Element)var.getParentNode();
                    char charactervalue = character.getAttribute("value").charAt(0);
                    mappingMap.put(Character.valueOf(varvalue), Character.valueOf(charactervalue));
                }
                this.ALLOGRAPHS.put(mappingName, mappingMap);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            ExceptionDialog.show(ex, READING_ERROR_MESSAGE, UI.getCurrent());
        }
    }

    private String removeCombiningCharacters(String s) {
        s = Normalizer.normalize(s, Normalizer.Form.NFD);
        s = DIACRITICS.matcher(s).replaceAll("");
        return s;
    }

    public boolean startsWith(String fullSequence, String subSequence, String mapname) {
        String subS = this.removeCombiningCharacters(subSequence);
        String fullS = this.removeCombiningCharacters(fullSequence);
        subS = subS.replace(" ", "");
        fullS = fullS.replace(" ", "");
        int l = subS.length();
        if (fullS.length() < l) {
            return false;
        }
        return this.compare2(fullS.substring(0, l), subS, mapname) == 0;
    }
}

