/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.flatquerybuilder;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.ComboBox;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.gui.flatquerybuilder.FlatQueryBuilder;
import org.corpus_tools.annis.gui.flatquerybuilder.SensitiveComboBox;

public class SpanBox
extends Panel
implements Button.ClickListener,
FieldEvents.TextChangeListener {
    private static final long serialVersionUID = -4902352228318972526L;
    public static final String BUTTON_CLOSE_LABEL = "Close";
    private static final String SB_CB_WIDTH = "140px";
    private Button btClose;
    private String ebene;
    private HorizontalLayout sb;
    private SensitiveComboBox cb;
    private CheckBox reBox;
    private Collection<String> annonames;
    private FlatQueryBuilder sq;

    public static void buildBoxValues(ComboBox cb, String level, FlatQueryBuilder sq) {
        String value = cb.getValue() != null ? cb.getValue().toString() : "";
        Collection<String> annovals = sq.getAnnotationValues(level);
        cb.removeAllItems();
        for (String s : annovals) {
            cb.addItem((Object)s);
        }
        if (annovals.contains(value)) {
            cb.setValue((Object)value);
        } else {
            cb.setValue(null);
        }
    }

    public static String removeAccents(String text) {
        return text == null ? null : Normalizer.normalize(text, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    public SpanBox(String ebene, FlatQueryBuilder sq) {
        this(ebene, sq, false);
    }

    public SpanBox(String ebene, FlatQueryBuilder sq, boolean isRegex) {
        this.ebene = ebene;
        this.sq = sq;
        this.sb = new HorizontalLayout();
        this.sb.setSpacing(true);
        this.sb.setMargin(true);
        ConcurrentSkipListSet<String> annos = new ConcurrentSkipListSet<String>();
        for (String string : sq.getAvailableAnnotationLevels(ebene)) {
            annos.add(string);
        }
        this.annonames = annos;
        Label tf = new Label(ebene);
        this.sb.addComponent((Component)tf);
        this.cb = new SensitiveComboBox();
        this.cb.setWidth(SB_CB_WIDTH);
        this.cb.addStyleName("corpus-font-force");
        this.cb.setImmediate(true);
        this.cb.setNewItemsAllowed(true);
        this.cb.setTextInputAllowed(true);
        for (String annoname : this.annonames) {
            this.cb.addItem(annoname);
        }
        this.cb.setFilteringMode(FilteringMode.OFF);
        this.cb.addListener(this);
        this.sb.addComponent((Component)this.cb);
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.setSpacing(true);
        CheckBox tb = new CheckBox("Regex");
        tb.setValue((Object)isRegex);
        horizontalLayout.addComponent((Component)tb);
        tb.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            boolean r = (Boolean)this.reBox.getValue();
            if (!r) {
                SpanBox.buildBoxValues(this.cb, ebene, sq);
            } else if (this.cb.getValue() != null) {
                String escapedItem = sq.escapeRegexCharacters(this.cb.getValue().toString());
                this.cb.addItem(escapedItem);
                this.cb.setValue(escapedItem);
            }
        });
        this.reBox = tb;
        this.btClose = new Button(BUTTON_CLOSE_LABEL, (Button.ClickListener)this);
        this.btClose.setStyleName("small");
        horizontalLayout.addComponent((Component)this.btClose);
        this.sb.addComponent((Component)horizontalLayout);
        this.setContent((Component)this.sb);
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getButton() == this.btClose) {
            this.sb.removeComponent((Component)this.cb);
            this.cb.setValue("");
            this.sq.removeSpanBox(this);
        } else if (event.getComponent() == this.reBox) {
            Boolean r = (Boolean)this.reBox.getValue();
            if (r == null) {
                r = false;
            }
            this.cb.setNewItemsAllowed(r);
            if (!r.booleanValue()) {
                SpanBox.buildBoxValues(this.cb, this.ebene, this.sq);
            } else if (this.cb.getValue() != null) {
                String escapedItem = this.sq.escapeRegexCharacters(this.cb.getValue().toString());
                this.cb.addItem(escapedItem);
                this.cb.setValue(escapedItem);
            }
        }
    }

    public String getAttribute() {
        return this.ebene;
    }

    public String getValue() {
        return this.cb.getValue().toString();
    }

    public boolean isRegEx() {
        return (Boolean)this.reBox.getValue();
    }

    public void setValue(String value) {
        if (((Boolean)this.reBox.getValue()).booleanValue()) {
            this.cb.addItem(value);
        }
        this.cb.setValue(value);
    }

    public void textChange(FieldEvents.TextChangeEvent event) {
        String txt = event.getText();
        HashMap levdistvals = new HashMap();
        if (txt.length() > 1) {
            this.cb.removeAllItems();
            for (String s : this.annonames) {
                Integer d = StringUtils.getLevenshteinDistance((CharSequence)SpanBox.removeAccents(txt), (CharSequence)SpanBox.removeAccents(s));
                if (levdistvals.containsKey(d)) {
                    ((Collection)levdistvals.get(d)).add(s);
                }
                if (levdistvals.containsKey(d)) continue;
                TreeSet<String> newc = new TreeSet<String>();
                newc.add(s);
                levdistvals.put(d, newc);
            }
            TreeSet keys = new TreeSet(levdistvals.keySet());
            for (Integer k : keys.subSet(0, 5)) {
                ArrayList values = new ArrayList((Collection)levdistvals.get(k));
                Collections.sort(values, String.CASE_INSENSITIVE_ORDER);
                for (String v : values) {
                    this.cb.addItem(v);
                }
            }
        }
    }
}

