/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.flatquerybuilder;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.AbstractSelect;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.gui.flatquerybuilder.FlatQueryBuilder;
import org.corpus_tools.annis.gui.flatquerybuilder.ReducingStringComparator;
import org.corpus_tools.annis.gui.flatquerybuilder.SearchBox;
import org.corpus_tools.annis.gui.flatquerybuilder.SensitiveComboBox;

public class ValueField
extends Panel
implements FieldEvents.TextChangeListener,
Button.ClickListener {
    private static final long serialVersionUID = -8709231932786030848L;
    private static final String BUTTON_LABEL_REMOVE = "X";
    private static final String SCB_STYLE_NAME = "corpus-font-force";
    private static final String SCB_WIDTH = "130px";
    private HorizontalLayout frame;
    private SensitiveComboBox scb;
    private Button bt;
    private FlatQueryBuilder sq;
    private SearchBox sb;
    private ConcurrentSkipListMap<String, String> values;
    private ValueMode vm;

    public static String removeAccents(String text) {
        return text == null ? null : Normalizer.normalize(text, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    public ValueField(FlatQueryBuilder sq, SearchBox sb, String level) {
        this.sq = sq;
        this.sb = sb;
        this.vm = sb.isRegEx() ? ValueMode.REGEX : ValueMode.NORMAL;
        this.values = new ConcurrentSkipListMap();
        for (String v : sq.getAvailableAnnotationLevels(level)) {
            this.values.put(v, sq.escapeRegexCharacters(v));
        }
        this.scb = new SensitiveComboBox();
        this.scb.setImmediate(true);
        this.scb.setNewItemsAllowed(true);
        this.scb.setTextInputAllowed(true);
        this.scb.setFilteringMode(FilteringMode.OFF);
        this.scb.addListener(this);
        this.scb.setItemCaptionMode(AbstractSelect.ItemCaptionMode.ID);
        this.buildValues(this.vm);
        this.scb.addStyleName(SCB_STYLE_NAME);
        this.scb.setWidth(SCB_WIDTH);
        this.bt = new Button(BUTTON_LABEL_REMOVE);
        this.bt.addClickListener((Button.ClickListener)this);
        this.bt.setStyleName("small");
        this.frame = new HorizontalLayout();
        this.frame.setSpacing(true);
        this.frame.setCaption(level);
        this.frame.addComponent((Component)this.scb);
        this.frame.addComponent((Component)this.bt);
        this.frame.setComponentAlignment((Component)this.bt, Alignment.BOTTOM_RIGHT);
        this.setContent((Component)this.frame);
    }

    private void buildValues(ValueMode vm) {
        this.vm = vm;
        if (vm.equals((Object)ValueMode.REGEX)) {
            this.scb.removeAllItems();
            for (String v : this.values.keySet()) {
                String item = this.values.get(v);
                this.scb.addItem(item);
            }
        } else {
            this.scb.removeAllItems();
            this.scb.setItemCaptionMode(AbstractSelect.ItemCaptionMode.ID);
            for (String v : this.values.keySet()) {
                this.scb.addItem(v);
            }
        }
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getButton() == this.bt) {
            this.sb.removeValueField(this);
        }
    }

    public Button getButton() {
        return this.bt;
    }

    public SensitiveComboBox getSCB() {
        return this.scb;
    }

    public String getValue() {
        return (String)this.scb.getValue();
    }

    public boolean isRegex() {
        return this.vm == ValueMode.REGEX;
    }

    public void setProtected(boolean p) {
        this.bt.setVisible(!p);
    }

    public void setValue(String value) {
        if (this.vm.equals((Object)ValueMode.REGEX) && !this.scb.containsId(value)) {
            this.scb.addItem(value);
            this.scb.setItemCaption(value, value + " (user defined)");
        }
        this.scb.setValue(value);
    }

    public void setValueMode(ValueMode vm) {
        if (!vm.equals((Object)this.vm)) {
            this.buildValues(vm);
        }
    }

    public void textChange(FieldEvents.TextChangeEvent event) {
        block11: {
            block10: {
                ReducingStringComparator rsc = this.sq.getRSC();
                String fm = this.sq.getFilterMechanism();
                if ("generic".equals(fm)) break block10;
                ConcurrentSkipListSet<String> notInYet = new ConcurrentSkipListSet<String>();
                String txt = event.getText();
                if (!txt.equals("")) {
                    this.scb.removeAllItems();
                    for (String s : this.values.keySet()) {
                        if (rsc.compare(s, txt, fm) == 0) {
                            this.scb.addItem(s);
                            continue;
                        }
                        notInYet.add(s);
                    }
                    for (String s : notInYet) {
                        if (!rsc.startsWith(s, txt, fm)) continue;
                        this.scb.addItem(s);
                        notInYet.remove(s);
                    }
                    for (String s : notInYet) {
                        if (!rsc.contains(s, txt, fm)) continue;
                        this.scb.addItem(s);
                    }
                } else {
                    this.buildValues(this.vm);
                }
                break block11;
            }
            String txt = event.getText();
            HashMap levdistvals = new HashMap();
            if (txt == null || txt.length() <= 1) break block11;
            this.scb.removeAllItems();
            for (String s : this.values.keySet()) {
                String txtWithoutAccents = ValueField.removeAccents(txt);
                String valueWithoutAccents = ValueField.removeAccents(s);
                if (txtWithoutAccents == null || valueWithoutAccents == null) continue;
                Integer d = StringUtils.getLevenshteinDistance((CharSequence)txtWithoutAccents.toLowerCase(), (CharSequence)valueWithoutAccents.toLowerCase());
                if (levdistvals.containsKey(d)) {
                    ((Collection)levdistvals.get(d)).add(s);
                }
                if (levdistvals.containsKey(d)) continue;
                TreeSet<String> newc = new TreeSet<String>();
                newc.add(s);
                levdistvals.put(d, newc);
            }
            TreeSet keys = new TreeSet(levdistvals.keySet());
            for (Integer k : keys.subSet(0, 10)) {
                ArrayList valueList = new ArrayList((Collection)levdistvals.get(k));
                Collections.sort(valueList, String.CASE_INSENSITIVE_ORDER);
                for (String v : valueList) {
                    this.scb.addItem(v);
                }
            }
        }
    }

    public static enum ValueMode {
        NORMAL,
        REGEX;

    }
}

