/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.flatquerybuilder;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.corpus_tools.annis.gui.flatquerybuilder.AddMenu;
import org.corpus_tools.annis.gui.flatquerybuilder.FlatQueryBuilder;
import org.corpus_tools.annis.gui.flatquerybuilder.SearchBox;

public class VerticalNode
extends Panel
implements Button.ClickListener {
    private static final long serialVersionUID = 6441255992529282153L;
    private static final String WIDTH = "180px";
    private Set<String> annonames;
    private FlatQueryBuilder sq;
    private Button btClose;
    private VerticalLayout v;
    private VerticalLayout vframe;
    private Collection<SearchBox> sboxes;
    private AddMenu am;

    public VerticalNode(String level, FlatQueryBuilder sq) {
        this(level, null, sq, true, false);
    }

    public VerticalNode(String ebene, String value, FlatQueryBuilder sq, boolean isRegex, boolean negativeSearch) {
        this.sq = sq;
        this.v = new VerticalLayout();
        this.v.setSpacing(true);
        this.vframe = new VerticalLayout();
        this.vframe.setSpacing(true);
        this.sboxes = new ArrayList<SearchBox>();
        this.btClose = new Button("X", (Button.ClickListener)this);
        this.btClose.setStyleName("small");
        SearchBox sb = new SearchBox(ebene, sq, this, isRegex, negativeSearch);
        if (value != null) {
            sb.setValue(value);
        }
        this.sboxes.add(sb);
        this.annonames = sq.getAvailableAnnotationNames();
        this.am = new AddMenu(sq, this, ebene);
        this.vframe.addComponent((Component)this.btClose);
        this.vframe.setComponentAlignment((Component)this.btClose, Alignment.TOP_RIGHT);
        this.v.addComponent((Component)sb);
        this.vframe.addComponent((Component)this.v);
        this.vframe.addComponent((Component)this.am);
        this.vframe.setComponentAlignment((Component)this.am, Alignment.BOTTOM_RIGHT);
        this.setWidth(WIDTH);
        this.setContent((Component)this.vframe);
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getButton() == this.btClose) {
            this.sq.removeVerticalNode(this);
            this.sq.updateQuery();
        }
    }

    public void createSearchBox(String ebene) {
        SearchBox sb = new SearchBox(ebene, this.sq, this);
        this.sboxes.add(sb);
        this.v.addComponent((Component)sb);
    }

    public Collection<String> getAnnonames() {
        return this.annonames;
    }

    public Collection<SearchBox> getSearchBoxes() {
        return this.sboxes;
    }

    public void removeSearchBox(SearchBox s) {
        this.v.removeComponent((Component)s);
        this.sboxes.remove((Object)s);
        this.annonames.add(s.getAttribute());
        this.am.reActivateItem(s.getAttribute());
    }
}

