/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.graphml;

import com.google.common.base.Splitter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.tuple.Pair;
import org.corpus_tools.annis.api.model.AnnotationComponentType;
import org.corpus_tools.annis.api.model.Component;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.util.SaltUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphMLMapper {
    private static final Logger log = LoggerFactory.getLogger(AbstractGraphMLMapper.class);

    protected static void mapLabels(SAnnotationContainer n, Map<String, String> labels, boolean isMeta) {
        for (Map.Entry<String, String> e : labels.entrySet()) {
            Pair qname = SaltUtil.splitQName((String)e.getKey());
            String name = (String)qname.getRight();
            if (name == null || name.isEmpty()) {
                log.warn("Replacing empty label name with '_' ({}:{}={})", new Object[]{qname.getLeft(), name, e.getValue()});
                name = "_";
            }
            if ("annis".equals(qname.getLeft()) && !"time".equals(name)) {
                n.createFeature((String)qname.getLeft(), name, (Object)e.getValue());
                continue;
            }
            if (isMeta) {
                n.createMetaAnnotation((String)qname.getLeft(), name, (Object)e.getValue());
                continue;
            }
            n.createAnnotation((String)qname.getLeft(), name, (Object)e.getValue());
        }
    }

    protected static Component parseComponent(String label) {
        Component result = new Component();
        if (label != null) {
            List splitted = Splitter.on((char)'/').limit(3).splitToList((CharSequence)label);
            result.setType(AnnotationComponentType.fromValue((String)splitted.get(0)));
            if (splitted.size() >= 1) {
                result.setLayer((String)splitted.get(1));
            } else {
                result.setLayer("");
            }
            if (splitted.size() >= 2) {
                result.setName((String)splitted.get(2));
            } else {
                result.setName("");
            }
        }
        return result;
    }

    protected void execute(File inputFile) throws IOException, XMLStreamException {
        XMLEventReader reader;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        factory.setProperty("javax.xml.stream.isValidating", false);
        try (FileInputStream fileInput = new FileInputStream(inputFile);){
            reader = factory.createXMLEventReader(new BufferedInputStream(fileInput));
            this.firstPass(reader);
        }
        fileInput = new FileInputStream(inputFile);
        var4_4 = null;
        try {
            reader = factory.createXMLEventReader(new BufferedInputStream(fileInput));
            this.secondPass(reader);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (fileInput != null) {
                if (var4_4 != null) {
                    try {
                        fileInput.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    fileInput.close();
                }
            }
        }
    }

    protected abstract void firstPass(XMLEventReader var1) throws XMLStreamException;

    protected void setNodeName(SNode newNode, String nodeName) {
        if (!nodeName.startsWith("salt:/")) {
            nodeName = "salt:/" + nodeName;
        }
        newNode.setId(nodeName);
        if (newNode.getPath().fragment() == null) {
            List<String> corpusPath = Helper.getCorpusPath(nodeName);
            newNode.setName(corpusPath.get(corpusPath.size() - 1));
        } else {
            newNode.setName(newNode.getPath().fragment());
        }
    }

    protected abstract void secondPass(XMLEventReader var1) throws XMLStreamException;

    protected abstract SGraph getGraph();

    protected void addNodeLayers() {
        LinkedList nodeList = new LinkedList(this.getGraph().getNodes());
        for (SNode n : nodeList) {
            SFeature featLayer = n.getFeature("annis", "layer");
            if (featLayer == null) continue;
            String layerName = featLayer.getValue_STEXT();
            List<SLayer> layer = this.getGraph().getLayerByName(layerName);
            if (layer == null || layer.isEmpty()) {
                SLayer newLayer = SaltFactory.createSLayer();
                newLayer.setName(layerName);
                this.getGraph().addLayer((Layer)newLayer);
                layer = Arrays.asList(newLayer);
            }
            ((SLayer)layer.get(0)).addNode((Node)n);
        }
    }

    protected void addEdgeLayers(Component component, SRelation<?, ?> rel) {
        String layerName = component.getLayer();
        if (layerName != null && !layerName.isEmpty()) {
            List<SLayer> layer = this.getGraph().getLayerByName(layerName);
            if (layer == null || layer.isEmpty()) {
                SLayer newLayer = SaltFactory.createSLayer();
                newLayer.setName(layerName);
                this.getGraph().addLayer((Layer)newLayer);
                layer = Arrays.asList(newLayer);
            }
            ((SLayer)layer.get(0)).addRelation(rel);
        }
    }
}

