/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.graphml;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.corpus_tools.annis.api.model.AnnotationComponentType;
import org.corpus_tools.annis.api.model.Component;
import org.corpus_tools.annis.gui.graphml.AbstractGraphMLMapper;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusDocumentRelation;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SCorpusRelation;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;

public class CorpusGraphMapper
extends AbstractGraphMLMapper {
    private final SCorpusGraph graph = SaltFactory.createSCorpusGraph();
    private final Set<String> hasIncomingPartOfEdge = new HashSet<String>();

    protected CorpusGraphMapper() {
    }

    public static SCorpusGraph map(File inputFile) throws IOException, XMLStreamException {
        CorpusGraphMapper mapper = new CorpusGraphMapper();
        mapper.execute(inputFile);
        return mapper.graph;
    }

    @Override
    protected void firstPass(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            StartElement element;
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement() || !"edge".equals((element = event.asStartElement()).getName().getLocalPart())) continue;
            Attribute target = element.getAttributeByName(new QName("target"));
            Attribute label = element.getAttributeByName(new QName("label"));
            if (label == null) continue;
            Component c = CorpusGraphMapper.parseComponent(label.getValue());
            if (target == null || c.getType() != AnnotationComponentType.PARTOF) continue;
            this.hasIncomingPartOfEdge.add(target.getValue());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    protected void secondPass(XMLEventReader reader) throws XMLStreamException {
        TreeMap<String, String> keys = new TreeMap<String, String>();
        int level = 0;
        boolean inGraph = false;
        Optional optional = Optional.empty();
        Optional optional2 = Optional.empty();
        Optional optional3 = Optional.empty();
        Optional optional4 = Optional.empty();
        Optional optional5 = Optional.empty();
        HashMap<String, String> data = new HashMap<String, String>();
        block31: while (true) {
            if (!reader.hasNext()) {
                this.addNodeLayers();
                return;
            }
            XMLEvent event = reader.nextEvent();
            switch (event.getEventType()) {
                case 1: {
                    ++level;
                    StartElement startElement = event.asStartElement();
                    switch (startElement.getName().getLocalPart()) {
                        case "graph": {
                            if (level != 2) break;
                            inGraph = true;
                            continue block31;
                        }
                        case "key": {
                            if (level != 2) break;
                            this.addAnnotationKey(keys, startElement);
                            continue block31;
                        }
                        case "node": {
                            if (!inGraph || level != 3) break;
                            Attribute id = startElement.getAttributeByName(new QName("id"));
                            if (id == null) continue block31;
                            Optional<String> optional6 = Optional.ofNullable(id.getValue());
                            continue block31;
                        }
                        case "edge": {
                            if (!inGraph || level != 3) break;
                            Attribute source = startElement.getAttributeByName(new QName("source"));
                            Attribute target = startElement.getAttributeByName(new QName("target"));
                            Attribute component = startElement.getAttributeByName(new QName("label"));
                            if (source == null || target == null || component == null) continue block31;
                            Optional<String> optional7 = Optional.ofNullable(source.getValue());
                            Optional<String> optional8 = Optional.ofNullable(target.getValue());
                            Optional<String> optional9 = Optional.ofNullable(component.getValue());
                            continue block31;
                        }
                        case "data": {
                            Attribute key = startElement.getAttributeByName(new QName("key"));
                            if (key == null) break;
                            Optional<String> optional10 = Optional.ofNullable(key.getValue());
                        }
                    }
                    continue block31;
                }
                case 4: {
                    void var6_10;
                    if (!var6_10.isPresent() || !inGraph || level != 4) continue block31;
                    String annoKey = (String)keys.get(var6_10.get());
                    if (annoKey == null) continue block31;
                    data.put(annoKey, event.asCharacters().getData());
                    break;
                }
                case 2: {
                    EndElement endElement = event.asEndElement();
                    switch (endElement.getName().getLocalPart()) {
                        case "graph": {
                            inGraph = false;
                            break;
                        }
                        case "node": {
                            void var5_6;
                            if (var5_6.isPresent() && "corpus".equals(data.get("annis::node_type"))) {
                                SNode n = this.mapNode((String)var5_6.get(), data);
                                this.graph.addNode((Node)n);
                            }
                            Optional optional11 = Optional.empty();
                            data.clear();
                            break;
                        }
                        case "edge": {
                            void var9_22;
                            void var8_18;
                            void var7_14;
                            if (var7_14.isPresent() && var8_18.isPresent() && var9_22.isPresent()) {
                                this.mapAndAddEdge((String)var7_14.get(), (String)var8_18.get(), (String)var9_22.get(), data);
                            }
                            Optional optional12 = Optional.empty();
                            Optional optional13 = Optional.empty();
                            Optional optional14 = Optional.empty();
                            data.clear();
                            break;
                        }
                        case "data": {
                            Optional optional15 = Optional.empty();
                            break;
                        }
                    }
                    --level;
                    continue block31;
                }
            }
        }
    }

    private void addAnnotationKey(Map<String, String> keys, StartElement event) {
        Attribute id = event.getAttributeByName(new QName("id"));
        Attribute annoKey = event.getAttributeByName(new QName("attr.name"));
        if (id != null && id.getValue() != null && annoKey != null && annoKey.getValue() != null) {
            keys.put(id.getValue(), annoKey.getValue());
        }
    }

    private SNode mapNode(String nodeName, Map<String, String> labels) {
        Object newNode = SaltFactory.createSNode();
        newNode = !this.hasIncomingPartOfEdge.contains(nodeName) ? SaltFactory.createSDocument() : SaltFactory.createSCorpus();
        this.setNodeName((SNode)newNode, nodeName);
        CorpusGraphMapper.mapLabels((SAnnotationContainer)newNode, labels, true);
        return newNode;
    }

    private void mapAndAddEdge(String sourceId, String targetId, String componentRaw, Map<String, String> labels) {
        SNode source = (SNode)this.graph.getNode("salt:/" + sourceId);
        SNode target = (SNode)this.graph.getNode("salt:/" + targetId);
        Component component = CorpusGraphMapper.parseComponent(componentRaw);
        if (source != null && target != null && source != target) {
            SCorpusDocumentRelation rel = null;
            switch (component.getType()) {
                case PARTOF: {
                    if (source instanceof SCorpus && target instanceof SDocument) {
                        SCorpusDocumentRelation corpusDocRel = SaltFactory.createSCorpusDocumentRelation();
                        corpusDocRel.setSource((Node)((SCorpus)source));
                        corpusDocRel.setTarget((Node)((SDocument)target));
                        this.graph.addRelation((Relation)corpusDocRel);
                        rel = corpusDocRel;
                        break;
                    }
                    if (!(source instanceof SCorpus) || !(target instanceof SCorpus)) break;
                    SCorpusRelation corpusDocRel = SaltFactory.createSCorpusRelation();
                    corpusDocRel.setSource((Node)((SCorpus)source));
                    corpusDocRel.setTarget((Node)((SCorpus)target));
                    this.graph.addRelation((Relation)corpusDocRel);
                    break;
                }
            }
            if (rel != null) {
                CorpusGraphMapper.mapLabels(rel, labels, false);
                this.addEdgeLayers(component, (SRelation<?, ?>)rel);
            }
        }
    }

    @Override
    protected SGraph getGraph() {
        return this.graph;
    }
}

