/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.media;

import com.vaadin.ui.Notification;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.corpus_tools.annis.gui.VisualizationToggle;
import org.corpus_tools.annis.gui.media.MediaController;
import org.corpus_tools.annis.gui.media.MediaPlayer;
import org.corpus_tools.annis.gui.visualizers.LoadableVisualizer;
import org.springframework.stereotype.Component;

@Component
public class MediaControllerImpl
implements MediaController,
Serializable {
    private static final long serialVersionUID = -140882365707323973L;
    private Map<String, List<MediaPlayer>> mediaPlayers;
    private Map<String, MediaPlayer> lastUsedPlayer;
    private Map<MediaPlayer, VisualizationToggle> visToggle;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public MediaControllerImpl() {
        this.lock.writeLock().lock();
        try {
            this.mediaPlayers = new TreeMap<String, List<MediaPlayer>>();
            this.lastUsedPlayer = new TreeMap<String, MediaPlayer>();
            this.visToggle = new HashMap<MediaPlayer, VisualizationToggle>();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMediaPlayer(MediaPlayer player, String resultID, VisualizationToggle toggle) {
        if (resultID == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            if (this.mediaPlayers.get(resultID) == null) {
                this.mediaPlayers.put(resultID, new LinkedList());
            }
            List<MediaPlayer> playerList = this.mediaPlayers.get(resultID);
            playerList.add(player);
            this.visToggle.put(player, toggle);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clearMediaPlayers() {
        this.lock.writeLock().lock();
        try {
            this.mediaPlayers.clear();
            this.visToggle.clear();
            this.lastUsedPlayer.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void closeOtherPlayers(MediaPlayer doNotCloseThisOne) {
        for (List<MediaPlayer> playersForID : this.mediaPlayers.values()) {
            for (MediaPlayer player : playersForID) {
                VisualizationToggle t;
                if (player == doNotCloseThisOne || (t = this.visToggle.get(player)) == null) continue;
                t.toggleVisualizer(false, null);
            }
        }
    }

    private MediaPlayer getPlayerForResult(String resultID) {
        List<MediaPlayer> allPlayers = this.mediaPlayers.get(resultID);
        if (allPlayers != null && allPlayers.size() > 0) {
            MediaPlayer lastPlayer = this.lastUsedPlayer.get(resultID);
            MediaPlayer player = lastPlayer == null ? allPlayers.get(0) : lastPlayer;
            return player;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(String resultID, double startTime) {
        boolean foundPlayer = false;
        this.lock.readLock().lock();
        try {
            MediaPlayer player = this.getPlayerForResult(resultID);
            if (player != null) {
                this.closeOtherPlayers(player);
                VisualizationToggle t = this.visToggle.get(player);
                if (t != null) {
                    foundPlayer = true;
                    t.toggleVisualizer(true, new CallbackImpl(player, startTime, null));
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (!foundPlayer) {
            Notification.show((String)"Could not play media.", (String)"If this is a match reference open the actual search interface by following the \"Show in ANNIS search interface\" link.", (Notification.Type)Notification.Type.WARNING_MESSAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(String resultID, double startTime, double endTime) {
        boolean foundPlayer = false;
        this.lock.readLock().lock();
        try {
            MediaPlayer player = this.getPlayerForResult(resultID);
            if (player != null) {
                this.closeOtherPlayers(player);
                VisualizationToggle t = this.visToggle.get(player);
                if (t != null) {
                    foundPlayer = true;
                    t.toggleVisualizer(true, new CallbackImpl(player, startTime, endTime));
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (!foundPlayer) {
            Notification.show((String)"Could not play media.", (String)"If this is a match reference open the actual search interface by following the \"Show in ANNIS search interface\" link.", (Notification.Type)Notification.Type.WARNING_MESSAGE);
        }
    }

    public static class CallbackImpl
    implements LoadableVisualizer.Callback {
        private static final long serialVersionUID = 4616384901428060301L;
        private MediaPlayer player;
        private Double startTime;
        private Double endTime;

        public CallbackImpl(MediaPlayer player, Double startTime, Double endTime) {
            this.player = player;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        @Override
        public void visualizerLoaded(LoadableVisualizer origin) {
            if (this.player != null && this.startTime != null) {
                if (this.endTime == null) {
                    this.player.play(this.startTime);
                } else {
                    this.player.play(this.startTime, this.endTime);
                }
            }
        }
    }
}

