/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.media;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.corpus_tools.annis.gui.media.PDFController;
import org.corpus_tools.annis.gui.media.PDFViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFControllerImpl
implements PDFController,
Serializable {
    private static final long serialVersionUID = -7818756895187729889L;
    private static final Logger log = LoggerFactory.getLogger(PDFControllerImpl.class);
    private transient Map<String, List<PDFViewer>> registeredPDFViewer;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPDF(String resultID, PDFViewer pdfViewer) {
        this.lock.writeLock().lock();
        try {
            if (this.registeredPDFViewer == null) {
                this.registeredPDFViewer = new HashMap<String, List<PDFViewer>>();
            }
            if (!this.registeredPDFViewer.containsKey(resultID)) {
                ArrayList pdfViewers = new ArrayList();
                this.registeredPDFViewer.put(resultID, pdfViewers);
            }
            this.registeredPDFViewer.get(resultID).add(pdfViewer);
            log.info("registered pdf viewer for result {} -> {}", (Object)resultID, (Object)pdfViewer);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openPDF(String resultID, String page) {
        block5: {
            this.lock.readLock().lock();
            try {
                if (this.registeredPDFViewer != null && this.registeredPDFViewer.containsKey(resultID)) {
                    for (PDFViewer pdfViewer : this.registeredPDFViewer.get(resultID)) {
                        pdfViewer.openPDFPage(page);
                    }
                    break block5;
                }
                throw new IllegalArgumentException("no pdf registered for this id: " + resultID);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @Override
    public int sizeOfRegisterdPDFViewer() {
        return this.registeredPDFViewer != null ? this.registeredPDFViewer.size() : 0;
    }
}

