/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.media;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.util.SaltUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeHelper {
    private static final Logger log = LoggerFactory.getLogger(TimeHelper.class);

    public static double[] getOverlappedTime(SNode node) {
        SGraph graph = node.getGraph();
        LinkedList<Double> startTimes = new LinkedList<Double>();
        LinkedList<Double> endTimes = new LinkedList<Double>();
        LinkedList<SToken> token = new LinkedList<SToken>();
        if (node instanceof SToken) {
            token.add((SToken)node);
        } else {
            List outRelations = graph.getOutRelations(node.getId());
            if (outRelations != null) {
                for (SRelation e : outRelations) {
                    if (!(e instanceof SSpanningRelation)) continue;
                    SToken tok = (SToken)((SSpanningRelation)e).getTarget();
                    token.add(tok);
                }
            }
        }
        for (SToken tok : token) {
            SAnnotation anno = tok.getAnnotation(SaltUtil.createQName((String)"annis", (String)"time"));
            if (anno == null || anno.getValue_STEXT() == null || anno.getValue_STEXT().isEmpty() || anno.getValue_STEXT().matches("\\-[0-9]*(\\.[0-9]*)?")) continue;
            try {
                String[] split = anno.getValue_STEXT().split("-");
                if (split.length == 1) {
                    startTimes.add(Double.parseDouble(split[0]));
                }
                if (split.length != 2) continue;
                startTimes.add(Double.parseDouble(split[0]));
                endTimes.add(Double.parseDouble(split[1]));
            }
            catch (NumberFormatException ex) {
                log.debug("Invalid time annotation", (Throwable)ex);
            }
        }
        if (startTimes.size() > 0 && endTimes.size() > 0) {
            return new double[]{(Double)Collections.min(startTimes), (Double)Collections.max(endTimes)};
        }
        if (startTimes.size() > 0) {
            return new double[]{(Double)Collections.min(startTimes)};
        }
        return new double[0];
    }
}

